/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.io.Serializable;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.RandomGenerator;
import org.jgap.UnsupportedRepresentationException;

public class BooleanGene
implements Gene,
Serializable {
    protected static final Boolean TRUE_BOOLEAN = new Boolean(true);
    protected static final Boolean FALSE_BOOLEAN = new Boolean(false);
    protected Boolean m_value = null;

    public Gene newGene(Configuration configuration) {
        return new BooleanGene();
    }

    public void setAllele(Object object) {
        this.m_value = (Boolean)object;
    }

    public String getPersistentRepresentation() throws UnsupportedOperationException {
        return this.toString();
    }

    public void setValueFromPersistentRepresentation(String string) throws UnsupportedRepresentationException {
        if (string != null) {
            if (string.equals("null")) {
                this.m_value = null;
            } else if (string.equals("true")) {
                this.m_value = TRUE_BOOLEAN;
            } else if (string.equals("false")) {
                this.m_value = FALSE_BOOLEAN;
            } else {
                throw new UnsupportedRepresentationException("Unknown boolean gene representation: " + string);
            }
        }
    }

    public Object getAllele() {
        return this.m_value;
    }

    public boolean booleanValue() {
        return this.m_value;
    }

    public void setToRandomValue(RandomGenerator randomGenerator) {
        this.m_value = randomGenerator.nextBoolean() ? TRUE_BOOLEAN : FALSE_BOOLEAN;
    }

    public int compareTo(Object object) {
        BooleanGene booleanGene = (BooleanGene)object;
        if (booleanGene == null) {
            return 1;
        }
        if (booleanGene.m_value == null) {
            return this.m_value == null ? 0 : 1;
        }
        if (!this.m_value.booleanValue()) {
            if (!booleanGene.m_value.booleanValue()) {
                return 0;
            }
            return -1;
        }
        if (booleanGene.m_value.booleanValue()) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object object) {
        try {
            return this.compareTo(object) == 0;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        if (this.m_value == null) {
            return 0;
        }
        return this.m_value.hashCode();
    }

    public String toString() {
        if (this.m_value == null) {
            return "null";
        }
        return this.m_value.toString();
    }

    public void cleanup() {
    }
}

