/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.RandomGenerator;
import org.jgap.UnsupportedRepresentationException;

public class IntegerGene
implements Gene,
Serializable {
    protected static final long INTEGER_RANGE = 0xFFFFFFFFL;
    protected static final String PERSISTENT_FIELD_DELIMITER = ":";
    protected Integer m_value = null;
    protected int m_upperBounds;
    protected int m_lowerBounds;
    protected long m_boundsUnitsToIntegerUnits;

    public IntegerGene() {
        this.m_lowerBounds = Integer.MIN_VALUE;
        this.m_upperBounds = Integer.MAX_VALUE;
        this.calculateBoundsUnitsToIntegerUnitsRatio();
    }

    public IntegerGene(int n, int n2) {
        this.m_lowerBounds = n;
        this.m_upperBounds = n2;
        this.calculateBoundsUnitsToIntegerUnitsRatio();
    }

    public Gene newGene(Configuration configuration) {
        return new IntegerGene(this.m_lowerBounds, this.m_upperBounds);
    }

    public void setAllele(Object object) {
        this.m_value = (Integer)object;
        this.mapValueToWithinBounds();
    }

    public String getPersistentRepresentation() throws UnsupportedOperationException {
        return this.toString() + PERSISTENT_FIELD_DELIMITER + this.m_lowerBounds + PERSISTENT_FIELD_DELIMITER + this.m_upperBounds;
    }

    public void setValueFromPersistentRepresentation(String string) throws UnsupportedRepresentationException {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, PERSISTENT_FIELD_DELIMITER);
            if (stringTokenizer.countTokens() != 3) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: it does not contain three tokens.");
            }
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            if (string2.equals("null")) {
                this.m_value = null;
            } else {
                try {
                    this.m_value = new Integer(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 1 does not appear to be an integer value.");
                }
            }
            try {
                this.m_lowerBounds = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 2 does not appear to be an integer value.");
            }
            try {
                this.m_upperBounds = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 3 does not appear to be an integer value.");
            }
            this.calculateBoundsUnitsToIntegerUnitsRatio();
        }
    }

    public Object getAllele() {
        return this.m_value;
    }

    public int intValue() {
        return this.m_value;
    }

    public void setToRandomValue(RandomGenerator randomGenerator) {
        this.m_value = new Integer(randomGenerator.nextInt());
        this.mapValueToWithinBounds();
    }

    public int compareTo(Object object) {
        IntegerGene integerGene = (IntegerGene)object;
        if (integerGene == null) {
            return 1;
        }
        if (integerGene.m_value == null) {
            return this.m_value == null ? 0 : 1;
        }
        try {
            return this.m_value.compareTo(integerGene.m_value);
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            throw classCastException;
        }
    }

    public boolean equals(Object object) {
        try {
            return this.compareTo(object) == 0;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        if (this.m_value == null) {
            return 0;
        }
        return this.m_value.hashCode();
    }

    public String toString() {
        if (this.m_value == null) {
            return "null";
        }
        return this.m_value.toString();
    }

    public void cleanup() {
    }

    protected void mapValueToWithinBounds() {
        if (this.m_value != null && (this.m_value > this.m_upperBounds || this.m_value < this.m_lowerBounds)) {
            long l = Integer.MIN_VALUE + (long)this.m_value.intValue();
            int n = (int)(l / this.m_boundsUnitsToIntegerUnits);
            this.m_value = new Integer(this.m_upperBounds + n);
        }
    }

    protected void calculateBoundsUnitsToIntegerUnitsRatio() {
        int n = this.m_upperBounds - this.m_lowerBounds + 1;
        this.m_boundsUnitsToIntegerUnits = n == 0 ? 0xFFFFFFFFL : 0xFFFFFFFFL / (long)n;
    }
}

