/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.List;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.GeneticOperator;
import org.jgap.RandomGenerator;

public class MutationOperator
implements GeneticOperator {
    protected int m_mutationRate;
    protected boolean m_dynamicMutationRate;

    public MutationOperator() {
        this.m_mutationRate = 0;
        this.m_dynamicMutationRate = true;
    }

    public MutationOperator(int n) {
        this.m_mutationRate = n;
        this.m_dynamicMutationRate = false;
    }

    public void operate(Configuration configuration, Chromosome[] chromosomeArray, List list) {
        if (this.m_mutationRate == 0 && !this.m_dynamicMutationRate) {
            return;
        }
        int n = this.m_dynamicMutationRate ? configuration.getChromosomeSize() * 10 : this.m_mutationRate;
        RandomGenerator randomGenerator = configuration.getRandomGenerator();
        int n2 = 0;
        while (n2 < chromosomeArray.length) {
            Gene[] geneArray = chromosomeArray[n2].getGenes();
            Chromosome chromosome = null;
            int n3 = 0;
            while (n3 < geneArray.length) {
                if (randomGenerator.nextInt(n) == 0) {
                    if (chromosome == null) {
                        chromosome = (Chromosome)chromosomeArray[n2].clone();
                        list.add(chromosome);
                        geneArray = chromosome.getGenes();
                    }
                    geneArray[n3].setToRandomValue(randomGenerator);
                }
                ++n3;
            }
            ++n2;
        }
    }
}

