/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.NaturalSelector;
import org.jgap.RandomGenerator;
import org.jgap.impl.Pool;
import org.jgap.impl.SlotCounter;

public class WeightedRouletteSelector
implements NaturalSelector {
    private Map m_wheel = new HashMap();
    private long m_totalNumberOfUsedSlots = 0L;
    private Pool m_counterPool = new Pool();

    public synchronized void add(Configuration configuration, Chromosome chromosome) {
        SlotCounter slotCounter = (SlotCounter)this.m_wheel.get(chromosome);
        if (slotCounter != null) {
            slotCounter.incrementByFitness();
        } else {
            chromosome.setIsSelectedForNextGeneration(false);
            slotCounter = (SlotCounter)this.m_counterPool.acquirePooledObject();
            if (slotCounter == null) {
                slotCounter = new SlotCounter();
            }
            slotCounter.reset(chromosome.getFitnessValue());
            this.m_wheel.put(chromosome, slotCounter);
        }
    }

    public synchronized Chromosome[] select(Configuration configuration, int n) {
        Object object;
        RandomGenerator randomGenerator = configuration.getRandomGenerator();
        Chromosome[] chromosomeArray = new Chromosome[n];
        Set set = this.m_wheel.entrySet();
        int n2 = set.size();
        int[] nArray = new int[n2];
        long[] lArray = new long[n2];
        Chromosome[] chromosomeArray2 = new Chromosome[n2];
        this.m_totalNumberOfUsedSlots = 0L;
        Iterator iterator = set.iterator();
        int n3 = 0;
        while (n3 < n2) {
            object = iterator.next();
            Chromosome chromosome = (Chromosome)object.getKey();
            SlotCounter slotCounter = (SlotCounter)object.getValue();
            nArray[n3] = slotCounter.getFitnessValue();
            lArray[n3] = slotCounter.getCounterValue();
            chromosomeArray2[n3] = chromosome;
            this.m_totalNumberOfUsedSlots += lArray[n3];
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            object = this.spinWheel(randomGenerator, nArray, lArray, chromosomeArray2);
            ((Chromosome)object).setIsSelectedForNextGeneration(true);
            chromosomeArray[n4] = object;
            ++n4;
        }
        return chromosomeArray;
    }

    private Chromosome spinWheel(RandomGenerator randomGenerator, int[] nArray, long[] lArray, Chromosome[] chromosomeArray) {
        long l = Math.abs(randomGenerator.nextLong() % this.m_totalNumberOfUsedSlots);
        long l2 = 0L;
        int n = 0;
        while (n < lArray.length) {
            if ((l2 += lArray[n]) > l) {
                int n2 = n;
                lArray[n2] = lArray[n2] - (long)nArray[n];
                this.m_totalNumberOfUsedSlots -= (long)nArray[n];
                return chromosomeArray[n];
            }
            ++n;
        }
        long l3 = 0L;
        int n3 = 0;
        while (n3 < lArray.length) {
            l3 += lArray[n3];
            ++n3;
        }
        throw new RuntimeException("Logic Error. This code should never be reached. Please report this as a bug to the JGAP team: selected slot " + l + " " + "exceeded " + l3 + " number of slots left. " + "We thought there were " + this.m_totalNumberOfUsedSlots + " slots left.");
    }

    public synchronized void empty() {
        this.m_counterPool.releaseAllObjects(this.m_wheel.values());
        this.m_wheel.clear();
        this.m_totalNumberOfUsedSlots = 0L;
    }
}

