/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.xml;

import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.InvalidConfigurationException;
import org.jgap.UnsupportedRepresentationException;
import org.jgap.xml.GeneCreationException;
import org.jgap.xml.ImproperXMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLManager {
    private static final String GENOTYPE_TAG = "genotype";
    private static final String CHROMOSOME_TAG = "chromosome";
    private static final String GENES_TAG = "genes";
    private static final String GENE_TAG = "gene";
    private static final String SIZE_ATTRIBUTE = "size";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final DocumentBuilder m_documentCreator;
    private static final Object m_lock;

    private XMLManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document representChromosomeAsDocument(Chromosome chromosome) {
        Document document;
        Object object = m_lock;
        synchronized (object) {
            document = m_documentCreator.newDocument();
        }
        Element element = XMLManager.representChromosomeAsElement(chromosome, document);
        document.appendChild(element);
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document representGenotypeAsDocument(Genotype genotype) {
        Document document;
        Object object = m_lock;
        synchronized (object) {
            document = m_documentCreator.newDocument();
        }
        Element element = XMLManager.representGenotypeAsElement(genotype, document);
        document.appendChild(element);
        return document;
    }

    public static Element representGenesAsElement(Gene[] geneArray, Document document) {
        Element element = document.createElement(GENES_TAG);
        int n = 0;
        while (n < geneArray.length) {
            Element element2 = document.createElement(GENE_TAG);
            element2.setAttribute(CLASS_ATTRIBUTE, geneArray[n].getClass().getName());
            Text text = document.createTextNode(geneArray[n].getPersistentRepresentation());
            element2.appendChild(text);
            element.appendChild(element2);
            ++n;
        }
        return element;
    }

    public static Element representChromosomeAsElement(Chromosome chromosome, Document document) {
        Element element = document.createElement(CHROMOSOME_TAG);
        element.setAttribute(SIZE_ATTRIBUTE, Integer.toString(chromosome.size()));
        Element element2 = XMLManager.representGenesAsElement(chromosome.getGenes(), document);
        element.appendChild(element2);
        return element;
    }

    public static Element representGenotypeAsElement(Genotype genotype, Document document) {
        Chromosome[] chromosomeArray = genotype.getChromosomes();
        Element element = document.createElement(GENOTYPE_TAG);
        element.setAttribute(SIZE_ATTRIBUTE, Integer.toString(chromosomeArray.length));
        int n = 0;
        while (n < chromosomeArray.length) {
            Element element2 = XMLManager.representChromosomeAsElement(chromosomeArray[n], document);
            element.appendChild(element2);
            ++n;
        }
        return element;
    }

    public static Gene[] getGenesFromElement(Configuration configuration, Element element) throws ImproperXMLException, UnsupportedRepresentationException, GeneCreationException {
        if (element == null || !element.getTagName().equals(GENES_TAG)) {
            throw new ImproperXMLException("Unable to build Chromosome instance from XML Element: given Element is not a 'genes' element.");
        }
        ArrayList<Gene> arrayList = new ArrayList<Gene>();
        NodeList nodeList = element.getElementsByTagName(GENE_TAG);
        if (nodeList == null) {
            throw new ImproperXMLException("Unable to build Gene instances from XML Element: 'gene' sub-elements not found.");
        }
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Gene gene;
            Element element2 = (Element)nodeList.item(n2);
            element2.normalize();
            String string = element2.getAttribute(CLASS_ATTRIBUTE);
            try {
                gene = (Gene)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new GeneCreationException(exception.getMessage());
            }
            NodeList nodeList2 = element2.getChildNodes();
            int n3 = nodeList2.getLength();
            String string2 = null;
            int n4 = 0;
            while (n4 < n3) {
                if (nodeList2.item(n4).getNodeType() == 3) {
                    string2 = nodeList2.item(n4).getNodeValue();
                    break;
                }
                ++n4;
            }
            if (string2 == null) {
                throw new ImproperXMLException("Unable to build Gene instance from XML Element: value (allele) is missing representation.");
            }
            try {
                gene.setValueFromPersistentRepresentation(string2);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                throw new GeneCreationException("Unable to build Gene because it does not support the setValueFromPersistentRepresentation() method.");
            }
            arrayList.add(gene);
            ++n2;
        }
        return arrayList.toArray(new Gene[arrayList.size()]);
    }

    public static Chromosome getChromosomeFromElement(Configuration configuration, Element element) throws ImproperXMLException, InvalidConfigurationException, UnsupportedRepresentationException, GeneCreationException {
        if (element == null || !element.getTagName().equals(CHROMOSOME_TAG)) {
            throw new ImproperXMLException("Unable to build Chromosome instance from XML Element: given Element is not a 'chromosome' element.");
        }
        Element element2 = (Element)element.getElementsByTagName(GENES_TAG).item(0);
        if (element2 == null) {
            throw new ImproperXMLException("Unable to build Chromosome instance from XML Element: 'genes' sub-element not found.");
        }
        Gene[] geneArray = XMLManager.getGenesFromElement(configuration, element2);
        return new Chromosome(configuration, geneArray);
    }

    public static Genotype getGenotypeFromElement(Configuration configuration, Element element) throws ImproperXMLException, InvalidConfigurationException, UnsupportedRepresentationException, GeneCreationException {
        if (element == null || !element.getTagName().equals(GENOTYPE_TAG)) {
            throw new ImproperXMLException("Unable to build Genotype instance from XML Element: given Element is not a 'genotype' element.");
        }
        NodeList nodeList = element.getElementsByTagName(CHROMOSOME_TAG);
        int n = nodeList.getLength();
        Chromosome[] chromosomeArray = new Chromosome[n];
        int n2 = 0;
        while (n2 < n) {
            chromosomeArray[n2] = XMLManager.getChromosomeFromElement(configuration, (Element)nodeList.item(n2));
            ++n2;
        }
        return new Genotype(configuration, chromosomeArray);
    }

    public static Genotype getGenotypeFromDocument(Configuration configuration, Document document) throws ImproperXMLException, InvalidConfigurationException, UnsupportedRepresentationException, GeneCreationException {
        Element element = document.getDocumentElement();
        if (element == null || !element.getTagName().equals(GENOTYPE_TAG)) {
            throw new ImproperXMLException("Unable to build Genotype from XML Document: 'genotype' element must be at root of document.");
        }
        return XMLManager.getGenotypeFromElement(configuration, element);
    }

    public static Chromosome getChromosomeFromDocument(Configuration configuration, Document document) throws ImproperXMLException, InvalidConfigurationException, UnsupportedRepresentationException, GeneCreationException {
        Element element = document.getDocumentElement();
        if (element == null || !element.getTagName().equals(CHROMOSOME_TAG)) {
            throw new ImproperXMLException("Unable to build Chromosome instance from XML Document: 'chromosome' element must be at root of Document.");
        }
        return XMLManager.getChromosomeFromElement(configuration, element);
    }

    static {
        m_lock = new Object();
        try {
            m_documentCreator = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("XMLManager: Unable to setup DocumentBuilder: " + parserConfigurationException.getMessage());
        }
    }
}

