/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;

public class BasicMarqueeHandler {
    protected transient Cursor previousCursor = null;
    protected Rectangle2D marqueeBounds;
    protected Point2D startPoint;
    protected Point2D currentPoint;

    public boolean isForceMarqueeEvent(MouseEvent mouseEvent) {
        return mouseEvent.isAltDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            if (mouseEvent != null && this.marqueeBounds != null) {
                if (!(mouseEvent.getSource() instanceof JGraph)) {
                    throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + mouseEvent);
                }
                JGraph jGraph = (JGraph)mouseEvent.getSource();
                Rectangle2D rectangle2D = jGraph.fromScreen((Rectangle2D)this.marqueeBounds.clone());
                CellView[] cellViewArray = jGraph.getGraphLayoutCache().getRoots(rectangle2D);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                int n = 0;
                while (n < cellViewArray.length) {
                    if (rectangle2D.contains(cellViewArray[n].getBounds())) {
                        arrayList.add(cellViewArray[n].getCell());
                    }
                    ++n;
                }
                Object[] objectArray = arrayList.toArray();
                jGraph.getUI().selectCellsForEvent(jGraph, objectArray, mouseEvent);
                jGraph.setCursor(this.previousCursor);
                Rectangle rectangle = new Rectangle((int)this.marqueeBounds.getX(), (int)this.marqueeBounds.getY(), (int)this.marqueeBounds.getWidth() + 1, (int)this.marqueeBounds.getHeight() + 1);
                ++rectangle.width;
                ++rectangle.height;
                jGraph.repaint(rectangle);
            }
        }
        finally {
            this.currentPoint = null;
            this.startPoint = null;
            this.marqueeBounds = null;
            this.previousCursor = null;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.startPoint != null) {
            if (!(mouseEvent.getSource() instanceof JGraph)) {
                throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + mouseEvent);
            }
            JGraph jGraph = (JGraph)mouseEvent.getSource();
            Graphics graphics = jGraph.getGraphics();
            Color color = jGraph.getBackground();
            Color color2 = jGraph.getMarqueeColor();
            graphics.setColor(color2);
            graphics.setXORMode(color);
            this.overlay(graphics);
            this.currentPoint = mouseEvent.getPoint();
            this.marqueeBounds = new Rectangle2D.Double(this.startPoint.getX(), this.startPoint.getY(), 0.0, 0.0);
            this.marqueeBounds.add(this.currentPoint);
            graphics.setColor(color);
            graphics.setXORMode(color2);
            this.overlay(graphics);
        }
    }

    public void paint(Graphics graphics) {
        this.overlay(graphics);
    }

    public void overlay(Graphics graphics) {
        if (this.marqueeBounds != null) {
            graphics.drawRect((int)this.marqueeBounds.getX(), (int)this.marqueeBounds.getY(), (int)this.marqueeBounds.getWidth(), (int)this.marqueeBounds.getHeight());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!(mouseEvent.getSource() instanceof JGraph)) {
            throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + mouseEvent);
        }
        JGraph jGraph = (JGraph)mouseEvent.getSource();
        this.startPoint = mouseEvent.getPoint();
        this.marqueeBounds = new Rectangle2D.Double(this.startPoint.getX(), this.startPoint.getY(), 0.0, 0.0);
        this.previousCursor = jGraph.getCursor();
        jGraph.setCursor(new Cursor(1));
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public Point2D getCurrentPoint() {
        return this.currentPoint;
    }

    public Rectangle2D getMarqueeBounds() {
        return this.marqueeBounds;
    }

    public Cursor getPreviousCursor() {
        return this.previousCursor;
    }

    public Point2D getStartPoint() {
        return this.startPoint;
    }

    public void setCurrentPoint(Point2D point2D) {
        this.currentPoint = point2D;
    }

    public void setMarqueeBounds(Rectangle2D rectangle2D) {
        this.marqueeBounds = rectangle2D;
    }

    public void setPreviousCursor(Cursor cursor) {
        this.previousCursor = cursor;
    }

    public void setStartPoint(Point2D point2D) {
        this.startPoint = point2D;
    }
}

