/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jgraph.JGraph;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexRenderer;
import org.jgraph.plaf.GraphUI;
import org.jgraph.plaf.basic.BasicGraphUI;

public class VertexView
extends AbstractCellView {
    public static VertexRenderer renderer = new VertexRenderer();
    protected Rectangle2D bounds;
    protected Rectangle2D groupBounds = DefaultGraphCell.defaultBounds;
    public static transient int[] defaultCursors = new int[]{6, 8, 7, 10, 11, 4, 9, 5};
    public static transient int[] xCursors = new int[]{10, 0, 11, 10, 11, 10, 0, 11};
    public static transient int[] yCursors = new int[]{8, 8, 8, 0, 0, 9, 9, 9};

    public VertexView(Object object, JGraph jGraph, CellMapper cellMapper) {
        super(object, jGraph, cellMapper);
    }

    public void update() {
        super.update();
        this.bounds = GraphConstants.getBounds(this.allAttributes);
        this.groupBounds = null;
    }

    public void childUpdated() {
        super.childUpdated();
        this.groupBounds = null;
    }

    public Rectangle2D getBounds() {
        if (!this.isLeaf()) {
            if (this.groupBounds == null) {
                this.updateGroupBounds();
            }
            return this.groupBounds;
        }
        return this.bounds;
    }

    public Rectangle2D getCachedBounds() {
        return this.bounds;
    }

    public void setCachedBounds(Rectangle2D rectangle2D) {
        this.bounds = rectangle2D;
    }

    protected void updateGroupBounds() {
        CellView[] cellViewArray = this.getChildViews();
        LinkedList<CellView> linkedList = new LinkedList<CellView>();
        int n = 0;
        while (n < cellViewArray.length) {
            if (this.includeInGroupBounds(cellViewArray[n])) {
                linkedList.add(cellViewArray[n]);
            }
            ++n;
        }
        cellViewArray = new CellView[linkedList.size()];
        linkedList.toArray(cellViewArray);
        this.groupBounds = AbstractCellView.getBounds(cellViewArray);
    }

    private boolean includeInGroupBounds(CellView cellView) {
        if (cellView instanceof EdgeView) {
            GraphModel graphModel = this.graph.getModel();
            EdgeView edgeView = (EdgeView)cellView;
            if (edgeView.getCell() instanceof DefaultMutableTreeNode) {
                TreeNode treeNode;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)edgeView.getCell();
                if (graphModel.getSource(defaultMutableTreeNode) instanceof TreeNode && ((DefaultMutableTreeNode)(treeNode = (TreeNode)graphModel.getSource(defaultMutableTreeNode)).getParent()).isNodeDescendant(defaultMutableTreeNode)) {
                    return false;
                }
                if (graphModel.getTarget(defaultMutableTreeNode) instanceof TreeNode && ((DefaultMutableTreeNode)(treeNode = (TreeNode)graphModel.getTarget(defaultMutableTreeNode)).getParent()).isNodeDescendant(defaultMutableTreeNode)) {
                    return false;
                }
            }
        }
        return true;
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public CellHandle getHandle(GraphContext graphContext) {
        if (GraphConstants.isSizeable(this.getAllAttributes()) && graphContext.getGraph().isSizeable()) {
            return new SizeHandle(this, graphContext);
        }
        return null;
    }

    public Point2D getCenterPoint() {
        Rectangle2D rectangle2D = this.getBounds();
        return this.getAttributes().createPoint(rectangle2D.getCenterX(), rectangle2D.getCenterY());
    }

    public Point2D getPerimeterPoint(Point2D point2D, Point2D point2D2) {
        return renderer.getPerimeterPoint(this, point2D, point2D2);
    }

    public static class SizeHandle
    implements CellHandle,
    Serializable {
        protected transient Image offscreen;
        protected transient Graphics offgraphics;
        protected transient boolean firstDrag = true;
        protected transient JGraph graph;
        protected transient VertexView vertex;
        protected transient CellView[] portViews;
        protected transient Rectangle2D cachedBounds;
        protected transient GraphContext context;
        protected transient Rectangle2D initialBounds;
        protected transient CellView[] contextViews;
        protected transient int index = -1;
        protected transient Rectangle2D[] r = new Rectangle2D[8];
        protected boolean firstOverlayInvocation = true;
        public transient int[] cursors = null;

        public SizeHandle(VertexView vertexView, GraphContext graphContext) {
            this.graph = graphContext.getGraph();
            this.vertex = vertexView;
            int n = GraphConstants.getSizeableAxis(this.vertex.getAllAttributes());
            this.cursors = n == 1 ? xCursors : (n == 2 ? yCursors : defaultCursors);
            this.portViews = graphContext.createTemporaryPortViews();
            this.initialBounds = (Rectangle2D)this.vertex.getBounds().clone();
            this.context = graphContext;
            int n2 = 0;
            while (n2 < this.r.length) {
                this.r[n2] = this.vertex.getAttributes().createRect();
                ++n2;
            }
            this.invalidate();
        }

        public boolean isConstrainedSizeEvent(MouseEvent mouseEvent) {
            GraphUI graphUI = this.graph.getUI();
            if (graphUI instanceof BasicGraphUI) {
                return ((BasicGraphUI)graphUI).isConstrainedMoveEvent(mouseEvent);
            }
            return false;
        }

        public void paint(Graphics graphics) {
            this.invalidate();
            graphics.setColor(this.graph.getHandleColor());
            int n = 0;
            while (n < this.r.length) {
                if (this.cursors[n] != 0) {
                    graphics.fill3DRect((int)this.r[n].getX(), (int)this.r[n].getY(), (int)this.r[n].getWidth(), (int)this.r[n].getHeight(), true);
                }
                ++n;
            }
        }

        protected void initOffscreen() {
            try {
                Rectangle rectangle = this.graph.getBounds();
                this.offscreen = new BufferedImage(rectangle.width, rectangle.height, 1);
                this.offgraphics = this.offscreen.getGraphics();
                this.offgraphics.setClip(0, 0, rectangle.width, rectangle.height);
                this.offgraphics.setColor(this.graph.getBackground());
                this.offgraphics.fillRect(0, 0, rectangle.width, rectangle.height);
                this.graph.getUI().paint(this.offgraphics, this.graph);
            }
            catch (Error error) {
                this.offscreen = null;
                this.offgraphics = null;
            }
        }

        public void overlay(Graphics graphics) {
            if (!this.firstOverlayInvocation) {
                if (this.cachedBounds != null) {
                    graphics.setColor(Color.black);
                    Rectangle2D rectangle2D = this.graph.toScreen((Rectangle2D)this.cachedBounds.clone());
                    graphics.drawRect((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth() - 2, (int)rectangle2D.getHeight() - 2);
                } else if (!this.initialBounds.equals(this.vertex.getBounds())) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    AffineTransform affineTransform = graphics2D.getTransform();
                    graphics2D.scale(this.graph.getScale(), this.graph.getScale());
                    this.graph.getUI().paintCell(graphics, this.vertex, this.vertex.getBounds(), true);
                    if (this.contextViews != null) {
                        int n = 0;
                        while (n < this.contextViews.length) {
                            this.graph.getUI().paintCell(graphics, this.contextViews[n], this.contextViews[n].getBounds(), true);
                            ++n;
                        }
                    }
                    graphics2D.setTransform(affineTransform);
                    if (this.portViews != null && this.graph.isPortsVisible()) {
                        this.graph.getUI().paintPorts(graphics, this.portViews);
                    }
                }
            }
            this.firstOverlayInvocation = false;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.vertex != null) {
                int n = 0;
                while (n < this.r.length) {
                    if (this.r[n].contains(mouseEvent.getPoint())) {
                        this.graph.setCursor(new Cursor(this.cursors[n]));
                        mouseEvent.consume();
                        return;
                    }
                    ++n;
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.graph.isSizeable()) {
                return;
            }
            int n = 0;
            while (n < this.r.length) {
                if (this.r[n].contains(mouseEvent.getPoint()) && this.cursors[n] != 0) {
                    HashSet<Object> hashSet = new HashSet<Object>();
                    hashSet.add(this.vertex.getCell());
                    this.contextViews = this.context.createTemporaryContextViews(hashSet);
                    CellView[] cellViewArray = AbstractCellView.getDescendantViews(new CellView[]{this.vertex});
                    if (cellViewArray.length >= BasicGraphUI.MAXHANDLES) {
                        this.cachedBounds = (Rectangle2D)this.initialBounds.clone();
                    }
                    mouseEvent.consume();
                    this.index = n;
                    return;
                }
                ++n;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            Object object;
            Graphics graphics;
            if (this.firstDrag && this.graph.isDoubleBuffered() && this.cachedBounds == null) {
                this.initOffscreen();
                this.firstDrag = false;
            }
            Rectangle2D rectangle2D = null;
            Graphics graphics2 = graphics = this.offgraphics != null ? this.offgraphics : this.graph.getGraphics();
            if (this.index == -1) {
                return;
            }
            Rectangle2D rectangle2D2 = this.computeBounds(mouseEvent);
            graphics.setColor(this.graph.getForeground());
            graphics.setXORMode(this.graph.getBackground().darker());
            this.overlay(graphics);
            if (this.offgraphics != null) {
                rectangle2D = this.graph.toScreen((Rectangle2D)this.vertex.getBounds().clone());
                object = this.graph.toScreen(AbstractCellView.getBounds(this.contextViews));
                if (object != null) {
                    rectangle2D.add((Rectangle2D)object);
                }
            }
            if (this.cachedBounds != null) {
                this.cachedBounds = rectangle2D2;
            } else {
                object = AbstractCellView.getDescendantViews(new CellView[]{this.vertex});
                n = 0;
                while (n < ((CellView[])object).length) {
                    CellView cellView = this.graph.getGraphLayoutCache().getMapping(object[n].getCell(), false);
                    AttributeMap attributeMap = (AttributeMap)cellView.getAllAttributes().clone();
                    object[n].setAttributes(attributeMap);
                    object[n].refresh(false);
                    ++n;
                }
                this.vertex.setBounds(rectangle2D2);
                if (this.vertex != null) {
                    this.graph.getGraphLayoutCache().update(this.vertex);
                }
                if (this.contextViews != null) {
                    this.graph.getGraphLayoutCache().update(this.contextViews);
                }
            }
            this.overlay(graphics);
            if (this.offscreen != null) {
                rectangle2D.add(this.graph.toScreen((Rectangle2D)this.vertex.getBounds().clone()));
                object = this.graph.toScreen(AbstractCellView.getBounds(this.contextViews));
                if (object != null) {
                    rectangle2D.add((Rectangle2D)object);
                }
                n = 2;
                rectangle2D.setFrame(rectangle2D.getX() - (double)n, rectangle2D.getY() - (double)n, rectangle2D.getWidth() + (double)(n * 2), rectangle2D.getHeight() + (double)(n * 2));
                double d = Math.max(0.0, rectangle2D.getX());
                double d2 = Math.max(0.0, rectangle2D.getY());
                double d3 = d + rectangle2D.getWidth();
                double d4 = d2 + rectangle2D.getHeight();
                this.graph.getGraphics().drawImage(this.offscreen, (int)d, (int)d2, (int)d3, (int)d4, (int)d, (int)d2, (int)d3, (int)d4, this.graph);
            }
        }

        protected Rectangle2D computeBounds(MouseEvent mouseEvent) {
            double d = this.initialBounds.getX();
            double d2 = this.initialBounds.getX() + this.initialBounds.getWidth() - 1.0;
            double d3 = this.initialBounds.getY();
            double d4 = this.initialBounds.getY() + this.initialBounds.getHeight() - 1.0;
            Point2D point2D = this.graph.fromScreen(this.graph.snap((Point2D)mouseEvent.getPoint().clone()));
            point2D.setLocation(Math.max(0.0, point2D.getX()), Math.max(0.0, point2D.getY()));
            if (this.index > 4) {
                d4 = point2D.getY();
            } else if (this.index < 3) {
                d3 = point2D.getY();
            }
            if (this.index == 0 || this.index == 3 || this.index == 5) {
                d = point2D.getX();
            } else if (this.index == 2 || this.index == 4 || this.index == 7) {
                d2 = point2D.getX();
            }
            double d5 = d2 - d;
            double d6 = d4 - d3;
            if (this.isConstrainedSizeEvent(mouseEvent)) {
                if (this.index == 3 || this.index == 4 || this.index == 5) {
                    d6 = d5;
                } else if (this.index == 1 || this.index == 6 || this.index == 2 || this.index == 7) {
                    d5 = d6;
                } else {
                    d6 = d5;
                    d3 = d4 - d6;
                }
            }
            if (d5 < 0.0) {
                d += d5;
                d5 = Math.abs(d5);
            }
            if (d6 < 0.0) {
                d3 += d6;
                d6 = Math.abs(d6);
            }
            return this.vertex.getAttributes().createRect(d, d3, d5 + 1.0, d6 + 1.0);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.index != -1) {
                this.cachedBounds = this.computeBounds(mouseEvent);
                this.vertex.setBounds(this.cachedBounds);
                Object[] objectArray = AbstractCellView.getDescendantViews(new CellView[]{this.vertex});
                Map map = GraphConstants.createAttributes(objectArray, null);
                this.graph.getGraphLayoutCache().edit(map, null, null, null);
            }
            mouseEvent.consume();
            this.cachedBounds = null;
            this.initialBounds = null;
            this.firstDrag = true;
        }

        private void invalidate() {
            Rectangle2D rectangle2D = this.graph.getCellBounds(this.vertex.getCell());
            if (rectangle2D != null) {
                rectangle2D = (Rectangle2D)rectangle2D.clone();
                this.graph.toScreen(rectangle2D);
                int n = this.graph.getHandleSize();
                int n2 = 2 * n;
                double d = rectangle2D.getX() - (double)n;
                double d2 = rectangle2D.getY() - (double)n;
                double d3 = rectangle2D.getX() + rectangle2D.getWidth() / 2.0 - (double)n;
                double d4 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - (double)n;
                double d5 = rectangle2D.getX() + rectangle2D.getWidth() - (double)n;
                double d6 = rectangle2D.getY() + rectangle2D.getHeight() - (double)n;
                this.r[0].setFrame(d, d2, n2, n2);
                this.r[1].setFrame(d3, d2, n2, n2);
                this.r[2].setFrame(d5, d2, n2, n2);
                this.r[3].setFrame(d, d4, n2, n2);
                this.r[4].setFrame(d5, d4, n2, n2);
                this.r[5].setFrame(d, d6, n2, n2);
                this.r[6].setFrame(d3, d6, n2, n2);
                this.r[7].setFrame(d5, d6, n2, n2);
            }
        }
    }
}

