/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.eav;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.mitre.lattice.query.LatticeQuery;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.User;

public abstract class EavElement {
    private String QUERY_INIT = "";
    private String query = "";
    private String elementType = "";
    private MraldConnection conn = null;
    private ResultSet rs = null;
    private int colCount = 0;
    private boolean printVert = false;
    protected String whereAnd = "";
    private String colName = "";
    private String colValue = "";
    private String displayColumn = "";
    protected boolean hasDiv = false;
    protected boolean endReached = false;
    protected String endSection = "";
    protected String sortBy;
    protected boolean isTable = true;
    private User user;

    public EavElement() throws MraldException {
        this.elementType = "EAV";
        this.whereAnd = " WHERE ";
        this.init();
    }

    public EavElement(String elementType) throws MraldException {
        this.elementType = elementType;
        this.whereAnd = " WHERE ";
        this.init();
    }

    public EavElement(String elementType, MraldConnection conn) throws MraldException {
        this.conn = conn;
        this.elementType = elementType;
        this.whereAnd = " WHERE ";
        this.init();
    }

    public void runQuery() throws MraldException {
        this.rs = this.runQuery(this.query);
    }

    public void setConnection(MraldConnection thisConn) {
        this.conn = thisConn;
    }

    public MraldConnection getConnection() {
        return this.conn;
    }

    public String selectHtml() throws MraldException {
        StringBuffer ret = new StringBuffer();
        try {
            this.rs = this.runQuery(this.query);
            if (this.colCount < 1) {
                ResultSetMetaData rsmd = this.rs.getMetaData();
                this.colCount = rsmd.getColumnCount();
            }
            int i = 0;
            while (this.rs.next()) {
                ret.append(this.outputRow(this.colCount));
                ret.append(this.endOutputRow());
                if (++i != 1) continue;
                this.setColValue(this.rs.getString(this.colName));
            }
            return ret.toString();
        }
        catch (SQLException s) {
            throw new MraldException("Query " + this.query + "produced the following exception: " + s.getMessage());
        }
    }

    protected User getUser() {
        return this.user;
    }

    public void setUser(User user) throws MraldException {
        this.user = user;
        this.setQuery(this.appendToQuery(this.query, user));
    }

    public String selectHtmlSingle() throws MraldException {
        StringBuffer ret = new StringBuffer();
        try {
            if (this.rs == null) {
                this.rs = this.runQuery(this.query);
                this.colCount = 1;
            }
            if (this.endReached) {
                this.rs = this.runQuery(this.query);
                this.colCount = 1;
            }
            if (!this.rs.next()) {
                this.endReached = true;
                return null;
            }
            ret.append(this.outputRow(this.colCount));
            this.endReached = false;
            this.setColValue(this.rs.getString(this.colName));
            return ret.toString();
        }
        catch (SQLException s) {
            throw new MraldException("Query " + this.query + "produced the following exception: " + s.getMessage());
        }
    }

    protected String endHtmlSingle() throws MraldException {
        return this.endSection;
    }

    protected abstract void init() throws MraldException;

    protected final String appendToQuery(String query, User user) throws MraldException {
        String newQuery = LatticeQuery.adaptQuery(query, user);
        return newQuery;
    }

    protected abstract StringBuffer outputRow(int var1) throws MraldException;

    protected StringBuffer endOutputRow() throws MraldException {
        return new StringBuffer();
    }

    public ResultSet runQuery(String htmlquery) throws MraldException {
        try {
            if (this.conn == null) {
                this.conn = new MraldConnection();
            }
            this.rs = this.conn.executeQuery(htmlquery);
            return this.rs;
        }
        catch (SQLException s) {
            throw new MraldException("Query failed:  " + htmlquery, s);
        }
    }

    public String insertHtml() throws MraldException {
        StringBuffer ret = new StringBuffer();
        return ret.toString();
    }

    public String deleteHtml() {
        StringBuffer ret = new StringBuffer();
        return ret.toString();
    }

    public String updateHtml() {
        StringBuffer ret = new StringBuffer();
        return ret.toString();
    }

    public void setInitQuery(String initQuery) {
        this.QUERY_INIT = initQuery;
        this.query = initQuery;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean getDiv() {
        return this.hasDiv;
    }

    public void setColName(String thisColName) {
        this.colName = thisColName;
    }

    public void setSortBy(String thisSortBy) {
        this.sortBy = thisSortBy;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public String getColName() {
        return this.colName;
    }

    public void setColValue(String colValue) {
        this.colValue = colValue;
    }

    public String getColValue() {
        return this.colValue;
    }

    public void setDisplayColumn(String thisColumn) {
        this.displayColumn = thisColumn;
    }

    public String getDisplayColumn() {
        return this.displayColumn;
    }

    public void setPrintVert(boolean printVert) {
        this.printVert = printVert;
    }

    public boolean getPrintVert() {
        return this.printVert;
    }

    int getColCount() {
        return this.colCount;
    }

    String getType() {
        return this.elementType;
    }

    void setColCount(int thisCount) {
        this.colCount = thisCount;
    }

    protected ResultSet getRs() {
        return this.rs;
    }

    public void close() throws MraldException {
        try {
            if (this.rs != null) {
                this.rs.close();
                this.rs = null;
            }
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException s) {
            throw new MraldException(s);
        }
    }

    public void setParams(String columnName, String value) {
        this.whereAnd = this.QUERY_INIT.toUpperCase().indexOf(" WHERE ") > 0 ? " AND " : " WHERE ";
        value = MiscUtils.checkApostrophe(value);
        this.query = this.QUERY_INIT + this.whereAnd + columnName + " = '" + value + "'";
    }

    public void setParams(String tableName, String columnName, String value) {
        this.whereAnd = this.QUERY_INIT.toUpperCase().indexOf(" WHERE ") > 0 ? " AND " : " WHERE ";
        value = MiscUtils.checkApostrophe(value);
        this.query = this.QUERY_INIT + this.whereAnd + tableName + "." + columnName + " = '" + value + "'";
    }

    public void addSort(String columnName) {
        this.sortBy = columnName;
        this.query = this.query + " ORDER BY " + columnName;
    }

    public void addParams(String columnName, String value) {
        this.whereAnd = this.query.indexOf(this.whereAnd) > 0 ? " AND " : " WHERE ";
        value = MiscUtils.checkApostrophe(value);
        this.query = this.query + this.whereAnd + columnName + " = '" + value + "'";
    }

    public void addParams(String tableName, String columnName, String value) {
        this.whereAnd = this.query.indexOf(this.whereAnd) > 0 ? " AND " : " WHERE ";
        value = MiscUtils.checkApostrophe(value);
        this.query = this.query + this.whereAnd + tableName + "." + columnName + " = '" + value + "'";
    }

    public void setIsTable(boolean setIsTable) {
        this.isTable = setIsTable;
    }

    public boolean getIsTable() {
        return this.isTable;
    }

    public void finalize() throws Throwable {
        this.close();
    }
}

