/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.eav;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.mitre.lattice.eav.EavElement;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.User;

public class EavListTag
extends BodyTagSupport {
    String className;
    String howMany;
    String title;
    private EavElement eavElement = null;
    boolean hasTitle = false;
    int number;
    static final String SECTION_CLOSE = "</div>\n";
    static final String SECTION_TABLE_CLOSE = "</td></tr></table></td></tr></table>\n";
    static final String SECTION_OPENER_TEMPLATE = "<div class=\"leftSideBar\"><p class=\"sideBarTitle\" ><:title:></p>";
    static final String SECTION_TABLE_OPENER_TEMPLATE = "<table summary=\"\" width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td class=\"bord\"><table summary=\"\" width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"2\"><tr><th colspan=\"<:colspan:>\"><:title:></th></tr><tr><td colspan=\"<:colspan:>\">\n";
    static final String INSERT_ACTION = "Insert";
    static final String UPDATE_ACTION = "Update";
    static final String SELECT_ACTION = "Select";
    String action = "Select";
    String[] colNames = new String[1];
    String[] colValues = new String[1];
    String sortBy;
    EavListTag child = null;
    private String displayColumn = null;
    private String closingTag = "";
    private String closeTag = "";
    private String startTag = "";
    private boolean isTable = true;
    private User user;

    public EavListTag() {
        if (this.isTable) {
            this.startTag = SECTION_TABLE_OPENER_TEMPLATE;
            this.closeTag = SECTION_TABLE_CLOSE;
        } else {
            this.startTag = SECTION_OPENER_TEMPLATE;
            this.closeTag = SECTION_CLOSE;
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    protected void setUser(User user) {
        this.user = user;
    }

    protected User getUser() {
        return this.user;
    }

    public void setColName(String colName) {
        this.colNames[0] = colName;
    }

    public void setColValue(String colValue) {
        this.colValues[0] = colValue;
    }

    public void setIsTable(boolean isTable) {
        this.isTable = isTable;
        if (isTable) {
            this.startTag = SECTION_TABLE_OPENER_TEMPLATE;
            this.closeTag = SECTION_TABLE_CLOSE;
        } else {
            this.startTag = SECTION_OPENER_TEMPLATE;
            this.closeTag = SECTION_CLOSE;
        }
    }

    public boolean getIsTable() {
        return this.isTable;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setHowMany(String howMany) {
        this.howMany = howMany;
    }

    public void setNumber() {
        if (this.howMany == null) {
            this.number = 1;
            return;
        }
        this.number = Integer.parseInt(this.howMany);
    }

    public void setSortBy(String sortCol) {
        this.sortBy = sortCol;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setHasTitle(boolean hasTitle) {
        this.hasTitle = hasTitle;
    }

    public void setAction(String thisAction) {
        this.action = thisAction;
    }

    public String getAction() {
        return this.action;
    }

    public int doStartTag() throws JspException {
        try {
            this.user = (User)this.pageContext.getSession().getAttribute(Config.getProperty("cookietag"));
            this.processElements();
        }
        catch (MraldException e) {
            throw new MraldError(e);
        }
        this.setNumber();
        return 1;
    }

    private void processElements() throws MraldException {
        try {
            String type;
            this.user = (User)this.pageContext.getSession().getAttribute(Config.getProperty("cookietag"));
            this.eavElement = this.castElement();
            if (this.eavElement == null) {
                throw new MraldException("EavElement is NULL");
            }
            this.eavElement.setIsTable(this.getIsTable());
            if (this.getDisplayColumn() != null) {
                this.eavElement.setDisplayColumn(this.displayColumn);
                this.eavElement.init();
            }
            if (this.colNames[0] != null) {
                this.eavElement.addParams(this.colNames[0], this.colValues[0]);
            }
            this.eavElement.setUser(this.user);
            if (this.pageContext.getRequest().getParameter("colName") != null && ((type = this.pageContext.getRequest().getParameter("classType")).equals(this.eavElement.getType()) || type.equals("ALL"))) {
                this.eavElement.setParams(this.pageContext.getRequest().getParameter("colName"), this.pageContext.getRequest().getParameter("colValue"));
                if (this.pageContext.getRequest().getParameter("sortBy") != null) {
                    this.eavElement.addSort(this.pageContext.getRequest().getParameter("sortBy"));
                }
            }
            if (this.sortBy != null) {
                this.eavElement.addSort(this.sortBy);
            }
        }
        catch (ServletException e) {
            throw new MraldException(e);
        }
        catch (MraldException e) {
            throw new MraldException(e);
        }
    }

    public int doEndTag() throws JspException {
        StringBuffer ret = new StringBuffer();
        try {
            if (this.action.equals(INSERT_ACTION)) {
                if (this.pageContext.getRequest().getParameter("colName") != null) {
                    this.eavElement.setColName(this.pageContext.getRequest().getParameter("colName"));
                    this.eavElement.setColValue(this.pageContext.getRequest().getParameter("colValue"));
                }
                ret.append(this.getInsertHtml(this.eavElement));
            } else {
                EavListTag topTag = this.getParents(this);
                topTag.setUser(this.user);
                if (!((Object)((Object)this)).equals((Object)topTag)) {
                    this.release();
                    return 0;
                }
                ret.append(topTag.getChildHtml(topTag));
                topTag.close();
            }
            this.pageContext.getOut().print(ret.toString());
        }
        catch (IOException e) {
            throw new JspException(e.getMessage());
        }
        catch (MraldException e) {
            throw new MraldError(e);
        }
        return 1;
    }

    public void init() {
    }

    public EavListTag getParents(EavListTag thisTag) throws MraldException {
        EavListTag ancestorTag = (EavListTag)thisTag.getParent();
        if (ancestorTag != null) {
            ancestorTag.setChild(thisTag);
            thisTag = this.getParents(ancestorTag);
        }
        return thisTag;
    }

    public String getChildHtml(EavListTag thisTag) throws MraldException {
        StringBuffer ret = new StringBuffer();
        String whereCol = "";
        String whereVal = "";
        EavListTag childTag = thisTag.getChild();
        boolean moreRows = true;
        if (childTag != null) {
            childTag.setUser(thisTag.getUser());
            EavElement childElement = childTag.getEavElement();
            if (childElement != null) {
                EavElement thisElement = thisTag.getEavElement();
                childElement.setUser(this.user);
                if (thisElement != null) {
                    thisElement.setUser(this.user);
                    int i = 0;
                    while (moreRows) {
                        ++i;
                        String htmlStr = thisElement.selectHtmlSingle();
                        if (htmlStr == null) {
                            moreRows = false;
                            continue;
                        }
                        ret.append(thisTag.getTitle());
                        ret.append(htmlStr);
                        whereCol = thisElement.getColName();
                        whereVal = thisElement.getColValue();
                        childElement.setParams(whereCol, whereVal);
                        if (childElement.getSortBy() != null) {
                            childElement.addSort(childElement.getSortBy());
                        }
                        ret.append(childTag.getChildHtml(childTag));
                        ret.append(thisElement.endHtmlSingle());
                        ret.append(this.closingTag);
                    }
                }
            } else {
                thisTag.getEavElement().setUser(this.user);
                String returnStr = this.getHtml(thisTag.getEavElement());
                ret.append(returnStr);
            }
        } else {
            thisTag.getEavElement().setUser(this.user);
            String returnStr = this.getHtml(thisTag.getEavElement());
            ret.append(returnStr);
        }
        return ret.toString();
    }

    private String getHtml(EavElement thisElement) throws MraldException {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < this.number; ++i) {
            String htmlStr = thisElement.selectHtml();
            ret.append(this.getTitle());
            ret.append(htmlStr);
            if (i >= this.number - 1) continue;
            ret.append("<hr width=\"90%\">\n");
        }
        if (this.hasTitle) {
            ret.append(this.closeTag);
        }
        return ret.toString();
    }

    private String getInsertHtml(EavElement thisElement) throws MraldException {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < this.number; ++i) {
            String htmlStr = thisElement.insertHtml();
            ret.append(this.getTitle());
            ret.append(htmlStr);
            if (i >= this.number - 1) continue;
            ret.append("<hr width=\"90%\">\n");
        }
        if (this.hasTitle) {
            ret.append(this.closeTag);
        }
        return ret.toString();
    }

    private void setChild(EavListTag descendant) {
        this.child = descendant;
    }

    public EavListTag getChild() {
        return this.child;
    }

    public void setDisplayColumn(String column) {
        this.displayColumn = column;
    }

    public String getDisplayColumn() {
        return this.displayColumn;
    }

    public String getTitle() {
        try {
            if (this.hasTitle) {
                String outTitle = MiscUtils.replace(this.startTag, "<:title:>", this.title);
                outTitle = MiscUtils.replace(outTitle, "<:colspan:>", this.eavElement.getColCount());
                this.closingTag = this.closeTag;
                return outTitle;
            }
            return new String("");
        }
        catch (Exception e) {
            throw new MraldError(e);
        }
    }

    public EavElement getEavElement() {
        return this.eavElement;
    }

    public void close() throws MraldException {
        if (this.eavElement != null) {
            this.eavElement.close();
            this.eavElement = null;
        }
        if (this.getChild() != null) {
            this.getChild().close();
        }
        this.release();
    }

    private EavElement castElement() throws ServletException {
        try {
            if (this.className == null) {
                return null;
            }
            Class<?> classDefinition = Class.forName(this.className);
            EavElement thisElement = (EavElement)classDefinition.newInstance();
            thisElement.setUser(this.user);
            return thisElement;
        }
        catch (MraldException me) {
            ServletException ce = new ServletException("InstantiationException: of " + this.className + "  : " + me.getMessage());
            ce.fillInStackTrace();
            throw ce;
        }
        catch (InstantiationException wfe) {
            ServletException ce = new ServletException("InstantiationException: of " + this.className + "  : " + wfe.getMessage());
            ce.fillInStackTrace();
            throw ce;
        }
        catch (ClassNotFoundException cne) {
            ServletException ce = new ServletException("ClassNotFoundException: " + cne.getMessage());
            ce.fillInStackTrace();
            throw ce;
        }
        catch (IllegalAccessException iae) {
            ServletException ce = new ServletException("Illegal access exception: " + iae.getMessage());
            ce.fillInStackTrace();
            throw ce;
        }
    }
}

