/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.eav;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.mitre.lattice.eav.EavElement;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldException;

public class ValueElement
extends EavElement {
    String filterColumn;
    String filterValue;

    public ValueElement() throws MraldException {
        super(new String("Value"));
    }

    protected void init() throws MraldException {
        this.setColName("subject_id");
        if (this.getDisplayColumn().equals("")) {
            this.setInitQuery("SELECT subject_id, entity.name, attribute.name, value, date from Subject_values, attribute, entity where entity.entity_id = attribute.entity_id AND Subject_values.attribute_id = attribute.attribute_id  ");
            this.whereAnd = " AND ";
        } else {
            this.setColCount(3);
            this.setInitQuery(" SELECT entity.name, attribute.name, value, " + this.getColName() + " from Subject_values, attribute, entity where entity.entity_id = attribute.entity_id AND Subject_values.attribute_id = attribute.attribute_id  ");
            this.whereAnd = " AND ";
        }
    }

    public void setColValue(String value) {
        String[] values = value.split("~");
        super.setColValue(values[0]);
        if (values.length > 2) {
            this.filterColumn = values[1];
            this.filterValue = values[2];
        }
    }

    protected StringBuffer outputRow(int columnNo) throws MraldException {
        try {
            if (!this.isTable) {
                return this.outputRowNonTable(columnNo);
            }
            StringBuffer ret = new StringBuffer();
            ret.append("<tr>");
            for (int i = 1; i < columnNo + 1; ++i) {
                if (this.getPrintVert()) {
                    ret.append("<tr>");
                }
                if (columnNo == 1) {
                    ret.append("<td><a href='eavFrame.jsp?classType=" + this.getType() + "&colName=" + URLEncoder.encode(this.getColName(), "UTF-8") + "&colValue=" + URLEncoder.encode(this.getRs().getString(this.getColName()), "UTF-8") + "' target=\"_parent\">" + this.getRs().getString(i) + "</a></td>");
                } else {
                    ret.append("<td>" + this.getRs().getString(i) + "</td>");
                }
                if (!this.getPrintVert()) continue;
                ret.append("</tr>");
            }
            ret.append("</tr>");
            this.setColValue(this.getRs().getString(this.getColName()));
            return ret;
        }
        catch (SQLException s) {
            throw new MraldException(s);
        }
        catch (UnsupportedEncodingException s) {
            throw new MraldException(s);
        }
    }

    protected StringBuffer outputRowNonTable(int columnNo) throws MraldException {
        try {
            StringBuffer ret = new StringBuffer();
            for (int i = 1; i < columnNo + 1; ++i) {
                if (columnNo == 1) {
                    ret.append("<p class=\"sideBarTitle\">");
                    ret.append(this.getRs().getString(i));
                    this.hasDiv = true;
                    String temp = "<a onClick=\"toggle('<:IDName:>', 'images/')\" ><img id=\"<:IDName:>Image\" src=\"images/plus.gif\"></a><div id=\"<:IDName:>\" style=\"display:block;\" class=\"leftSideBar\">";
                    temp = temp.replaceAll("<:IDName:>", this.getRs().getString(i));
                    ret.append(temp);
                    this.endSection = "</div></p>";
                } else {
                    ret.append(this.getRs().getString(i));
                }
                if (!this.getPrintVert()) continue;
                ret.append("<br/>");
            }
            if (this.hasDiv) {
                // empty if block
            }
            this.setColValue(this.getRs().getString(this.getColName()));
            return ret;
        }
        catch (SQLException s) {
            throw new MraldException(s);
        }
    }

    public String insertHtml() throws MraldException {
        try {
            this.setColCount(2);
            String query = " select entity_id, name from entity order by name ";
            ResultSet rs = this.runQuery(query);
            String entityDropDown = null;
            String selected = "";
            int tmpcount = 0;
            while (rs.next()) {
                ++tmpcount;
                if (rs.getString("entity_id").equals(this.filterValue)) {
                    selected = "selected";
                }
                entityDropDown = entityDropDown + "<option value=\"" + URLEncoder.encode(rs.getString("entity_id"), "UTF-8") + "\" " + selected + ">" + rs.getString("name") + "</option>";
                selected = "";
            }
            query = " select attribute_id, name from attribute ";
            StringBuffer attrVal = new StringBuffer();
            String[] columns = new String[]{"attribute_id", "value"};
            String[] columnNames = new String[]{"Attribute", "Value"};
            String tableName = "subject_values";
            if (this.filterColumn != null) {
                query = query + " where " + this.filterColumn + " = " + this.filterValue;
                rs = this.runQuery(query);
                int count = 0;
                int colStart = 4;
                while (rs.next()) {
                    ++count;
                    attrVal.append("<tr>");
                    for (int i = 0; i < columns.length; ++i) {
                        String insertCount = colStart + count + "" + i;
                        if (i == 0) {
                            attrVal.append("<td><b>" + rs.getString("name") + "</b>");
                            attrVal.append("<input type=\"hidden\" value=\"Table:" + tableName + "~Field:" + columns[i] + "~Order:" + (colStart + i) + "~Type:String~Value:" + rs.getString(columns[i]) + "~SqlThread:" + count + "\" name=\"Insert" + insertCount + "\"/><br/></td>");
                            continue;
                        }
                        attrVal.append("<td><input type=\"text\" name=\"Insert" + insertCount + "\"></input>");
                        attrVal.append("<input type=\"hidden\" value=\"Table:" + tableName + "~Field:" + columns[i] + "~Order:" + (i + 1) + "~Type:String~SqlThread:" + count + "\" name=\"Insert" + insertCount + "\"/><br/></td>");
                    }
                    attrVal.append("</tr>");
                }
                rs.close();
            }
            StringBuffer ret = new StringBuffer();
            columns = new String[]{"subject_id", "entity_id", "date"};
            columnNames = new String[]{"Subject Id", "Select Test", "Date"};
            for (int i = 0; i < columns.length; ++i) {
                String value = "";
                if (this.getColName().equals(columns[i])) {
                    value = this.getColValue();
                }
                String input = "<tr><td><b>" + columnNames[i] + "</b></td><td><input type=\"text\" length=\"30\" name=\"Insert" + i + "\" value=\"" + value + "\"/><input type=\"hidden\" value=\"Table:!All~SqlThread:-1~Field:" + columns[i] + "~Order:" + i + "~Type:String\" name=\"Insert" + i + "\"/><br/></td></tr>";
                if (columns[i].equals("entity_id")) {
                    String params = "'show=Subject&classType=Subject&colName=" + this.getColName() + "&colValue=" + URLEncoder.encode(this.getColValue(), "UTF-8") + "'";
                    input = "<tr><td><b>" + columnNames[i] + "</b></td><td><select name=\"Entity\"  onChange=\"filter(this.value,  " + params + ")\"><option></option>" + entityDropDown + "</select>" + "<br/></td></tr>";
                } else if (columns[i].equals("date")) {
                    String calendar = "<SCRIPT LANGUAGE=\"JavaScript\">var cal1 = new CalendarPopup();</SCRIPT><a HREF=\"#\" onClick=\"cal1.select(document.o.Insert" + i + "[0],'anchor1','MM/dd/yyyy'); return false;\" TITLE=\"cal1.select(document.o.Insert" + i + "[0],'anchor1','MM/dd/yyyy'); return false; \"  NAME=\"anchor1\" ID=\"anchor1\" ><img src=\"" + Config.getProperty("BaseUrl") + "/cal.gif\" width=\"17\" height=\"17\" border=\"0\" alt=\"Click Here to Pick up the timestamp\"></a>";
                    input = "<tr><td><b>" + columnNames[i] + "</b></td><td><input type=\"text\" length=\"30\" name=\"Insert" + i + "\" value=\"" + value + "\"/><input type=\"hidden\" value=\"Table:!All~SqlThread:-1~Field:" + columns[i] + "~Order:" + i + "~Type:String\" name=\"Insert" + i + "\"/>" + calendar + "<br/></td></tr>";
                }
                ret.append(input);
            }
            ret.append("<tr><td></td><td></td></tr>");
            this.close();
            return ret.toString() + attrVal.toString();
        }
        catch (SQLException e) {
            throw new MraldException();
        }
        catch (UnsupportedEncodingException e) {
            throw new MraldException();
        }
    }

    public String deleteHtml() {
        StringBuffer ret = new StringBuffer();
        return ret.toString();
    }

    public String updateHtml() {
        StringBuffer ret = new StringBuffer();
        return ret.toString();
    }
}

