/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Properties;
import org.jgraph.JGraph;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.VertexRenderer;
import org.jgraph.graph.VertexView;
import org.mitre.mrald.util.Config;

public class EllipseView
extends VertexView {
    public static EllipseRenderer renderer = new EllipseRenderer();

    public EllipseView(Object cell, JGraph graph, CellMapper cm) {
        super(cell, graph, cm);
    }

    public Point2D getPerimeterPoint(Point2D source, Point2D p) {
        double yout;
        double xout;
        double dist2;
        Rectangle2D r = this.getBounds();
        double x = r.getX();
        double y = r.getY();
        double a = (r.getWidth() + 1.0) / 2.0;
        double b = (r.getHeight() + 1.0) / 2.0;
        double x0 = x + a;
        double y0 = y + b;
        double x1 = p.getX();
        double y1 = p.getY();
        double dx = x1 - x0;
        double dy = y1 - y0;
        if (dx == 0.0) {
            return new Point((int)x0, (int)(y0 + b * dy / Math.abs(dy)));
        }
        double d = dy / dx;
        double h = y0 - d * x0;
        double e = a * a * d * d + b * b;
        double f = -2.0 * x0 * e;
        double g = a * a * d * d * x0 * x0 + b * b * x0 * x0 - a * a * b * b;
        double det = Math.sqrt(f * f - 4.0 * e * g);
        double xout1 = (-f + det) / (2.0 * e);
        double xout2 = (-f - det) / (2.0 * e);
        double yout1 = d * xout1 + h;
        double yout2 = d * xout2 + h;
        double dist1 = Math.sqrt(Math.pow(xout1 - x1, 2.0) + Math.pow(yout1 - y1, 2.0));
        if (dist1 < (dist2 = Math.sqrt(Math.pow(xout2 - x1, 2.0) + Math.pow(yout2 - y1, 2.0)))) {
            xout = xout1;
            yout = yout1;
        } else {
            xout = xout2;
            yout = yout2;
        }
        return this.getAttributes().createPoint(xout, yout);
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public static class EllipseRenderer
    extends VertexRenderer {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics g) {
            int b = this.borderWidth;
            Graphics2D g2 = (Graphics2D)g;
            Dimension d = this.getSize();
            String type = "Default";
            Properties props = Config.getLatticeFactory().getProperties();
            String temp = props.getProperty(type + "ColorEnd");
            temp = temp.substring(temp.indexOf("(") + 1, temp.length() - 1);
            String[] nodeEndInts = temp.split(",");
            temp = props.getProperty(type + "ColorStart");
            temp = temp.substring(temp.indexOf("(") + 1, temp.length() - 1);
            String[] nodeStartInts = temp.split(",");
            Color nodeEndCol = new Color(Integer.parseInt(nodeEndInts[0].trim()), Integer.parseInt(nodeEndInts[1].trim()), Integer.parseInt(nodeEndInts[2].trim()));
            Color nodeStartCol = new Color(Integer.parseInt(nodeStartInts[0].trim()), Integer.parseInt(nodeStartInts[1].trim()), Integer.parseInt(nodeStartInts[2].trim()));
            GradientPaint nodeCol = new GradientPaint(b - 1, b - 1, nodeStartCol, d.width - b, d.height - b, nodeEndCol);
            boolean tmp = this.selected;
            if (super.isOpaque()) {
                g2.setPaint(nodeCol);
                g2.fill(new Ellipse2D.Double(b - 1, b - 1, d.width - b, d.height - b));
            }
            try {
                this.setBorder(null);
                this.setOpaque(false);
                this.selected = false;
                super.paint(g);
            }
            finally {
                this.selected = tmp;
            }
            if (this.bordercolor != null) {
                g.setColor(this.bordercolor);
                g2.setStroke(new BasicStroke(b));
                g.drawOval(b - 1, b - 1, d.width - b, d.height - b);
            }
            if (this.selected) {
                g2.setStroke(new BasicStroke(b));
                g.setColor(this.graph.getHighlightColor());
                g.drawOval(b - 1, b - 1, d.width - b, d.height - b);
            }
        }
    }
}

