/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.graph;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.mitre.lattice.graph.GraphLattice;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.MsgObjectException;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.User;

public class RedrawGraph
extends AbstractStep {
    public void graphLattice(MsgObject msg) throws WorkflowStepException, MraldException {
        try {
            HttpServletRequest req = msg.getReq();
            HttpSession ses = req.getSession();
            if (ses == null) {
                HttpServletResponse resp = msg.getRes();
                resp.sendRedirect(Config.getProperty("BaseUrl") + "/LatticeLogin.jsp?pageurl=" + req.getRequestURL());
                return;
            }
            User user = (User)ses.getAttribute(Config.getProperty("cookietag"));
            String output = GraphLattice.convertToHtml(user);
            RedrawGraph.outputHtml(msg, output);
        }
        catch (ServletException e) {
            throw new WorkflowStepException(e);
        }
        catch (IOException e) {
            throw new WorkflowStepException(e);
        }
        catch (MsgObjectException e) {
            throw new WorkflowStepException(e);
        }
        catch (Exception e) {
            throw new WorkflowStepException(e);
        }
    }

    public static void outputHtml(MsgObject msg, String output) throws ServletException, IOException, MsgObjectException {
        HttpServletResponse res = msg.getRes();
        res.sendRedirect(Config.getProperty("BaseUrl") + "/LatticeManagement.jsp");
    }

    public void execute(MsgObject msg) throws WorkflowStepException {
        try {
            this.graphLattice(msg);
        }
        catch (Exception e) {
            throw new MraldError(e);
        }
    }
}

