/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.lattice;

import org.mitre.lattice.lattice.LatticeException;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.DomParser;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LatticeErrorHandler
extends DomParser {
    public static void handleException(MsgObject msg, LatticeException se, boolean html) {
        LatticeErrorHandler eh = new LatticeErrorHandler();
        NodeList errors = null;
        try {
            errors = eh.parseErrorFile(Config.getProperty("latticeErrFile"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String returnMessage = eh.buildMessage(errors, se.getMessage(), se.getDetail());
        if (returnMessage == null) {
            MraldError mt = new MraldError(se.getMessage(), se, msg);
            throw mt;
        }
        MraldError mt = new MraldError(returnMessage, se, msg);
        throw mt;
    }

    protected String buildMessage(NodeList errors, String thrownMessage, String detailMessage) {
        for (int i = 0; i < errors.getLength(); ++i) {
            Element thisElement = (Element)errors.item(i);
            String number = this.getChildString(thisElement, "number");
            if (thrownMessage.indexOf(number) == -1) continue;
            String title = this.getChildString(thisElement, "title");
            String message = this.getChildString(thisElement, "user_message");
            return this.formatMessage(title, message + detailMessage);
        }
        return null;
    }

    protected String formatMessage(String title, String message) {
        String ret = "For this error (\"" + title + "\")\n please read the following " + "possible solution: " + message;
        return ret;
    }

    protected NodeList parseErrorFile(String filename) throws LatticeException {
        try {
            Document document = this.parseFile(filename);
            Element rootElement = document.getDocumentElement();
            if (!rootElement.hasChildNodes()) {
                throw new LatticeException("\n The LatticeErrorHandler XML configuration file specified is invalid. The root element does not contain any child nodes. ");
            }
            return rootElement.getElementsByTagName("error");
        }
        catch (MraldParseException e) {
            throw new LatticeException(e.getMessage());
        }
    }
}

