/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.lattice;

import java.io.Serializable;
import java.util.ArrayList;
import org.mitre.lattice.lattice.InvalidLatticeStructureException;
import org.mitre.lattice.lattice.LatticeNodeInterface;
import org.mitre.mrald.util.Config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatticeNode
implements LatticeNodeInterface,
Serializable,
Comparable {
    private String name = null;
    private ArrayList<LatticeNode> children = new ArrayList();
    private ArrayList<LatticeNode> parents = new ArrayList();

    public LatticeNode() {
        this.name = "";
        this.children = new ArrayList();
        this.parents = new ArrayList();
    }

    public LatticeNode(String nodeName) {
        this.name = nodeName;
    }

    public LatticeNode(String nodeName, ArrayList<LatticeNode> children, ArrayList<LatticeNode> parents) {
        this.name = nodeName;
        this.children = children;
        this.parents = parents;
    }

    public LatticeNode(LatticeNode newNode) {
        this.name = new String(newNode.getName());
        this.children = new ArrayList<LatticeNode>(newNode.getChildren());
        this.parents = new ArrayList<LatticeNode>(newNode.getParents());
    }

    @Override
    public ArrayList<LatticeNode> getChildren() {
        return this.children;
    }

    public boolean setChildren(ArrayList children) throws InvalidLatticeStructureException {
        return this.addChildren(children);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ArrayList<LatticeNode> getParents() {
        return this.parents;
    }

    public ArrayList getParentsClone() {
        ArrayList<LatticeNode> newParents = new ArrayList<LatticeNode>();
        for (int i = 0; i < this.parents.size(); ++i) {
            newParents.add(Config.getLatticeFactory().copyNode(this.parents.get(i)));
        }
        return newParents;
    }

    public boolean setParents(ArrayList parents) throws InvalidLatticeStructureException {
        return this.addParents(parents);
    }

    @Override
    public boolean addChildren(ArrayList nodeChildren) throws InvalidLatticeStructureException {
        for (int i = 0; i < nodeChildren.size(); ++i) {
            if (this.addChild((LatticeNode)nodeChildren.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeChildren(ArrayList nodeChildren) {
        for (int i = 0; i < nodeChildren.size(); ++i) {
            if (this.removeChild((LatticeNode)nodeChildren.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addChild(LatticeNode child) throws InvalidLatticeStructureException {
        ArrayList<LatticeNode> checkNodes = new ArrayList<LatticeNode>();
        if (!this.checkIsActionValid(false, child)) {
            throw new InvalidLatticeStructureException("LATT-002", "This action is Invalid.");
        }
        checkNodes.add(child);
        if (!this.checkConsistent(false, checkNodes)) {
            throw new InvalidLatticeStructureException("LATT-002", "The node " + child.getName() + " is already a Parent group of " + this.getName() + " \n and cannot therefore, also be a Child");
        }
        if (this.children.contains(child)) {
            return false;
        }
        return this.children.add(child);
    }

    @Override
    public boolean removeChild(LatticeNode child) {
        if (!this.children.contains(child)) {
            return false;
        }
        this.children.remove(this.children.indexOf(child));
        return true;
    }

    public boolean addParents(ArrayList nodeParents) throws InvalidLatticeStructureException {
        for (int i = 0; i < nodeParents.size(); ++i) {
            if (this.addParent((LatticeNode)nodeParents.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean checkIsActionValid(boolean isParent, LatticeNode addNode) {
        return true;
    }

    public boolean checkConsistent(boolean checkChildren, ArrayList checkNodes) {
        boolean test = true;
        if (checkChildren) {
            for (int i = 0; i < checkNodes.size(); ++i) {
                if (!this.children.contains(checkNodes.get(i))) {
                    test = true;
                    for (int j = 0; j < this.children.size(); ++j) {
                        LatticeNode child = this.children.get(j);
                        test = child.checkConsistent(checkChildren, checkNodes);
                    }
                    if (test) continue;
                    return test;
                }
                test = false;
                return test;
            }
            return true;
        }
        for (int i = 0; i < checkNodes.size(); ++i) {
            if (!this.parents.contains(checkNodes.get(i))) {
                test = true;
                for (int j = 0; j < this.parents.size(); ++j) {
                    LatticeNode parent = this.parents.get(j);
                    test = parent.checkConsistent(checkChildren, checkNodes);
                }
                if (test) continue;
                return test;
            }
            test = false;
            return test;
        }
        return true;
    }

    public boolean reAssignChild(LatticeNode child) throws InvalidLatticeStructureException {
        this.children.remove(child);
        ArrayList<LatticeNode> grandChildren = child.getChildren();
        if (grandChildren.size() == 0) {
            return false;
        }
        for (int j = 0; j < grandChildren.size(); ++j) {
            LatticeNode grandChild = grandChildren.get(j);
            if (this.children.size() > 0 && grandChild.getName().equals("Public")) continue;
            this.addChild(grandChild);
            grandChild.addParent(this);
        }
        return true;
    }

    public void reAssignParentsToPublic(LatticeNode rootNode) throws InvalidLatticeStructureException {
        for (int j = 0; j < this.parents.size(); ++j) {
            LatticeNode parent = this.parents.get(j);
            parent.addChild(rootNode);
            rootNode.addParent(parent);
        }
    }

    public boolean removeParents(ArrayList nodeParents) {
        for (int i = 0; i < nodeParents.size(); ++i) {
            if (this.removeParent((LatticeNode)nodeParents.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addParent(LatticeNode parent) throws InvalidLatticeStructureException {
        ArrayList<LatticeNode> checkNodes = new ArrayList<LatticeNode>();
        if (!this.checkIsActionValid(true, parent)) {
            throw new InvalidLatticeStructureException("LATT-002", "This action is Invalid.");
        }
        checkNodes.add(parent);
        if (!this.checkConsistent(true, checkNodes)) {
            throw new InvalidLatticeStructureException("LATT-002", "The node " + parent.getName() + " is already a Child group of " + this.getName() + " \n and cannot therefore, also be a Parent");
        }
        if (this.parents.contains(parent)) {
            return false;
        }
        return this.parents.add(parent);
    }

    @Override
    public boolean removeParent(LatticeNode parent) {
        if (!this.parents.contains(parent)) {
            return false;
        }
        this.parents.remove(this.parents.indexOf(parent));
        return true;
    }

    public boolean equals(Object currentNode) {
        boolean result = false;
        result = this.getName().equals(((LatticeNode)currentNode).getName()) ? true : (this.getName() == ((LatticeNode)currentNode).getName() ? true : this == currentNode);
        return result;
    }

    public int countParentNodes() {
        return this.parents.size();
    }

    public int countChildNodes() {
        return this.children.size();
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.name == null ? 0 : this.name.hashCode());
        return hash;
    }

    public int compareTo(Object comparableLattice) {
        LatticeNode compare = (LatticeNode)comparableLattice;
        return this.getName().compareTo(compare.getName());
    }
}

