/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.query;

import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;
import org.mitre.lattice.query.LabelTableElement;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.parser.ParserElement;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldConnection;

public class LabelTable
extends AbstractStep {
    String SCHEMA;
    String datasource;
    DatabaseMetaData dbmd;

    public final void execute(MsgObject msg) throws WorkflowStepException {
        try {
            this.datasource = msg.getValue("Datasource")[0];
            MraldConnection mconn = new MraldConnection(this.datasource);
            this.dbmd = mconn.getConnection().getMetaData();
            ArrayList<ParserElement> parsedObjects = msg.getWorkingObjects();
            ResultSet rs = null;
            ArrayList queries = new ArrayList();
            String dataBase = this.dbmd.getDriverName();
            for (int i = 0; i < parsedObjects.size(); ++i) {
                LabelTableElement newElement = (LabelTableElement)parsedObjects.get(i);
                rs = this.dbmd.getPrimaryKeys(null, Config.getProperty("SCHEMA"), newElement.getTableName());
                newElement.setPrimaryKeys(rs);
                rs = this.dbmd.getColumns(null, Config.getProperty("SCHEMA"), newElement.getTableName(), null);
                newElement.setColumns(rs);
                queries = newElement.buildSql1(dataBase);
                for (int j = 0; j < queries.size(); ++j) {
                    mconn.executeUpdate(queries.get(j).toString());
                }
                this.loadExistingTable(mconn, newElement);
            }
            HttpServletResponse resp = msg.getRes();
            resp.sendRedirect(Config.getProperty("BaseUrl") + "/success.jsp");
            mconn.close();
            return;
        }
        catch (Exception e) {
            HttpServletResponse resp = msg.getRes();
            try {
                resp.sendRedirect(Config.getProperty("BaseUrl") + "/failure.jsp");
            }
            catch (IOException ioe) {
                throw new WorkflowStepException(ioe);
            }
            return;
        }
    }

    public final void loadExistingTable(MraldConnection mconn, LabelTableElement elem) throws WorkflowStepException {
        try {
            String pkId = null;
            ResultSet r = mconn.executeQuery(elem.getSelectRows());
            ArrayList pKeys = elem.getPrimaryKeys();
            ArrayList pKeysType = elem.getSqlTypeList();
            int pKeySize = pKeys.size();
            PreparedStatement prepStmnt = mconn.getConnection().prepareStatement(elem.getInsertStmnt());
            while (r.next()) {
                for (int i = 0; i < pKeySize; ++i) {
                    int typeVal = (Integer)pKeysType.get(i);
                    if (typeVal == 12) {
                        pkId = r.getString(pKeys.get(i).toString());
                        prepStmnt.setString(i + 1, pkId);
                        continue;
                    }
                    if (typeVal == 4) {
                        prepStmnt.setInt(i + 1, r.getInt(pKeys.get(i).toString()));
                        continue;
                    }
                    if (typeVal != 91) continue;
                    prepStmnt.setDate(i + 1, r.getDate(pKeys.get(i).toString()));
                }
                prepStmnt.execute();
            }
            r.close();
            mconn.close();
            return;
        }
        catch (SQLException e) {
            throw new WorkflowStepException(e);
        }
    }
}

