/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.query;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.ddlelements.DdlElementComparator;
import org.mitre.mrald.ddlelements.InsertElement;
import org.mitre.mrald.ddlelements.MultiInsertElementComparator;
import org.mitre.mrald.parser.ParserElement;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;
import org.mitre.mrald.util.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateLabel
extends AbstractStep {
    MsgObject msg;

    @Override
    public void execute(MsgObject msgObject) throws WorkflowStepException {
        if (!Config.getLatticeFactory().getUsingLatticeSecurityModel()) {
            return;
        }
        try {
            this.msg = msgObject;
            User user = (User)this.msg.getReq().getSession().getAttribute(Config.getProperty("cookietag"));
            ArrayList<ParserElement> parserElements = msgObject.getWorkingObjects();
            List<InsertElement> c = this.extractInsertElements(parserElements);
            this.removeInvalidElements(c);
            boolean isMulti = this.hasMultipleThreads(c);
            if (isMulti) {
                Collections.sort(c, new MultiInsertElementComparator());
            } else {
                Collections.sort(c, new DdlElementComparator());
            }
            String[] ddl = this.buildUpdates(c, user);
            for (int i = 0; i < ddl.length; ++i) {
                msgObject.setQuery(ddl[i]);
            }
        }
        catch (MraldException e) {
            throw new WorkflowStepException(e);
        }
    }

    public String[] buildUpdates(List insertElements, User user) throws MraldException {
        boolean tableLabelled = false;
        boolean finishThread = false;
        ArrayList<InsertElement> commonElements = new ArrayList<InsertElement>();
        ArrayList<InsertElement> multiElements = new ArrayList<InsertElement>();
        ArrayList<InsertElement> elements = new ArrayList<InsertElement>();
        ArrayList<String> updateSqls = new ArrayList<String>();
        InsertElement currentElement = null;
        String tableName = "";
        HashMap<String, String> tableList = this.getLabelTables();
        for (int i = 0; i < insertElements.size(); ++i) {
            currentElement = (InsertElement)insertElements.get(i);
            tableName = currentElement.getTable();
            tableLabelled = this.tableLabelled(tableName, tableList);
            String threadNo = currentElement.getSqlThread();
            if (threadNo == "") {
                threadNo = "1";
            }
            finishThread = i == insertElements.size() - 1 ? true : this.finishThread(threadNo, (InsertElement)insertElements.get(i + 1));
            if (!tableLabelled) {
                elements = new ArrayList();
                continue;
            }
            if (currentElement.getSqlThread().indexOf(",") != -1) {
                multiElements.add(currentElement);
            } else if (Integer.parseInt(threadNo) < 0) {
                commonElements.add(currentElement);
            } else {
                elements.add(currentElement);
            }
            if (!finishThread) continue;
            if (tableLabelled) {
                elements.addAll(commonElements);
                elements = this.addToSqlThread(multiElements, elements, threadNo);
                updateSqls.add(this.updateLabels(elements, tableList, user));
            }
            elements = new ArrayList();
        }
        String[] returnList = new String[updateSqls.size()];
        returnList = updateSqls.toArray(returnList);
        return returnList;
    }

    protected void printElements(ArrayList elems, String label) {
        for (int i = 0; i < elems.size(); ++i) {
            MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "Update Label: print elements: " + elems.get(i).toString());
        }
    }

    protected ArrayList<InsertElement> addToSqlThread(ArrayList<InsertElement> commonElements, ArrayList<InsertElement> ddlElements, String threadNo) {
        for (int i = 0; i < commonElements.size(); ++i) {
            InsertElement e = commonElements.get(i);
            String[] nums = e.getSqlThread().split(",");
            for (int j = 0; j < nums.length; ++j) {
                if (!nums[j].equals(threadNo)) continue;
                ddlElements.add(e);
            }
        }
        return ddlElements;
    }

    private List<InsertElement> extractInsertElements(ArrayList<ParserElement> parserElements) {
        ArrayList<InsertElement> returnList = new ArrayList<InsertElement>();
        for (int i = 0; i < parserElements.size(); ++i) {
            ParserElement nextElement = parserElements.get(i);
            if (!(nextElement instanceof InsertElement)) continue;
            returnList.add((InsertElement)parserElements.get(i));
        }
        parserElements.removeAll(returnList);
        return returnList;
    }

    private HashMap<String, String> getLabelTables() throws MraldException {
        try {
            MraldConnection conn = new MraldConnection(MetaData.ADMIN_DB);
            String selectStr = "select * from label_sql ";
            ResultSet rs = conn.executeQuery(selectStr);
            HashMap<String, String> labelTables = new HashMap<String, String>();
            while (rs.next()) {
                labelTables.put(rs.getString("table_name").toUpperCase(), rs.getString("sql_clause"));
            }
            rs.close();
            conn.close();
            return labelTables;
        }
        catch (SQLException e) {
            throw new MraldException(e.getMessage());
        }
    }

    private boolean tableLabelled(String table, HashMap labelTables) {
        String tableShared;
        if (table.equals("!All")) {
            return true;
        }
        if (!labelTables.containsKey(table = table.toUpperCase())) {
            return false;
        }
        String query = labelTables.get(table).toString().toUpperCase();
        return query.indexOf(tableShared = table.toUpperCase() + ".") > -1;
    }

    private final String updateLabels(ArrayList elems, HashMap tableList, User user) throws MraldException {
        int i;
        String tableName = null;
        for (int i2 = 0; i2 < elems.size() && (tableName = ((InsertElement)elems.get(i2)).getTable().toUpperCase()).equals("!All".toUpperCase()); ++i2) {
        }
        String sqlClause = tableList.get(tableName).toString();
        String groupName = user.getGroup();
        groupName = MiscUtils.checkApostrophe(groupName);
        String buildSql = "Update <:tableName:>_label set label = '" + groupName + "', owner = '<:userName:>'  where ";
        InsertElement element = null;
        ArrayList<String> fieldStrings = new ArrayList<String>();
        ArrayList<String> valueStrings = new ArrayList<String>();
        for (i = 0; i < elems.size(); ++i) {
            element = (InsertElement)elems.get(i);
            fieldStrings = element.buildFieldList(fieldStrings);
            valueStrings = element.buildValueList(valueStrings);
        }
        for (i = 0; i < fieldStrings.size(); ++i) {
            String field = fieldStrings.get(i).toString().toUpperCase();
            if (sqlClause.toUpperCase().indexOf(field) <= 0) continue;
            buildSql = buildSql + fieldStrings.get(i) + " = " + valueStrings.get(i) + " AND ";
        }
        buildSql = buildSql.substring(0, buildSql.length() - 5);
        buildSql = buildSql.replaceAll("<:userName:>", user.getEmail());
        buildSql = buildSql.replaceAll("<:tableName:>", tableName);
        return buildSql;
    }

    private boolean finishThread(String threadNo, InsertElement nextElements) throws MraldException {
        if (threadNo.indexOf(",") > 0) {
            String[] nums = threadNo.split(",");
            threadNo = nums[0];
        }
        if (Integer.parseInt(threadNo) == -1) {
            return false;
        }
        String newThreadNo = nextElements.getSqlThread();
        if (newThreadNo == "") {
            newThreadNo = "1";
        } else if (newThreadNo.indexOf(",") > 0) {
            String[] nums = newThreadNo.split(",");
            newThreadNo = nums[0];
        }
        return !newThreadNo.equals(threadNo);
    }

    private boolean hasMultipleThreads(List insertElements) throws MraldException {
        String threadNo = "";
        if (insertElements.size() == 0) {
            return false;
        }
        String prevThreadNo = ((InsertElement)insertElements.get(0)).getSqlThread();
        for (int i = 0; i < insertElements.size(); ++i) {
            InsertElement currentElement = (InsertElement)insertElements.get(i);
            threadNo = currentElement.getSqlThread();
            if (threadNo != prevThreadNo) {
                return true;
            }
            prevThreadNo = threadNo;
        }
        return false;
    }

    public void removeInvalidElements(Collection c) throws MraldException {
        Iterator iter = c.iterator();
        ArrayList<String> valueStrings = new ArrayList<String>();
        int lastSize = 0;
        while (iter.hasNext()) {
            InsertElement currentElement = (InsertElement)iter.next();
            valueStrings = currentElement.buildValueList(valueStrings);
            if (valueStrings.size() == lastSize) {
                iter.remove();
                --lastSize;
            }
            ++lastSize;
        }
    }
}

