/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.mitre.mrald.admin.ConfigFilter;
import org.mitre.mrald.admin.FormsFilter;
import org.mitre.mrald.admin.JarsFilter;
import org.mitre.mrald.admin.LogsFilter;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminUtil {
    static int basePathLength = 0;

    public static void removeErrFiles(PageContext pc) throws ServletException, IOException {
        ServletRequest req = pc.getRequest();
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("errFileDelete")) continue;
            File toDelete = new File(Config.getProperty("LOGPATH"), req.getParameter(key));
            toDelete.delete();
        }
        ((HttpServletResponse)pc.getResponse()).sendRedirect(Config.getProperty("AdminUrl"));
    }

    public static void rotateLogs(PageContext pc) throws MraldException, ServletException, IOException {
        boolean successfulRename;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        String prefix = formatter.format(new Date());
        File logfile = new File(Config.getProperty("LOGPATH"), Config.getProperty("LOGFILE"));
        if (logfile.exists() && !(successfulRename = logfile.renameTo(new File(Config.getProperty("LOGPATH"), prefix + Config.getProperty("LOGFILE"))))) {
            throw new MraldException("Couldn't rename " + logfile.getAbsolutePath());
        }
        logfile = new File(Config.getProperty("LOGPATH"), Config.getProperty("DBLOGFILE"));
        if (logfile.exists() && !(successfulRename = logfile.renameTo(new File(Config.getProperty("LOGPATH"), prefix + Config.getProperty("DBLOGFILE"))))) {
            throw new MraldException("Couldn't rename " + logfile.getAbsolutePath());
        }
        ((HttpServletResponse)pc.getResponse()).sendRedirect(Config.getProperty("AdminUrl"));
    }

    public static void createBackups() {
        Date date;
        try {
            BufferedReader reader;
            File installDT = new File(Config.getProperty("BasePath"), "logs/installDT.txt");
            if (!installDT.exists()) {
                throw new RuntimeException(installDT.getPath() + " does not exist - it is not possible to know what files to backup");
            }
            try {
                reader = new BufferedReader(new FileReader(installDT));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String line = reader.readLine();
            while (line.equals("")) {
                line = reader.readLine();
            }
            String dateToBeat = line;
            DateFormat df = DateFormat.getDateTimeInstance();
            date = df.parse(dateToBeat);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        String basePath = Config.getProperty("BasePath");
        if (basePath.endsWith("/") || basePath.endsWith("\\")) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        basePathLength = basePath.length();
        File dir = new File(basePath);
        String zipFileName = AdminUtil.getBackupFile(BackupType.CONFIG);
        List<File> newerFiles = AdminUtil.getFiles(dir, new ConfigFilter(), date);
        AdminUtil.createZipFile(zipFileName, newerFiles);
        zipFileName = AdminUtil.getBackupFile(BackupType.FORMS);
        newerFiles = AdminUtil.getFiles(dir, new FormsFilter(), date);
        AdminUtil.createZipFile(zipFileName, newerFiles);
        zipFileName = AdminUtil.getBackupFile(BackupType.JARS);
        newerFiles = AdminUtil.getFiles(dir, new JarsFilter(), date);
        AdminUtil.createZipFile(zipFileName, newerFiles);
        zipFileName = AdminUtil.getBackupFile(BackupType.LOGS);
        newerFiles = AdminUtil.getFiles(dir, new LogsFilter(), date);
        AdminUtil.createZipFile(zipFileName, newerFiles);
    }

    public static String getBackupFile(BackupType type) {
        String basePath = Config.getProperty("BasePath");
        switch (type) {
            case CONFIG: {
                return basePath + File.separator + "config.zip";
            }
            case FORMS: {
                return basePath + File.separator + "forms.zip";
            }
            case JARS: {
                return basePath + File.separator + "jars.zip";
            }
            case LOGS: {
                return basePath + File.separator + "logs.zip";
            }
        }
        return "";
    }

    protected static List<File> getFiles(File dir, FilenameFilter filter, Date date) {
        ArrayList<File> newerFiles = new ArrayList<File>();
        if (!dir.isDirectory()) {
            throw new RuntimeException(dir + " is not a directory.  Bad, program!  BAD!!");
        }
        File[] children = dir.listFiles(filter);
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isDirectory()) {
                newerFiles.addAll(AdminUtil.getFiles(children[i], filter, date));
                continue;
            }
            if (!date.before(new Date(children[i].lastModified())) || children[i].getName().endsWith(".lck")) continue;
            newerFiles.add(children[i]);
        }
        return newerFiles;
    }

    protected static void createZipFile(String zipName, List<File> files) {
        byte[] buf = new byte[1024];
        try {
            if (files.size() > 0) {
                ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipName));
                for (File file : files) {
                    int len;
                    FileInputStream in = new FileInputStream(file);
                    ZipEntry entry = new ZipEntry(file.getPath());
                    out.putNextEntry(entry);
                    while ((len = in.read(buf)) != -1) {
                        out.write(buf, 0, len);
                    }
                    out.closeEntry();
                    in.close();
                }
                out.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String getRelativePath(File file) {
        String ret = file.getPath().substring(basePathLength);
        ret = ret.replaceAll("^/*", "");
        ret = ret.replaceAll("^\\*", "");
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BackupType {
        CONFIG,
        FORMS,
        JARS,
        LOGS;

    }
}

