/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.admin;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mitre.mrald.admin.NewsElement;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class NewsBuilder
extends AbstractStep {
    Document document;
    Node root;
    MsgObject msg;

    public NewsBuilder() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new MraldError(e);
        }
        this.document = builder.newDocument();
        this.root = this.document.createElement("news");
        this.document.appendChild(this.root);
    }

    public void outputXml(Document document, Result destination) throws MraldException {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = tfactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(document);
            Object[] elements = this.msg.getWorkingObjects().toArray();
            for (int i = 0; i < elements.length; ++i) {
                Node node = ((NewsElement)elements[i]).getFBNode(document);
                if (node == null) continue;
                this.root.appendChild(node);
            }
            transformer.transform(source, destination);
        }
        catch (TransformerConfigurationException tce) {
            throw new MraldException(tce);
        }
        catch (TransformerException te) {
            throw new MraldException(te);
        }
    }

    public void execute(MsgObject _msg) throws WorkflowStepException {
        if (_msg.responseCommitted()) {
            return;
        }
        this.msg = _msg;
        String xmlTemp = Config.getProperty("NEWSXML").substring(7);
        File file = new File(xmlTemp);
        StreamResult res = new StreamResult(file);
        try {
            this.outputXml(this.document, res);
        }
        catch (MraldException e) {
            throw new MraldError(e, this.msg);
        }
        try {
            this.msg.setRedirect(Config.getProperty("URL"));
        }
        catch (IOException ie) {
            throw new MraldError(ie, this.msg);
        }
    }
}

