/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.analysis;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import org.mitre.mrald.analysis.AnalysisManagerException;
import org.mitre.mrald.analysis.MitreAnalysis;
import org.mitre.mrald.util.Config;

public class MitreFD
extends MitreAnalysis {
    private Process extProcess = null;
    private String smithersExe = Config.getProperty("BasePath") + "/WEB-INF/smithers.exe";
    private String parameter_f;
    private String parameter_t;
    private String parameter_a;
    private String parameter_s;
    private String parameter_c;
    private String outputFile;

    protected void performAnalysis(String template_file, String data_file) throws AnalysisManagerException {
        this.parameter_f = this.msg.getValue("parameter_f")[0];
        this.parameter_t = this.msg.getValue("parameter_t")[0];
        this.parameter_a = this.msg.getValue("parameter_a")[0];
        this.parameter_s = this.msg.getValue("parameter_s")[0];
        this.parameter_c = this.msg.getValue("parameter_c")[0];
        this.outputFile = System.getProperty("java.io.tmpdir") + "/" + this.msg.getUserId() + System.currentTimeMillis() + ".out";
        String args = "";
        args = args + " -f " + this.parameter_f;
        args = args + " -t " + this.parameter_t;
        args = args + " -a " + this.parameter_a;
        args = args + " -c " + this.parameter_c;
        if (this.parameter_s != null && !this.parameter_s.equals("null")) {
            args = args + " -s";
        }
        args = args + " -n " + this.templateFile;
        args = args + " -i " + this.dataFile;
        args = args + " -o " + this.outputFile;
        try {
            this.extProcess = Runtime.getRuntime().exec(this.smithersExe + args);
            this.extProcess.waitFor();
        }
        catch (IOException ioe) {
            throw new AnalysisManagerException(ioe.getMessage());
        }
        catch (InterruptedException ie) {
            throw new AnalysisManagerException(ie.getMessage());
        }
    }

    protected void displayResults() throws AnalysisManagerException {
        PrintWriter out = this.msg.getOutPrintWriter();
        try {
            String line;
            BufferedReader brin = new BufferedReader(new FileReader(this.outputFile));
            while ((line = brin.readLine()) != null) {
                out.println(line);
            }
            brin.close();
        }
        catch (FileNotFoundException fne) {
            throw new AnalysisManagerException(fne.getMessage());
        }
        catch (IOException ioe) {
            throw new AnalysisManagerException(ioe.getMessage());
        }
    }
}

