/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.analysis;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.mitre.mrald.analysis.AnalysisElement;
import org.mitre.mrald.analysis.AnalysisManager;
import org.mitre.mrald.analysis.AnalysisManagerException;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.MsgObjectException;

public abstract class WekaAnalysis
extends AnalysisManager {
    protected void prepareHeaders(MsgObject msg) throws AnalysisManagerException {
        try {
            msg.SetOutPrintWriter();
            msg.setContentType("text/plain");
            msg.setHeader("Content-Disposition", "inline;");
        }
        catch (MsgObjectException mge) {
            AnalysisManagerException aee = new AnalysisManagerException(mge.getMessage());
            throw aee;
        }
    }

    protected String makeTemplateFile() throws AnalysisManagerException {
        try {
            String fileLocation = this.msg.getUserId() + System.currentTimeMillis() + ".template";
            FileOutputStream fout = new FileOutputStream(new File(System.getProperty("java.io.tmpdir") + "/" + fileLocation));
            AnalysisElement currentElement = null;
            String formattedString = "@RELATION " + this.msg.getUserId() + "\n\n";
            fout.write(formattedString.getBytes());
            for (int k = 0; k < this.sortedElements.size(); ++k) {
                formattedString = "@ATTRIBUTE ";
                currentElement = (AnalysisElement)this.sortedElements.get(k);
                if (currentElement.getType().equals("Timestamp")) {
                    formattedString = formattedString + currentElement.getField() + " " + " DATE " + currentElement.getFormat() + "\n";
                } else if (currentElement.getType().equals("Nominal")) {
                    formattedString = formattedString + currentElement.getField() + " {";
                    String[] tempStrings = currentElement.getValues();
                    for (int i = 0; i < tempStrings.length; ++i) {
                        formattedString = formattedString + "\"" + tempStrings[i] + "\"";
                        if (i >= tempStrings.length - 1) continue;
                        formattedString = formattedString + ", ";
                    }
                    formattedString = formattedString + "}\n";
                } else if (currentElement.getType().equals("Numeric")) {
                    formattedString = formattedString + currentElement.getField() + " NUMERIC\n";
                } else if (currentElement.getType().equals("String")) {
                    formattedString = formattedString + currentElement.getField() + " STRING\n";
                }
                fout.write(formattedString.getBytes());
            }
            formattedString = "\n@DATA\n";
            fout.write(formattedString.getBytes());
            fout.close();
            return System.getProperty("java.io.tmpdir") + "/" + fileLocation;
        }
        catch (FileNotFoundException fnfe) {
            throw new AnalysisManagerException(fnfe);
        }
        catch (IOException ioe) {
            throw new AnalysisManagerException(ioe);
        }
    }

    protected abstract void performAnalysis(String var1, String var2) throws AnalysisManagerException;

    protected abstract void displayResults() throws AnalysisManagerException;
}

