/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.analysis;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.SequenceInputStream;
import org.mitre.mrald.analysis.AnalysisManagerException;
import org.mitre.mrald.analysis.WekaAnalysis;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldOutFile;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.trees.J48;
import weka.core.Instances;

public class WekaJ48
extends WekaAnalysis {
    protected J48 scheme;
    protected Evaluation evaluator;

    protected void performAnalysis(String template_file, String data_file) throws AnalysisManagerException {
        try {
            this.scheme = new J48();
            SequenceInputStream sis = new SequenceInputStream(new FileInputStream(template_file), new FileInputStream(data_file));
            Instances data = new Instances((Reader)new InputStreamReader(sis));
            data.setClassIndex(Integer.parseInt(this.msg.getValue("focused_field")[0]));
            this.scheme.buildClassifier(data);
            Evaluation evaluator = new Evaluation(data);
            evaluator.evaluateModel((Classifier)this.scheme, data);
        }
        catch (FileNotFoundException fnfe) {
            throw new AnalysisManagerException(fnfe);
        }
        catch (IOException ioe) {
            throw new AnalysisManagerException(ioe);
        }
        catch (Exception e) {
            MraldOutFile.logToFile(MiscUtils.formatThrowable(e));
            throw new AnalysisManagerException(e);
        }
    }

    protected void displayResults() throws AnalysisManagerException {
        try {
            PrintWriter out = this.msg.getOutPrintWriter();
            out.println(this.evaluator.toSummaryString());
            out.println(this.evaluator.toClassDetailsString());
            out.println(this.evaluator.toMatrixString());
        }
        catch (Exception e) {
            throw new AnalysisManagerException(e);
        }
    }
}

