/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.control;

import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WfController;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldParseException;
import org.mitre.mrald.util.ParseXML;
import org.mitre.mrald.util.Snoop;

public class MraldEntry {
    MsgObject msg;

    public MraldEntry(MsgObject passed_msg) {
        this.msg = passed_msg;
    }

    public MraldEntry() {
        this.msg = new MsgObject();
    }

    public void setUser(String username) {
        this.msg.setUserId(username);
    }

    public void addNvPair(String name, String value) {
        this.msg.setValue(name, value);
    }

    public void runMrald() throws WorkflowStepException {
        try {
            Snoop.logParameters(this.msg);
            ParseXML mraldParser = new ParseXML(Config.getProperty("XMLFILE"));
            String workflow = this.msg.getValue("workflow")[0];
            if (workflow == null) {
                workflow = "Building SQL";
            }
            MiscUtils.logWorkFlow(this.msg.getUserUrl(), workflow);
            mraldParser.setWfPath(workflow);
            HashMap list = mraldParser.ProcessXML();
            WfController controller = new WfController(this.msg);
            controller.setWfObjects(list);
            controller.processWorkFlow();
        }
        catch (IOException e) {
            throw new WorkflowStepException(e.getMessage());
        }
        catch (MraldException e) {
            throw new WorkflowStepException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new WorkflowStepException(e.getMessage());
        }
        catch (MraldParseException e) {
            throw new WorkflowStepException(e.getMessage());
        }
    }

    public String buildQuery() throws WorkflowStepException {
        this.msg.setValue("workflow", "BuildQuery");
        this.runMrald();
        return this.msg.getQuery()[0];
    }
}

