/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.control;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mitre.mrald.control.MsgObjectException;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.parser.ParserElement;
import org.mitre.mrald.query.LinkElement;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldOutFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MsgObject
implements Serializable {
    private String[] query;
    private String contentType;
    private ArrayList<LinkElement> links;
    private HashMap<String, String[]> nvPairs;
    private PrintWriter outPrintWriter;
    private HttpServletRequest req;
    private HttpServletResponse res;
    private String userId;
    private String userUrl;
    private ArrayList<ParserElement> workingObjects;

    public MsgObject(HttpServletRequest req, HttpServletResponse response) {
        try {
            this.nvPairs = new HashMap();
            this.nvPairs.putAll(req.getParameterMap());
            this.links = new ArrayList();
            this.userUrl = req.getRemoteAddr();
            this.query = new String[0];
            this.workingObjects = new ArrayList();
            this.res = response;
            this.req = req;
            Cookie[] cookies = req.getCookies();
            if (cookies == null) {
                cookies = new Cookie[]{new Cookie("useless", "cookie")};
            }
            for (int i = 0; i < cookies.length; ++i) {
                String name = cookies[i].getName();
                if (!name.equalsIgnoreCase(Config.getProperty("cookietag"))) continue;
                this.userId = cookies[i].getValue();
                break;
            }
            if (this.userId == null) {
                this.userId = "unknown";
            }
        }
        catch (IllegalArgumentException iae) {
            throw new RuntimeException("caught in constructor: " + iae.getMessage());
        }
    }

    public void copyFrom(MsgObject newMsg) {
        this.nvPairs = newMsg.getNVPairs();
        this.workingObjects = newMsg.getWorkingObjects();
        this.userId = newMsg.getUserId();
        this.userUrl = newMsg.getUserUrl();
    }

    public MsgObject() {
        this.nvPairs = new HashMap();
        this.links = new ArrayList();
        this.userUrl = null;
        this.outPrintWriter = null;
        this.query = new String[0];
        this.workingObjects = new ArrayList();
        this.res = null;
        this.req = null;
    }

    public void SetOutPrintWriter() throws MsgObjectException {
        try {
            this.outPrintWriter = this.res.getWriter();
        }
        catch (IOException ioe) {
            MsgObjectException moe = new MsgObjectException(ioe.getMessage());
            throw moe;
        }
    }

    public void setContentType(String type) {
        this.res.setContentType(type);
        this.contentType = type;
    }

    public void setHeader(String str1, String str2) {
        this.res.setHeader(str1, str2);
    }

    public void setLinks(ArrayList<LinkElement> theseLinks) {
        this.links = theseLinks;
    }

    public void setQuery(String queryVal, int sqlThread) {
        this.query[sqlThread] = queryVal;
    }

    public void setQuery(String queryVal) {
        String[] test = this.query;
        if (this.query == null) {
            this.query = new String[1];
            this.query[0] = queryVal;
        } else {
            int origLength = Array.getLength(this.query);
            this.query = new String[origLength + 1];
            System.arraycopy(test, 0, this.query, 0, origLength);
            this.query[this.query.length - 1] = queryVal;
        }
    }

    public void setRedirect(String output) throws IOException {
        this.res.sendRedirect(output);
    }

    public void setUserId(String userIdVal) {
        this.userId = userIdVal;
    }

    public void setUserUrl(String userUrlVal) {
        this.userUrl = userUrlVal;
    }

    public void setValue(String name, String value) {
        String[] newValues;
        String[] test = this.nvPairs.get(name);
        if (test == null) {
            newValues = new String[]{value};
        } else {
            int origLength = Array.getLength(test);
            newValues = new String[origLength + 1];
            System.arraycopy(test, 0, newValues, 0, origLength);
            newValues[newValues.length - 1] = value;
        }
        this.nvPairs.put(name, newValues);
    }

    public void setWorkingObjects(ArrayList<ParserElement> veVal) {
        this.workingObjects = veVal;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ArrayList<LinkElement> getLinks() {
        return this.links;
    }

    public HashMap<String, String[]> getNVPairs() {
        return this.nvPairs;
    }

    public Set<String> getNames() {
        return this.nvPairs.keySet();
    }

    public PrintWriter getOutPrintWriter() {
        return this.outPrintWriter;
    }

    public OutputStream getOutStreamWriter() {
        try {
            return this.res.getOutputStream();
        }
        catch (IOException ioe) {
            throw new MraldError(ioe, this);
        }
    }

    public String getProps() {
        return this.nvPairs.toString();
    }

    public String getQuery(int sqlThread) {
        return this.query[sqlThread];
    }

    public String[] getQuery() {
        try {
            if (this.query == null) {
                String[] temp = new String[]{""};
                this.query = temp;
            }
        }
        catch (NullPointerException nll) {
            String[] temp = new String[]{""};
            this.query = temp;
        }
        return this.query;
    }

    public HttpServletRequest getReq() {
        return this.req;
    }

    public HttpServletResponse getRes() {
        return this.res;
    }

    public int getSize() {
        return this.nvPairs.size();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserUrl() {
        return this.userUrl;
    }

    public String[] getValue(String name) {
        String[] returnVal = null;
        try {
            returnVal = this.nvPairs.get(name);
            if (returnVal == null) {
                String[] temp = new String[]{""};
                returnVal = temp;
            }
        }
        catch (NullPointerException nll) {
            String[] temp = new String[]{""};
            returnVal = temp;
        }
        return returnVal;
    }

    public ArrayList<ParserElement> getWorkingObjects() {
        return this.workingObjects;
    }

    public void addLink(LinkElement newLinkElement) {
        this.links.add(newLinkElement);
    }

    public void clearNvPairs() {
        this.nvPairs.clear();
    }

    public void closeOut() throws WorkflowStepException {
        try {
            if (this.outPrintWriter != null) {
                this.outPrintWriter.flush();
                this.outPrintWriter.close();
            }
        }
        catch (Exception e) {
            MraldOutFile.logToFile("Exception while closing out the MsgObject.  No biggie, but you might want to track this down eventually: " + Config.NEWLINE + this.toString());
        }
    }

    public String nameValuesToString() {
        StringBuffer ret = new StringBuffer();
        for (String key : this.nvPairs.keySet()) {
            if (key.toLowerCase().indexOf("password") != -1) continue;
            String[] values = this.nvPairs.get(key);
            ret.append("\n\t");
            ret.append(key);
            ret.append("=");
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    ret.append("; ");
                }
                ret.append(values[i]);
            }
        }
        return ret.toString();
    }

    public void removeValue(String key) {
        this.nvPairs.remove(key);
    }

    public boolean responseCommitted() {
        return this.res.isCommitted();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("Content Type: " + this.contentType);
        if (this.query.length == 0) {
            ret.append("\nNo queries stored.");
        } else {
            ret.append("\nQueries stored: ");
            for (int i = 0; i < this.query.length; ++i) {
                ret.append("\n\t");
                ret.append(ret.append(this.query[i]));
            }
        }
        ret.append("\nLinks stored:");
        MiscUtils.appendCollectionContents(this.links, ret);
        ret.append("\nWorking Objects stored:");
        MiscUtils.appendCollectionContents(this.workingObjects, ret);
        ret.append("\nName.Value pairs stored:");
        if (this.nvPairs.size() == 0) {
            ret.append("none.");
        } else {
            ret.append(this.nameValuesToString());
        }
        return ret.toString();
    }
}

