/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.ddlbuilder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.ddlbuilder.InsertBuilder;
import org.mitre.mrald.ddlelements.InsertElement;
import org.mitre.mrald.ddlelements.MultiInsertElementComparator;
import org.mitre.mrald.parser.ParserElement;
import org.mitre.mrald.util.MraldException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiInsertBuilder
extends InsertBuilder {
    MsgObject msg;

    @Override
    public String[] buildDdl(List<InsertElement> insertElements) throws MraldException {
        String ddl;
        ArrayList returnDdl = new ArrayList();
        ArrayList<InsertElement> commonElements = new ArrayList<InsertElement>();
        ArrayList<InsertElement> elements = new ArrayList<InsertElement>();
        boolean containsMultiSelection = false;
        InsertElement currentElement = null;
        int sqlThreadNo = 0;
        Iterator<InsertElement> iter = insertElements.iterator();
        for (int i = 0; i < insertElements.size(); ++i) {
            currentElement = iter.next();
            if (Integer.parseInt(currentElement.getSqlThread()) < 0) {
                commonElements.add(currentElement);
                continue;
            }
            if (sqlThreadNo != Integer.parseInt(currentElement.getSqlThread())) {
                sqlThreadNo = Integer.parseInt(currentElement.getSqlThread());
                if (elements.size() == 0) {
                    elements.add(currentElement);
                    continue;
                }
                elements.addAll(commonElements);
                if (containsMultiSelection) {
                    ArrayList<Object> newDDLs = new ArrayList();
                    newDDLs = this.constructMultiDdl(elements);
                    returnDdl.addAll(newDDLs);
                } else {
                    ddl = this.constructSingleDdl(elements);
                    returnDdl.add(ddl);
                }
                elements = new ArrayList();
                containsMultiSelection = false;
            }
            if (currentElement.getElementType().equals("MultiSelectionElement")) {
                containsMultiSelection = true;
            }
            elements.add(currentElement);
        }
        if (elements.size() > 0) {
            elements.addAll(commonElements);
            if (containsMultiSelection) {
                ArrayList<Object> newDDLs = new ArrayList();
                newDDLs = this.constructMultiDdl(elements);
                returnDdl.addAll(newDDLs);
            } else {
                ddl = this.constructSingleDdl(elements);
                returnDdl.add(ddl);
            }
        }
        if (returnDdl.size() == 0) {
            RuntimeException rte = new RuntimeException("No fields were chosen for insertion into any table.  No DDL statements were created. Try providing values for some fields and resubmit the request.");
            throw rte;
        }
        String[] returnArray = new String[returnDdl.size()];
        returnArray = returnDdl.toArray(returnArray);
        return returnArray;
    }

    public ArrayList<String> constructMultiDdl(ArrayList<InsertElement> elements) throws MraldException {
        ArrayList<String> multiValueStrings = new ArrayList<String>();
        ArrayList<String> fieldStrings = new ArrayList<String>();
        ArrayList<String> valueStrings = new ArrayList<String>();
        ArrayList<String> returnDDLs = new ArrayList<String>();
        for (int i = 0; i < elements.size(); ++i) {
            InsertElement currentElement = elements.get(i);
            if (currentElement.getElementType().equals("MultiSelectionElement")) {
                multiValueStrings = currentElement.buildValueList(multiValueStrings);
                valueStrings.add("P_H");
            } else {
                valueStrings = currentElement.buildValueList(valueStrings);
            }
            fieldStrings = currentElement.buildFieldList(fieldStrings);
        }
        if (multiValueStrings.size() == 0) {
            RuntimeException rte = new RuntimeException("No entries were chosen for the Multiple Selection Fields.  No associated DDL statements were created. Try providing values for this fields and resubmit the request.");
            throw rte;
        }
        for (int j = 0; j < multiValueStrings.size(); ++j) {
            String tableName = elements.get(0).getTable();
            StringBuffer start = new StringBuffer();
            StringBuffer end = new StringBuffer();
            start.append("INSERT INTO ");
            start.append(tableName);
            start.append(" ( ");
            end.append(" ) VALUES ( ");
            for (int i = 0; i < fieldStrings.size(); ++i) {
                start.append(fieldStrings.get(i));
                if (valueStrings.get(i).equals("P_H")) {
                    end.append(multiValueStrings.get(j));
                } else {
                    end.append(valueStrings.get(i));
                }
                if (i >= fieldStrings.size() - 1) continue;
                start.append(", ");
                end.append(", ");
            }
            end.append(" )");
            start.append(end);
            returnDDLs.add(start.toString());
        }
        return returnDDLs;
    }

    @Override
    public void execute(MsgObject msgObject) throws WorkflowStepException {
        try {
            this.msg = msgObject;
            ArrayList<ParserElement> parserElements = msgObject.getWorkingObjects();
            List<InsertElement> c = this.extractInsertElements(parserElements);
            this.removeInvalidElements(c);
            Collections.sort(c, new MultiInsertElementComparator());
            String[] ddl = this.buildDdl(c);
            for (int i = 0; i < ddl.length; ++i) {
                msgObject.setQuery(ddl[i]);
            }
        }
        catch (MraldException e) {
            throw new WorkflowStepException(e.getMessage());
        }
    }

    @Override
    public List<InsertElement> extractInsertElements(ArrayList<ParserElement> parserElements) {
        ArrayList<InsertElement> returnList = new ArrayList<InsertElement>();
        for (int i = 0; i < parserElements.size(); ++i) {
            ParserElement nextElement = parserElements.get(i);
            if (!(nextElement instanceof InsertElement)) continue;
            returnList.add((InsertElement)parserElements.get(i));
        }
        return returnList;
    }

    protected void addToSqlThread(ArrayList<InsertElement> commonElements, ArrayList<InsertElement> ddlElements, String threadNo) {
        for (int i = 0; i < commonElements.size(); ++i) {
            InsertElement e = commonElements.get(i);
            String[] nums = e.getSqlThread().split(",");
            for (int j = 0; j < nums.length; ++j) {
                if (!nums[j].equals(threadNo)) continue;
                ddlElements.add(e);
            }
        }
    }
}

