/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.ddlelements;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.ddlelements.DdlElement;
import org.mitre.mrald.parser.MraldParserException;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertElement
extends DdlElement {
    public InsertElement() {
    }

    public InsertElement(String table, String field, String _value, String type, String order, String sqlthread) {
        String name = "Table";
        String value = table;
        this.nameValues.setValue(name, value);
        name = "Field";
        value = field;
        this.nameValues.setValue(name, value);
        name = "Value";
        value = _value;
        this.nameValues.setValue(name, value);
        name = "Type";
        value = type;
        this.nameValues.setValue(name, value);
        name = "Order";
        value = order;
        this.nameValues.setValue(name, value);
        name = "SqlThread";
        value = sqlthread;
        this.nameValues.setValue(name, value);
    }

    @Override
    public String getElementType() {
        return "InsertElement";
    }

    public String getField() {
        return this.nameValues.getValue("Field")[0];
    }

    public String getValue() {
        return this.nameValues.getValue("Value")[0];
    }

    @Override
    public String postProcess(MsgObject msg, String currentName) throws MraldParserException {
        if (this.getSqlThread().equals("-1")) {
            this.nameValues.removeValue("Table");
            this.nameValues.setValue("Table", "!All");
            return currentName;
        }
        if (this.getSqlThread().indexOf(",") == -1) {
            return currentName;
        }
        this.setIsActive(false);
        String[] threads = this.getSqlThread().split(",");
        String[] tables = this.getTable().split(",");
        String[] fields = this.getField().split(",");
        String[] orders = this.nameValues.getValue("Order")[0].split(",");
        if (tables.length != 1 && tables.length != threads.length) {
            throw new MraldError("When using an insert element with multiple SqlThreads, the number of tables in the list must either be 1 or the same as the number of threads.  In the element named " + currentName + " the number of threads was " + threads.length + " and the number of tables was " + tables.length + ".", msg);
        }
        if (fields.length != 1 && fields.length != threads.length) {
            throw new MraldError("When using an insert element with multiple SqlThreads, the number of fields in the list must either be 1 or the same as the number of threads.  In the element named " + currentName + " the number of threads was " + threads.length + " and the number of fields was " + fields.length + ".", msg);
        }
        if (orders.length != 1 && orders.length != threads.length) {
            throw new MraldError("When using an insert element with multiple SqlThreads, the number of orders in the list must either be 1 or the same as the number of threads.  In the element named " + currentName + " the number of threads was " + threads.length + " and the number of orders was " + orders.length + ".", msg);
        }
        String table = this.nameValues.getValue("Table")[0];
        String field = this.nameValues.getValue("Field")[0];
        String _value = this.nameValues.getValue("Value")[0];
        String type = this.nameValues.getValue("Type")[0];
        String order = this.nameValues.getValue("Order")[0];
        String sqlthread = null;
        for (int i = 0; i < threads.length; ++i) {
            sqlthread = threads[i];
            if (tables.length != 1) {
                table = tables[i];
            }
            if (fields.length != 1) {
                table = fields[i];
            }
            if (orders.length != 1) {
                order = orders[i];
            }
            InsertElement ele = new InsertElement(table, field, _value, type, order, sqlthread);
            ele.setIsActive(true);
            msg.getWorkingObjects().add(ele);
        }
        return currentName;
    }

    @Override
    public ArrayList<String> buildFieldList(ArrayList<String> currentFieldList) {
        String valueCheck = this.nameValues.getValue("Value")[0];
        if (valueCheck.equals("")) {
            return currentFieldList;
        }
        String newValue = this.nameValues.getValue("Field")[0];
        currentFieldList.add(newValue);
        return currentFieldList;
    }

    @Override
    public ArrayList<String> buildValueList(ArrayList<String> currentValueList) throws MraldException {
        try {
            String newValue;
            String valueCheck = this.nameValues.getValue("Value")[0];
            if (valueCheck.equals("")) {
                return currentValueList;
            }
            String typeCheck = this.nameValues.getValue("Type")[0];
            if (typeCheck.equals("String")) {
                newValue = "'" + MiscUtils.checkApostrophe(valueCheck) + "'";
            } else if (typeCheck.equals("Date") || typeCheck.equals("DateTime") || typeCheck.equals("Timestamp")) {
                SimpleDateFormat df = new SimpleDateFormat("mm/dd/yyyy");
                Date date = df.parse(valueCheck);
                df.applyPattern("yyyy-mm-dd");
                String dateVal = df.format(date);
                newValue = " to_date('" + dateVal + "', 'YYYY-MM-DD')";
            } else {
                newValue = valueCheck;
            }
            currentValueList.add(newValue);
            return currentValueList;
        }
        catch (ParseException e) {
            throw new MraldException(e.getMessage());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InsertElement) {
            return o.hashCode() == this.hashCode();
        }
        return false;
    }
}

