/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.ddlelements;

import java.util.Comparator;
import org.mitre.mrald.ddlelements.DdlElement;
import org.mitre.mrald.util.MraldOutFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiInsertElementComparator
implements Comparator<DdlElement> {
    @Override
    public int compare(DdlElement de1, DdlElement de2) {
        int threadNo1 = this.getThreadNo(de1);
        int threadNo2 = this.getThreadNo(de2);
        int orderDiff = Integer.parseInt(de1.getOrder()) - Integer.parseInt(de2.getOrder());
        int sqlNoDiff = threadNo1 - threadNo2;
        return 1000 * sqlNoDiff + orderDiff;
    }

    protected int getThreadNo(DdlElement de) {
        try {
            return Integer.parseInt(de.getSqlThread());
        }
        catch (NumberFormatException e) {
            try {
                MraldOutFile.appendToFile("Number Format Exception: " + de.getSqlThread() + " With object : Table Name " + de.getTable() + " : " + de.toString() + e.getMessage());
                return Integer.parseInt(de.getSqlThread().substring(0, de.getSqlThread().indexOf(44)));
            }
            catch (NumberFormatException ne) {
                MraldOutFile.appendToFile("Number Format Exception: " + de.getSqlThread() + ne.getMessage());
                throw ne;
            }
        }
    }
}

