/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.formbuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.formbuilder.LinkElement;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.MraldOutFile;
import org.mitre.mrald.util.TableMetaData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossLinkElement
extends LinkElement {
    private String fieldEnd = "</tr>\n";
    private String fieldStart = "<tr align=\"center\">\n";
    private String tableEnd = "</table></center>\n";
    private String tableHeader = "<tr align=\"center\"><font size=\"-1\"><th width=\"25%\">Primary</th><th width=\"25%\">Foreign</th><th width=\"12%\">Ignore</th><th width=\"12%\">Full</th></tr>\n";
    private String tableStart = "<center><table cellspacing=\"0\" cellpadding=\"0\" border=\"1\">\n";

    @Override
    public String getElementType() {
        return "FormBuilder Link Element";
    }

    public String getFBHtml(ArrayList<DBMetaData> mds, int num, int thread) {
        StringBuffer ret = new StringBuffer();
        if (mds == null) {
            return "No Available Meta Data...";
        }
        if (mds.size() == 0) {
            return "No Available Meta Data...";
        }
        ret.append(this.tableStart);
        ret.append(this.tableHeader);
        String counterStr = "";
        for (int i = 0; i < 3; ++i) {
            counterStr = i + "";
            int uniqueCount = Integer.parseInt(counterStr);
            StringBuffer dropdown = new StringBuffer();
            dropdown.append("<td>");
            dropdown.append("\n<select name=\"");
            dropdown.append("CrossLink");
            dropdown.append(counterStr);
            dropdown.append("\">");
            dropdown.append("<option></option>");
            for (DBMetaData md : mds) {
                dropdown.append(CrossLinkElement.buildTableFieldDropDown(md).toString());
            }
            dropdown.append("</select>");
            dropdown.append("</td>\n");
            ret.append(this.fieldStart);
            ret.append(dropdown.toString().replaceAll("Table:", "Table1:").replaceAll("Field:", "Field1:").replaceAll("DBName:", "DBName1:").replaceAll("Schema:", "Schema1:"));
            ret.append(dropdown.toString().replaceAll("Table:", "Table2:").replaceAll("Field:", "Field2:").replaceAll("DBName:", "DBName2:").replaceAll("Schema:", "Schema2:"));
            ret.append("<td width=\"25%\"><input type=\"radio\" name=\"CrossLink" + uniqueCount + "\" value=\"Link:Ignore~SqlThread:-1\" CHECKED></td>\n");
            ret.append("<td width=\"25%\"><input type=\"radio\" name=\"CrossLink" + uniqueCount + "\" value=\"Link:Full~SqlThread:-1\" ></td>\n");
            ret.append(this.fieldEnd);
        }
        ret.append(this.fieldStart);
        ret.append("<br><font size=\"-1\">( Note: all tables included on this form must be joined to at least one other table )</font>");
        ret.append(this.fieldEnd);
        ret.append(this.tableEnd);
        return ret.toString();
    }

    @Override
    public String getFBHtml(DBMetaData md, int num, int thread) {
        StringBuffer ret = new StringBuffer();
        return ret.toString();
    }

    public static StringBuffer buildTableFieldDropDown(DBMetaData md) {
        StringBuffer ret = new StringBuffer();
        Properties props = md.getDbProps();
        String schema = props.getProperty("SCHEMA");
        String sidName = props.getProperty("DBNAME");
        Collection<TableMetaData> tableMetaData = md.getAllTableMetaData();
        for (TableMetaData tableInfo : tableMetaData) {
            Collection<String> fieldNames = tableInfo.getColumnNames();
            Iterator<String> iter2 = fieldNames.iterator();
            while (iter2.hasNext()) {
                String tableName = tableInfo.getName();
                String field = iter2.next();
                ret.append("<option value=\"Table:");
                ret.append(tableName);
                ret.append("~Field:");
                ret.append(field);
                ret.append("~DBName:");
                ret.append(sidName);
                ret.append("~Schema:");
                ret.append(schema);
                ret.append("\">");
                ret.append(tableInfo.getName());
                ret.append(".");
                ret.append(field);
                ret.append("</option>");
            }
        }
        return ret;
    }

    @Override
    public Node getFBNode(Document document) {
        MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "CrossLinkElement: getFBNode: start");
        String table1 = this.nameValues.getValue("Table1")[0];
        String field1 = this.nameValues.getValue("Field1")[0];
        String table2 = this.nameValues.getValue("Table2")[0];
        String field2 = this.nameValues.getValue("Field2")[0];
        String link = this.nameValues.getValue("Link")[0];
        String dbName1 = this.nameValues.getValue("DBName1")[0];
        String dbName2 = this.nameValues.getValue("DBName2")[0];
        String schema1 = this.nameValues.getValue("Schema1")[0];
        String schema2 = this.nameValues.getValue("Schema2")[0];
        String thread = this.nameValues.getValue("SqlThread")[0];
        if (!dbName1.equals("") && !schema1.equals("")) {
            table1 = dbName1 + "." + schema1 + "." + table1;
            MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "CrossLinkElement: getFBNode: table1 :" + table1);
        }
        if (!dbName2.equals("") && !schema2.equals("")) {
            table2 = dbName2 + "." + schema2 + "." + table2;
            MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "CrossLinkElement: getFBNode: table2 :" + table2);
        }
        if (!link.equals("Ignore")) {
            Element ret = document.createElement("crossLink");
            Element table1Element = document.createElement("primarytable");
            Text table1Text = document.createTextNode(table1);
            table1Element.appendChild(table1Text);
            ret.appendChild(table1Element);
            Element field1Element = document.createElement("primaryfield");
            Text field1Text = document.createTextNode(field1);
            field1Element.appendChild(field1Text);
            ret.appendChild(field1Element);
            Element table2Element = document.createElement("secondarytable");
            Text table2Text = document.createTextNode(table2);
            table2Element.appendChild(table2Text);
            ret.appendChild(table2Element);
            Element field2Element = document.createElement("secondaryfield");
            Text field2Text = document.createTextNode(field2);
            field2Element.appendChild(field2Text);
            ret.appendChild(field2Element);
            if (!thread.equals("")) {
                Element threadElement = document.createElement("sqlThread");
                Text threadText = document.createTextNode(thread);
                threadElement.appendChild(threadText);
                ret.appendChild(threadElement);
            }
            return ret;
        }
        return null;
    }

    @Override
    public boolean ignore() {
        return this.nameValues.getValue("Link")[0].equals("Ignore");
    }

    @Override
    public String postProcess(MsgObject msg, String currentName) {
        this.resetVariables("dummy");
        this.isActive = true;
        return currentName;
    }

    @Override
    public String preProcess(MsgObject msg, String currentName) {
        return currentName;
    }

    @Override
    public void resetVariables(String dummyString) {
        this.primaryField = this.nameValues.getValue("Field1")[0];
        this.primaryTable = this.nameValues.getValue("Table1")[0];
        this.secondaryField = this.nameValues.getValue("Field2")[0];
        this.secondaryTable = this.nameValues.getValue("Table2")[0];
    }
}

