/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.formbuilder;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.mitre.mrald.formbuilder.FormBuilderElement;
import org.mitre.mrald.parser.ParserElement;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.FBUtils;
import org.mitre.mrald.util.Link;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldOutFile;
import org.mitre.mrald.util.TableMetaData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FieldInsertElement
extends ParserElement
implements FormBuilderElement {
    Document document;

    public String getElementType() {
        return "Formbuilder Field Insert Element";
    }

    public String getFBHtml(DBMetaData md, int num, int thread) {
        Set formLinks = md.getLinkList();
        Iterator<Object> iter = formLinks.iterator();
        HashMap<String, Link> fks = new HashMap<String, Link>();
        while (iter.hasNext()) {
            if (md.getLinkList().size() <= 0) continue;
            Link linkInfo = (Link)iter.next();
            String fcolumn = new String(linkInfo.getFcolumn());
            fks.put(fcolumn, linkInfo);
        }
        StringBuffer ret = new StringBuffer();
        String SECTION_CLOSE = "\n</table></td></tr></table>";
        String SECTION_OPENER = "\n<table summary=\"\" width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td class=\"bord\"><table summary=\"\" width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"1\">";
        String TABLE_HEADER = "\n<!-- new table!! -->\n<tr align=\"left\"><font size=\"-1\"><th>Ignore</th><th>Table</th><th>Column Name</th><th>Column Label</th><th>Order</th><th>Required</th><th>List Column</th></font><th>Comments</th></tr><tr>";
        String CHECK_ALL_ROW = "\n<th><input type=checkbox onclick=\"if(this.checked==false){ClearAll('Ignore:true');}else{CheckAll('Ignore:true');}\"></th><th>&nbsp;</th><th>&nbsp;</th><th>&nbsp;</th><th>&nbsp;</th><th>&nbsp;</th><th>&nbsp;</th></tr>";
        String FIELD_ROW = "\n<tr><td align=\"center\"><input name=\"FBInsert<:orderNo:>\" value=\"Output:true~Table:<:tableName:>\" type=\"hidden\"><:pkinfo:><input name=\"FBInsert<:orderNo:>\" value=\"Ignore:true\" type=\"checkbox\"></td><td><:tableName:></td><td><input type=\"hidden\" name=\"FBInsert<:orderNo:>\" value=\"Field:<:column_name:>~Type:<:type:>\"><:column_name:></td><td><input name=\"FBInsert<:orderNo:>\" type=\"text\" size=\"15\" value=\"<:nice_column_name:>\"></td><td align=\"center\"><input name=\"FBInsert<:orderNo:>\" type=\"text\" size=\"3\" value=\"<:orderNo:>\"></td><td align=\"center\"><input name=\"FBInsert<:orderNo:>\" type=\"checkbox\" value=\"Required:true\" <:required:>></td><td align=\"left\"><:listColumn:></td><td align=\"left\"><:comments:></td>";
        Collection<TableMetaData> tableMetaData = md.getAllTableMetaData();
        iter = tableMetaData.iterator();
        int orderNo = 1;
        ret.append(SECTION_OPENER);
        try {
            TableMetaData tableInfo = md.getTableMetaData(md.getOriginalTables()[0]);
            Collection<String> fieldNames = tableInfo.getColumnNames();
            ret.append(TABLE_HEADER);
            ret.append(CHECK_ALL_ROW.replaceAll("<:tableName:>", tableInfo.getName()));
            for (String field : fieldNames) {
                String newRow = FIELD_ROW.replaceAll("<:column_name:>", field);
                String niceName = FBUtils.getColumnName(tableInfo.getName() + "." + field);
                newRow = niceName == null ? newRow.replaceAll("<:nice_column_name:>", field) : MiscUtils.replace(newRow, "<:nice_column_name:>", niceName);
                if (fks.containsKey(field)) {
                    String pkTable = ((Link)fks.get(field)).getPtable();
                    String pkColumn = ((Link)fks.get(field)).getPcolumn();
                    newRow = pkTable != tableInfo.getName() ? newRow.replaceAll("<:listColumn:>", this.getDropDownList(pkTable, pkColumn, md, orderNo)) : newRow.replaceAll("<:listColumn:>", "");
                } else {
                    newRow = newRow.replaceAll("<:listColumn:>", "");
                }
                Integer colType = tableInfo.getFieldType(field);
                newRow = FBUtils.isDateType(colType) ? newRow.replaceAll("<:type:>", "Date") : (FBUtils.isNumberType(colType) ? newRow.replaceAll("<:type:>", "Numeric") : newRow.replaceAll("<:type:>", "String"));
                if (tableInfo.isPrimaryKey(field)) {
                    newRow = newRow.replaceAll("<:required:>", "checked=\"true\"");
                    newRow = newRow.replaceAll("<:pkinfo:>", "<input name=\"FBInsert<:orderNo:>\" value=\"PrimaryKey:true\" type=\"hidden\">");
                } else {
                    newRow = newRow.replaceAll("<:required:>", "");
                    newRow = newRow.replaceAll("<:pkinfo:>", "");
                }
                String comments = tableInfo.getFieldComments(field);
                if (comments == null) {
                    comments = "no comments for this field";
                }
                newRow = newRow.replaceAll("<:comments:>", comments);
                newRow = newRow.replaceAll("<:tableName:>", tableInfo.getName());
                newRow = MiscUtils.replace(newRow, "<:orderNo:>", orderNo++);
                ret.append(newRow + "</tr>");
            }
        }
        catch (IndexOutOfBoundsException e) {
            MraldOutFile.logToFile(e);
        }
        ret.append(SECTION_CLOSE);
        return ret.toString();
    }

    private String getDropDownList(String tableName, String pkColumn, DBMetaData md, int cnt) {
        return FBUtils.buildTableFieldDropDown(md, "FBInsert", cnt, tableName, pkColumn, "listTable", "listIdCol", "listColumn").toString();
    }

    public Node getFBNode(Document document) {
        String label;
        String order;
        this.document = document;
        if (this.nameValues.getValue("Ignore")[0].equals("true")) {
            return null;
        }
        Element ret = document.createElement("field");
        String output = this.nameValues.getValue("Output")[0];
        String checked = this.nameValues.getValue("Default")[0];
        String filter = this.nameValues.getValue("Filter")[0];
        String stats = this.nameValues.getValue("Stat")[0];
        String groupby = this.nameValues.getValue("Group")[0];
        String sort = this.nameValues.getValue("Sort")[0];
        this.addAttribute(ret, "output", output);
        this.addAttribute(ret, "checked", checked);
        this.addAttribute(ret, "filter", filter);
        this.addAttribute(ret, "stats", stats);
        this.addAttribute(ret, "groupby", groupby);
        this.addAttribute(ret, "sort", sort);
        String type = this.nameValues.getValue("Type")[0];
        String format = this.nameValues.getValue("Format")[0];
        String table = this.nameValues.getValue("Table")[0];
        String field = this.nameValues.getValue("Field")[0];
        String[] values = this.nameValues.getValue("Value");
        String isPk = this.nameValues.getValue("PrimaryKey")[0];
        String reqd = this.nameValues.getValue("Required")[0];
        String listTable = this.nameValues.getValue("listTable")[0];
        String listColumn = this.nameValues.getValue("listColumn")[0];
        String listIdColumn = this.nameValues.getValue("listIdCol")[0];
        if (this.isNumber(values[0])) {
            order = values[0];
            label = values[1];
        } else {
            label = values[0];
            order = values[1];
        }
        FBUtils.addTextNode(document, ret, "column", field);
        FBUtils.addTextNode(document, ret, "table", table);
        FBUtils.addTextNode(document, ret, "label", label);
        FBUtils.addTextNode(document, ret, "type", type);
        if (!isPk.equals("")) {
            FBUtils.addTextNode(document, ret, "pkey", isPk);
        }
        if (!reqd.equals("")) {
            FBUtils.addTextNode(document, ret, "required", reqd);
        }
        if (!listTable.equals("")) {
            FBUtils.addTextNode(document, ret, "listTable", listTable);
            FBUtils.addTextNode(document, ret, "listColumn", listColumn);
            FBUtils.addTextNode(document, ret, "listIdCol", listIdColumn);
        }
        if (!format.equals("")) {
            FBUtils.addTextNode(document, ret, "format", format);
        }
        FBUtils.addTextNode(document, ret, "order", order);
        return ret;
    }

    public boolean isNumber(String testee) {
        return testee.matches("\\d*\\.*\\d*");
    }

    public void addAttribute(Element ret, String name, String value) {
        if (value.equals("true")) {
            ret.setAttribute(name, "yes");
        } else {
            ret.setAttribute(name, "no");
        }
    }
}

