/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.formbuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.mitre.mrald.formbuilder.FormBuilderElement;
import org.mitre.mrald.parser.ParserElement;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.FBUtils;
import org.mitre.mrald.util.Link;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldOutFile;
import org.mitre.mrald.util.TableMetaData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FieldUpdateElement
extends ParserElement
implements FormBuilderElement {
    Document document;

    public String getElementType() {
        return "Formbuilder Field Update Element";
    }

    public String getFBHtml(DBMetaData md, int num, int thread) {
        StringBuffer ret = new StringBuffer();
        String SECTION_CLOSE = "\n</table></td></tr></table>";
        String SECTION_OPENER = "\n<table summary=\"\" width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td class=\"bord\"><table summary=\"\" width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"2\">";
        String TABLE_HEADER = "\n<!-- new table!! -->\n<tr align=\"left\"><font size=\"-1\"><th>Table</th><th>Column Name</th><th>Column Label</th><th>Index For Update(Primary Keys)</th><th>List Column</th><th>Filter</th><th>Stats</th><th>Group By</th><th>Order</th><th>Sort</th><th>Format</th></font></tr>";
        String CHECK_ALL_ROW = "\n<tr><th>&nbsp;</th><th>&nbsp;</th><th>&nbsp;</th><th>&nbsp;</th><th>&nbsp;</th><th><input type=checkbox onclick=\"if(this.checked==false){ClearAll('Filter:true~Table:<:tableName:>');} else{CheckAll('Filter:true~Table:<:tableName:>');}\" checked></th><th><input type=checkbox onclick=\"if(this.checked==false){ClearAll('Stat:true~Table:<:tableName:>');} else{CheckAll('Stat:true~Table:<:tableName:>');}\" checked></th><th><input type=checkbox onclick=\"if(this.checked==false){ClearAll('Group:true~Table:<:tableName:>');} else{CheckAll('Group:true~Table:<:tableName:>');}\" checked></th><th>&nbsp;</th><th><input type=checkbox onclick=\"if(this.checked==false){ClearAll('Sort:true~Table:<:tableName:>');} else{CheckAll('Sort:true~Table:<:tableName:>');}\" checked></th><th>&nbsp;</th></tr>";
        String FIELD_ROW = "\n<tr><td><:tableName:></td><td><input type=\"hidden\" name=\"FBUpdate<:orderNo:>\" value=\"Table:<:tableName:>~Field:<:column_name:>~Type:<:type:>\"><:column_name:></td><td><input name=\"FBUpdate<:orderNo:>\" type=\"text\" size=\"15\" value=\"<:nice_column_name:>\"></td><td><input type=checkbox \"<:checkedVal:>\" name=\"FBUpdate<:orderNo:>\" value=\"PrimaryKey:<:PrimaryKey:>\"></td><td align=\"left\"><:listColumn:></td><td align=\"center\"><input name=\"FBUpdate<:orderNo:>\" value=\"Filter:true~Table:<:tableName:>\" type=\"checkbox\" checked></td><td align=\"center\"><input name=\"FBUpdate<:orderNo:>\" value=\"Stat:true~Table:<:tableName:>\" type=\"checkbox\" <:stat checked:>></td><td align=\"center\"><input name=\"FBUpdate<:orderNo:>\" value=\"Group:true~Table:<:tableName:>\" type=\"checkbox\" checked></td><td align=\"center\"><input name=\"FBUpdate<:orderNo:>\" type=\"text\" size=\"3\" value=\"<:orderNo:>\"></td><td align=\"center\"><input name=\"FBUpdate<:orderNo:>\" value=\"Sort:true~Table:<:tableName:>\" type=\"checkbox\" checked></td><td><:formatChoices:></td><input name=\"FBUpdate<:orderNo:>\" value=\"Output:true~Table:<:tableName:>\" type=\"hidden\"><input name=\"FBUpdate<:orderNo:>\" value=\"Default:true~Table:<:tableName:>\" type=\"hidden\"></tr>";
        String NUMBER_FORMAT_REGEX = "\n<select name=\"FBUpdate<:orderNo:>\"><option value=\"\" SELECTED>As Stored</option><option value=\"Format:#\">#</option><option value=\"Format:#.#\">#.#</option><option value=\"Format:#.##\">#.##</option><option value=\"Format:#.0\">#.0</option><option value=\"Format:#,###\">#,###</option><option value=\"Format:#,###.0\">#,###.0</option><option value=\"Format:#,##0.0\">#,##0.0</option><option value=\"Format:#.##%\">#.##%</option><option value=\"Format:$#,##0.00\">$#,##0.00</option><option value=\"Format:$#,##0.00;($#,##0.00)\">$#,##0.00;($#,##0.00)</option><option value=\"Format:#.###E0\">#.###E0</option><option value=\"Format:#.#####E0\">#.#####E0</option></select>";
        String DATE_FORMAT_REGEX = "\n<select name=\"FBUpdate<:orderNo:>\"><option value=\"Format:yyyy\">yyyy</option><option value=\"Format:MM/yy\">MM/yy</option><option value=\"Format:MM/dd\">MM/dd</option><option value=\"Format:MM/yyyy\">MM/yyyy</option><option value=\"Format:MM/dd/yyyy\">MM/dd/yyyy</option><option value=\"Format:yyyy MMMM d\">yyyy MMMM d</option><option value=\"Format:d MMMM yyyy\">d MMMM yyyy</option><option value=\"Format:MM/dd/yyyy hh:mm a\">MM/dd/yyyy hh:mm a</option><option value=\"Format:MM/dd/yyyy HH:mm\">MM/dd/yyyy HH:mm</option><option value=\"Format:MM/dd/yyyy hh:mm:ss a\">MM/dd/yyyy hh:mm:ss a</option><option value=\"Format:MM/dd/yyyy HH:mm:ss\" SELECTED>MM/dd/yyyy HH:mm:ss</option><option value=\"Format:yyyy MMMM d, HH:mm:ss\">yyyy MMMM d, HH:mm:ss</option><option value=\"Format:d MMMM yyyy, HH:mm:ss\">d MMMM yyyy, HH:mm:ss</option></select>";
        String OTHER_FORMAT_REGEX = "\n&nbsp;";
        int orderNo = 1;
        ret.append(SECTION_OPENER);
        try {
            TableMetaData tableInfo = md.getTableMetaData(md.getOriginalTables()[0]);
            ArrayList pks = this.getLinks(md, tableInfo.getName());
            HashMap fks = this.getFkLinks(md);
            Collection<String> fieldNames = tableInfo.getColumnNames();
            ret.append(TABLE_HEADER);
            ret.append(CHECK_ALL_ROW.replaceAll("<:tableName:>", tableInfo.getName()));
            Iterator<String> iter2 = fieldNames.iterator();
            int i = 0;
            while (iter2.hasNext()) {
                String field = iter2.next();
                StringBuffer pkBuff = new StringBuffer();
                String newRow = FIELD_ROW.replaceAll("<:PrimaryKey:>", field.toString());
                boolean isFound = false;
                for (i = 0; i < pks.size(); ++i) {
                    if (!pks.get(i).equals(field)) continue;
                    newRow = newRow.replaceAll("<:checkedVal:>", " checked ");
                    isFound = true;
                }
                if (!isFound) {
                    newRow = newRow.replaceAll("<:checkedVal:>", " ");
                }
                newRow = newRow.replaceAll("<:column_name:>", field);
                String niceName = FBUtils.getColumnName(tableInfo.getName() + "." + field);
                newRow = niceName == null ? newRow.replaceAll("<:nice_column_name:>", field) : MiscUtils.replace(newRow, "<:nice_column_name:>", niceName);
                Integer colType = tableInfo.getFieldType(field);
                if (FBUtils.isDateType(colType)) {
                    newRow = MiscUtils.replace(newRow, "<:formatChoices:>", DATE_FORMAT_REGEX);
                    newRow = MiscUtils.replace(newRow, "<:stat checked:>", "");
                    newRow = newRow.replaceAll("<:type:>", "Date");
                } else if (FBUtils.isNumberType(colType)) {
                    newRow = MiscUtils.replace(newRow, "<:formatChoices:>", NUMBER_FORMAT_REGEX);
                    newRow = MiscUtils.replace(newRow, "<:stat checked:>", "checked");
                    newRow = newRow.replaceAll("<:type:>", "Numeric");
                } else {
                    newRow = MiscUtils.replace(newRow, "<:formatChoices:>", OTHER_FORMAT_REGEX);
                    newRow = MiscUtils.replace(newRow, "<:stat checked:>", "");
                    newRow = newRow.replaceAll("<:type:>", "String");
                }
                String comments = tableInfo.getFieldComments(field);
                if (comments == null) {
                    comments = "no comments for this field";
                }
                newRow = newRow.replaceAll("<:comments:>", comments);
                newRow = newRow.replaceAll("<:tableName:>", tableInfo.getName());
                if (fks.containsKey(field)) {
                    String pkTable = ((Link)fks.get(field)).getPtable();
                    String pkColumn = ((Link)fks.get(field)).getPcolumn();
                    newRow = pkTable != tableInfo.getName() ? newRow.replaceAll("<:listColumn:>", this.getDropDownList(pkTable, pkColumn, md, orderNo)) : newRow.replaceAll("<:listColumn:>", "");
                } else {
                    newRow = newRow.replaceAll("<:listColumn:>", "");
                }
                newRow = newRow + pkBuff.toString();
                newRow = MiscUtils.replace(newRow, "<:orderNo:>", orderNo++);
                ret.append(newRow);
            }
        }
        catch (IndexOutOfBoundsException e) {
            MraldOutFile.logToFile(e);
        }
        ret.append(SECTION_CLOSE);
        return ret.toString();
    }

    public ArrayList getLinks(DBMetaData md, String table) {
        return (ArrayList)md.getTableMetaData(table).getPrimaryKeys();
    }

    public HashMap getFkLinks(DBMetaData md) {
        HashMap<String, Link> fks = new HashMap<String, Link>();
        Set formLinks = md.getLinkList();
        Iterator iter = formLinks.iterator();
        while (iter.hasNext()) {
            if (md.getLinkList().size() <= 0) continue;
            Link linkInfo = (Link)iter.next();
            String fcolumn = new String(linkInfo.getFcolumn());
            fks.put(fcolumn, linkInfo);
        }
        return fks;
    }

    public Node getFBNode(Document document) {
        String label;
        String order;
        this.document = document;
        if (this.nameValues.getValue("Ignore")[0].equals("true")) {
            return null;
        }
        Element ret = document.createElement("field");
        String output = this.nameValues.getValue("Output")[0];
        String checked = this.nameValues.getValue("Default")[0];
        String filter = this.nameValues.getValue("Filter")[0];
        String stats = this.nameValues.getValue("Stat")[0];
        String groupby = this.nameValues.getValue("Group")[0];
        String sort = this.nameValues.getValue("Sort")[0];
        String primaryKey = this.nameValues.getValue("PrimaryKey")[0];
        String listTable = this.nameValues.getValue("listTable")[0];
        String listColumn = this.nameValues.getValue("listColumn")[0];
        String listIdColumn = this.nameValues.getValue("listIdCol")[0];
        this.addAttribute(ret, "output", output);
        this.addAttribute(ret, "checked", checked);
        this.addAttribute(ret, "filter", filter);
        this.addAttribute(ret, "stats", stats);
        this.addAttribute(ret, "groupby", groupby);
        this.addAttribute(ret, "sort", sort);
        String type = this.nameValues.getValue("Type")[0];
        String format = this.nameValues.getValue("Format")[0];
        String table = this.nameValues.getValue("Table")[0];
        String field = this.nameValues.getValue("Field")[0];
        String[] values = this.nameValues.getValue("Value");
        if (this.isNumber(values[0])) {
            order = values[0];
            label = values[1];
        } else {
            label = values[0];
            order = values[1];
        }
        FBUtils.addTextNode(document, ret, "column", field);
        FBUtils.addTextNode(document, ret, "table", table);
        FBUtils.addTextNode(document, ret, "label", label);
        FBUtils.addTextNode(document, ret, "type", type);
        if (!format.equals("")) {
            FBUtils.addTextNode(document, ret, "format", format);
        }
        if (!primaryKey.equals("")) {
            FBUtils.addTextNode(document, ret, "primaryKey", primaryKey);
        }
        if (!listTable.equals("")) {
            FBUtils.addTextNode(document, ret, "listTable", listTable);
            FBUtils.addTextNode(document, ret, "listColumn", listColumn);
            FBUtils.addTextNode(document, ret, "listIdCol", listIdColumn);
        }
        FBUtils.addTextNode(document, ret, "order", order);
        return ret;
    }

    private String getDropDownList(String tableName, String pkColumn, DBMetaData md, int cnt) {
        return FBUtils.buildTableFieldDropDown(md, "FBUpdate", cnt, tableName, pkColumn, "listTable", "listIdCol", "listColumn").toString();
    }

    public boolean isNumber(String testee) {
        return testee.matches("\\d*\\.*\\d*");
    }

    public void addAttribute(Element ret, String name, String value) {
        if (value.equals("true")) {
            ret.setAttribute(name, "yes");
        } else {
            ret.setAttribute(name, "no");
        }
    }
}

