/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.formbuilder;

import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.formbuilder.FormBuilderElement;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.FBUtils;
import org.mitre.mrald.util.Link;
import org.mitre.mrald.util.MraldOutFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class LinkElement
extends org.mitre.mrald.query.LinkElement
implements FormBuilderElement {
    private String fieldEnd = "</tr>\n";
    private String fieldStart = "<tr align=\"center\">\n";
    private String tableEnd = "</table></center>\n";
    private String tableHeader = "<tr align=\"center\"><font size=\"-1\"><th width=\"25%\">Primary</th><th width=\"25%\">Foreign</th><th width=\"12%\">Ignore</th><th width=\"12%\">Full</th></tr>\n";
    private String tableStart = "<center><table cellspacing=\"0\" cellpadding=\"0\" border=\"1\">\n";

    public String getElementType() {
        return "FormBuilder Link Element";
    }

    public String getFBHtml(DBMetaData md, int num, int thread) {
        StringBuffer ret = new StringBuffer();
        if (md == null) {
            return "No Avaliable Meta Data...";
        }
        Set formLinks = md.getLinkList();
        if (formLinks == null) {
            return "No Avaliable Links...";
        }
        Iterator iter = formLinks.iterator();
        ret.append(this.tableStart);
        ret.append(this.tableHeader);
        int counter = 3;
        Properties props = md.getDbProps();
        String schema = props.getProperty("SCHEMA");
        String sidName = props.getProperty("DBNAME");
        while (iter.hasNext()) {
            Link linkInfo = (Link)iter.next();
            String ptable = linkInfo.getPtable();
            String pcolumn = linkInfo.getPcolumn();
            String ftable = linkInfo.getFtable();
            String fcolumn = linkInfo.getFcolumn();
            String fullLink = "DBName:" + sidName + "~Schema:" + schema + "~Table1:" + ptable + "~Field1:" + pcolumn + "~Table2:" + ftable + "~Field2:" + fcolumn + "~SqlThread:" + thread;
            ret.append(this.fieldStart);
            ret.append("<td align=\"left\" width=\"25%\">" + ptable + "." + pcolumn + "</td>\n");
            ret.append("<td align=\"left\" width=\"25%\">" + ftable + "." + fcolumn + "</td>\n");
            ret.append("<td width=\"25%\"><input type=\"radio\" name=\"FBLink" + counter + thread + "\" value=\"" + fullLink + "~Link:Ignore \" ></td>\n");
            ret.append("<td width=\"25%\"><input type=\"radio\" name=\"FBLink" + counter + thread + "\" value=\"" + fullLink + "~Link:Full \" CHECKED></td>\n");
            ret.append(this.fieldEnd);
            ++counter;
        }
        String counterStr = "";
        for (int i = 0; i < 3; ++i) {
            counterStr = i + "" + thread;
            int uniqueCount = Integer.parseInt(counterStr);
            StringBuffer dropdown = new StringBuffer();
            dropdown.append("<td>");
            dropdown.append(FBUtils.buildTableFieldDropDown(md, "FBLink", uniqueCount).toString());
            dropdown.append("</td>\n");
            ret.append(this.fieldStart);
            ret.append("<input type=\"hidden\" name=\"FBLink" + uniqueCount + "\" value=\"DBName:" + sidName + "~Schema:" + schema + "~SqlThread:" + thread + "\" />");
            ret.append(dropdown.toString().replaceAll("Table:", "Table1:").replaceAll("Field:", "Field1:"));
            ret.append(dropdown.toString().replaceAll("Table:", "Table2:").replaceAll("Field:", "Field2:"));
            ret.append("<td width=\"25%\"><input type=\"radio\" name=\"FBLink" + uniqueCount + "\" value=\"Link:Ignore~SqlThread:" + thread + "\" CHECKED></td>\n");
            ret.append("<td width=\"25%\"><input type=\"radio\" name=\"FBLink" + uniqueCount + "\" value=\"Link:Full~SqlThread:" + thread + "\" ></td>\n");
            ret.append(this.fieldEnd);
        }
        ret.append(this.fieldStart);
        ret.append("<br><font size=\"-1\">( Note: all tables included on this form must be joined to at least one other table )</font>");
        ret.append(this.fieldEnd);
        ret.append(this.tableEnd);
        return ret.toString();
    }

    public Node getFBNode(Document document) {
        String table1 = this.nameValues.getValue("Table1")[0];
        String field1 = this.nameValues.getValue("Field1")[0];
        String table2 = this.nameValues.getValue("Table2")[0];
        String field2 = this.nameValues.getValue("Field2")[0];
        String link = this.nameValues.getValue("Link")[0];
        String thread = this.nameValues.getValue("SqlThread")[0];
        String dbName = this.nameValues.getValue("DBName")[0];
        String schemaName = this.nameValues.getValue("Schema")[0];
        if (!dbName.equals("") && !schemaName.equals("")) {
            table1 = dbName + "." + schemaName + "." + table1;
            table2 = dbName + "." + schemaName + "." + table2;
            MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "LinkElement: getFBNode: table1 :" + table1);
        }
        if (!link.equals("Ignore")) {
            Element ret = document.createElement("link");
            Element table1Element = document.createElement("primarytable");
            Text table1Text = document.createTextNode(table1);
            table1Element.appendChild(table1Text);
            ret.appendChild(table1Element);
            Element field1Element = document.createElement("primaryfield");
            Text field1Text = document.createTextNode(field1);
            field1Element.appendChild(field1Text);
            ret.appendChild(field1Element);
            Element table2Element = document.createElement("secondarytable");
            Text table2Text = document.createTextNode(table2);
            table2Element.appendChild(table2Text);
            ret.appendChild(table2Element);
            Element field2Element = document.createElement("secondaryfield");
            Text field2Text = document.createTextNode(field2);
            field2Element.appendChild(field2Text);
            ret.appendChild(field2Element);
            if (!thread.equals("")) {
                Element threadElement = document.createElement("sqlThread");
                Text threadText = document.createTextNode(thread);
                threadElement.appendChild(threadText);
                ret.appendChild(threadElement);
            }
            return ret;
        }
        return null;
    }

    public boolean ignore() {
        return this.nameValues.getValue("Link")[0].equals("Ignore");
    }

    public String postProcess(MsgObject msg, String currentName) {
        this.resetVariables("dummy");
        this.isActive = true;
        return currentName;
    }

    public String preProcess(MsgObject msg, String currentName) {
        return currentName;
    }

    public void resetVariables(String dummyString) {
        this.primaryField = this.nameValues.getValue("Field1")[0];
        this.primaryTable = this.nameValues.getValue("Table1")[0];
        this.secondaryField = this.nameValues.getValue("Field2")[0];
        this.secondaryTable = this.nameValues.getValue("Table2")[0];
    }
}

