/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.formbuilder;

import java.util.Collection;
import org.mitre.mrald.formbuilder.FormBuilderElement;
import org.mitre.mrald.parser.ParserElement;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.FBUtils;
import org.mitre.mrald.util.TableMetaData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PivotElement
extends ParserElement
implements FormBuilderElement {
    public String getElementType() {
        return "Formbuilder Pivot Element";
    }

    public String getFBHtml(DBMetaData md, int num, int thread) {
        StringBuffer ret = new StringBuffer();
        ret.append("\n<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\">");
        ret.append("<tr>");
        ret.append("<td width=\"5%\" align=\"center\"><input name=\"FBPivot\" type=\"checkbox\" value=\"PivotResults\"></td>\n");
        ret.append("<td width=\"20%\">Pivot the output</td>\n");
        ret.append("<td width=\"5%\">Entity:</td>\n");
        ret.append("<td width=\"20%\"><select name=\"FBPivot\" onChange=\"HandlePivot(this);\">");
        this.appendOptions(md, ret, "Entity");
        ret.append("</select></td>\n");
        ret.append("<td width=\"5%\">Attribute:</td>\n");
        ret.append("<td width=\"20%\"><select name=\"FBPivot\" onChange=\"HandlePivot(this);\">");
        this.appendOptions(md, ret, "Attribute");
        ret.append("</select></td>\n");
        ret.append("<td width=\"5%\">Value:</td>\n");
        ret.append("<td width=\"20%\"><select name=\"FBPivot\" onChange=\"HandlePivot(this);\">");
        this.appendOptions(md, ret, "Value");
        ret.append("</select></td>\n");
        ret.append("</tr>");
        ret.append("\n</table>");
        return ret.toString();
    }

    private void appendOptions(DBMetaData md, StringBuffer ret, String which) {
        ret.append("<option></option>");
        Collection<TableMetaData> tableMetaData = md.getAllTableMetaData();
        for (TableMetaData tableInfo : tableMetaData) {
            String tableName = tableInfo.getName();
            Collection<String> fieldNames = tableInfo.getColumnNames();
            for (String fieldName : fieldNames) {
                Integer colType = tableInfo.getFieldType(fieldName);
                String typeName = FBUtils.isDateType(colType) ? "Date" : (FBUtils.isNumberType(colType) ? "Numeric" : "String");
                ret.append("<option value=\"");
                ret.append(which);
                ret.append("Table");
                ret.append(":");
                ret.append(tableName);
                ret.append("~");
                ret.append(which);
                ret.append("Field");
                ret.append(":");
                ret.append(fieldName);
                ret.append("~");
                ret.append(which);
                ret.append("Type");
                ret.append(":");
                ret.append(typeName);
                ret.append("\">");
                ret.append(tableName);
                ret.append(".");
                ret.append(fieldName);
                ret.append("</option>");
            }
        }
    }

    public Node getFBNode(Document document) {
        String checkValue = this.nameValues.getValue("Value")[0];
        if (checkValue.equals("PivotResults") && !this.missingAnyTag() && this.allFieldsFromOneTable()) {
            Element result = document.createElement("pivot");
            result.setTextContent(this.getText());
            return result;
        }
        return null;
    }

    private boolean missingAnyTag() {
        return this.nameValues.getValue("EntityTable")[0].equals("") || this.nameValues.getValue("EntityField")[0].equals("") || this.nameValues.getValue("EntityType")[0].equals("") || this.nameValues.getValue("AttributeTable")[0].equals("") || this.nameValues.getValue("AttributeField")[0].equals("") || this.nameValues.getValue("AttributeType")[0].equals("") || this.nameValues.getValue("ValueTable")[0].equals("") || this.nameValues.getValue("ValueField")[0].equals("") || this.nameValues.getValue("ValueType")[0].equals("");
    }

    private boolean allFieldsFromOneTable() {
        String entity = this.nameValues.getValue("EntityTable")[0];
        String attribute = this.nameValues.getValue("AttributeTable")[0];
        String value = this.nameValues.getValue("ValueTable")[0];
        if (entity == null) {
            return false;
        }
        return entity.equals(attribute) && entity.equals(value);
    }

    private String getText() {
        StringBuffer result = new StringBuffer();
        result.append(this.nameValues.getValue("EntityTable")[0]).append("~");
        result.append(this.nameValues.getValue("EntityField")[0]).append("~");
        result.append(this.nameValues.getValue("EntityType")[0]).append("~");
        result.append(this.nameValues.getValue("AttributeTable")[0]).append("~");
        result.append(this.nameValues.getValue("AttributeField")[0]).append("~");
        result.append(this.nameValues.getValue("AttributeType")[0]).append("~");
        result.append(this.nameValues.getValue("ValueTable")[0]).append("~");
        result.append(this.nameValues.getValue("ValueField")[0]).append("~");
        result.append(this.nameValues.getValue("ValueType")[0]);
        return result.toString();
    }
}

