/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.graphics;

import edu.berkeley.guir.prefuse.Display;
import edu.berkeley.guir.prefuse.EdgeItem;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.action.Action;
import edu.berkeley.guir.prefuse.action.RepaintAction;
import edu.berkeley.guir.prefuse.action.assignment.ColorFunction;
import edu.berkeley.guir.prefuse.action.filter.GraphFilter;
import edu.berkeley.guir.prefuse.activity.ActionList;
import edu.berkeley.guir.prefuse.activity.Activity;
import edu.berkeley.guir.prefuse.event.ControlAdapter;
import edu.berkeley.guir.prefuse.event.ControlListener;
import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.render.DefaultEdgeRenderer;
import edu.berkeley.guir.prefuse.render.DefaultRendererFactory;
import edu.berkeley.guir.prefuse.render.Renderer;
import edu.berkeley.guir.prefuse.render.RendererFactory;
import edu.berkeley.guir.prefusex.controls.DragControl;
import edu.berkeley.guir.prefusex.controls.FocusControl;
import edu.berkeley.guir.prefusex.controls.NeighborHighlightControl;
import edu.berkeley.guir.prefusex.controls.PanControl;
import edu.berkeley.guir.prefusex.controls.ZoomControl;
import edu.berkeley.guir.prefusex.force.DragForce;
import edu.berkeley.guir.prefusex.force.Force;
import edu.berkeley.guir.prefusex.force.ForcePanel;
import edu.berkeley.guir.prefusex.force.ForceSimulator;
import edu.berkeley.guir.prefusex.force.NBodyForce;
import edu.berkeley.guir.prefusex.force.SpringForce;
import edu.berkeley.guir.prefusex.layout.ForceDirectedLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.JFrame;
import org.mitre.mrald.graphics.DBGraphReader;
import org.mitre.mrald.graphics.FreezeAction;
import org.mitre.mrald.graphics.TableNodeRenderer;
import org.mitre.mrald.util.MraldOutFile;

public class DBDemo
extends Display {
    private JFrame frame;
    private ForcePanel fpanel;
    private ForceSimulator m_fsim;
    private String m_textField;
    private ItemRegistry m_registry;
    private Activity m_actionList;

    public DBDemo() {
        this.addControlListener((ControlListener)new NeighborHighlightControl());
        this.addControlListener((ControlListener)new DragControl(false));
        this.addControlListener((ControlListener)new FocusControl(0));
        this.addControlListener((ControlListener)new MouseOverControl());
        this.addControlListener((ControlListener)new PanControl(false));
        this.addControlListener((ControlListener)new ZoomControl(false));
        this.pan(350.0, 350.0);
    }

    public DBDemo(Graph g, ForceSimulator fsim) {
        this(g, fsim, "label");
    }

    public DBDemo(Graph g, ForceSimulator fsim, String textField) {
        this.m_fsim = fsim;
        this.m_textField = textField;
        this.m_registry = new ItemRegistry(g);
        this.setItemRegistry(this.m_registry);
        this.initRenderers();
        this.m_actionList = this.initActionList();
        this.setSize(900, 900);
        this.pan(350.0, 350.0);
        this.addControlListener((ControlListener)new NeighborHighlightControl());
        this.addControlListener((ControlListener)new DragControl(false));
        this.addControlListener((ControlListener)new FocusControl(0));
        this.addControlListener((ControlListener)new MouseOverControl());
        this.addControlListener((ControlListener)new PanControl(false));
        this.addControlListener((ControlListener)new ZoomControl(false));
    }

    public void runDemoApp() {
        this.fpanel = new ForcePanel(this.m_fsim);
        this.frame = new JFrame("Force Simulator Demo");
        Container c = this.frame.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)((Object)this), "Center");
        c.add((Component)this.fpanel, "East");
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Dimension d = DBDemo.this.frame.getSize();
                Dimension p = DBDemo.this.fpanel.getSize();
                Insets in = DBDemo.this.frame.getInsets();
                DBDemo.this.setSize(d.width - in.left - in.right - p.width, d.height - in.top - in.bottom);
            }
        });
        this.frame.pack();
        this.frame.setVisible(true);
        this.m_actionList.runNow();
    }

    public void runDemo() {
        this.fpanel = new ForcePanel(this.m_fsim);
        this.add((Component)this.fpanel, "West");
        this.m_actionList.runNow();
    }

    private DefaultRendererFactory initRenderers(boolean returnVal) {
        try {
            int i;
            System.out.println("  ********InitRenderer**********");
            TableNodeRenderer nodeRenderer = new TableNodeRenderer();
            nodeRenderer.logState("Table Node rendered");
            nodeRenderer.setRenderType(2);
            nodeRenderer.setRoundedCorner(8, 8);
            Font mfont = new Font("SansSerif", 1, 12);
            nodeRenderer.setTextAttributeName(this.m_textField);
            nodeRenderer.addTextAttribute(this.m_textField, 3, mfont);
            int noOfEntries = 35;
            for (i = 1; i < noOfEntries + 1; ++i) {
                nodeRenderer.addTextAttribute("column" + i, 3);
            }
            for (i = 1; i < noOfEntries + 1; ++i) {
                nodeRenderer.addTextAttribute("type" + i, 3);
            }
            nodeRenderer.addTextAttribute("pkey", 3);
            nodeRenderer.addTextAttribute("fkey", 3);
            System.out.println("Init Rendered: About to return renderers");
            DefaultEdgeRenderer edgeRenderer = new DefaultEdgeRenderer();
            return new DefaultRendererFactory((Renderer)nodeRenderer, (Renderer)edgeRenderer, null);
        }
        catch (Exception e) {
            MraldOutFile.logToFile(e);
            System.out.println("Exception : INit Renderers: " + e.getMessage());
            return null;
        }
    }

    private void initRenderers() {
        try {
            int i;
            System.out.println("  ********InitRenderer**********");
            TableNodeRenderer nodeRenderer = new TableNodeRenderer();
            nodeRenderer.logState("Table Node rendered");
            nodeRenderer.setRenderType(2);
            nodeRenderer.setRoundedCorner(8, 8);
            Font mfont = new Font("SansSerif", 1, 12);
            nodeRenderer.setTextAttributeName(this.m_textField);
            nodeRenderer.addTextAttribute(this.m_textField, 3, mfont);
            int noOfEntries = 35;
            for (i = 1; i < noOfEntries + 1; ++i) {
                nodeRenderer.addTextAttribute("column" + i, 3);
            }
            for (i = 1; i < noOfEntries + 1; ++i) {
                nodeRenderer.addTextAttribute("type" + i, 3);
            }
            nodeRenderer.addTextAttribute("pkey", 3);
            nodeRenderer.addTextAttribute("fkey", 3);
            System.out.println("Init Rendered: About to set renderers");
            DefaultEdgeRenderer edgeRenderer = new DefaultEdgeRenderer();
            this.m_registry.setRendererFactory((RendererFactory)new DefaultRendererFactory((Renderer)nodeRenderer, (Renderer)edgeRenderer, null));
            System.out.println("Init Rendered: Set renderers successfully");
        }
        catch (Exception e) {
            MraldOutFile.logToFile(e);
            System.out.println("Exception : INit Renderers: " + e.getMessage());
        }
    }

    private ActionList initActionList() {
        ActionList actionList = new ActionList(this.m_registry, -1L, 20L);
        actionList.add((Action)new GraphFilter());
        actionList.add((Action)new ForceDirectedLayout(this.m_fsim, false, false));
        actionList.add((Action)new DemoColorFunction());
        actionList.add((Action)new RepaintAction());
        actionList.add((Action)new FreezeAction());
        return actionList;
    }

    public void runNow(URL inputUrl) {
        Graph g;
        try {
            g = new DBGraphReader().loadGraph(inputUrl);
            ForceSimulator fsim = new ForceSimulator();
            fsim.addForce((Force)new NBodyForce(-0.4f, -1.0f, 0.9f));
            fsim.addForce((Force)new SpringForce(4.0E-6f, 75.0f));
            fsim.addForce((Force)new DragForce(-0.005f));
            this.m_fsim = fsim;
            this.fpanel = new ForcePanel(this.m_fsim);
            this.setLayout(new BorderLayout());
            this.m_registry = new ItemRegistry(g);
            this.setItemRegistry(this.m_registry);
            this.m_registry.setRendererFactory((RendererFactory)this.initRenderers(true));
            this.m_actionList = this.initActionList();
            this.m_actionList.runNow();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        System.out.println("Visualizing Graph: Using URL: " + g.getNodeCount() + " nodes, " + g.getEdgeCount() + " edges");
    }

    public void runNow(String file) {
        Graph g;
        ForceSimulator fsim = new ForceSimulator();
        fsim.addForce((Force)new NBodyForce(-0.4f, -1.0f, 0.9f));
        fsim.addForce((Force)new SpringForce(4.0E-6f, 75.0f));
        fsim.addForce((Force)new DragForce(-0.005f));
        this.m_fsim = fsim;
        try {
            g = new DBGraphReader().loadGraph(file);
            this.m_registry = new ItemRegistry(g);
            this.setItemRegistry(this.m_registry);
            this.initRenderers();
            this.m_actionList = this.initActionList();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        System.out.println("Visualizing Graph: using file: " + g.getNodeCount() + " nodes, " + g.getEdgeCount() + " edges");
        this.runDemoApp();
    }

    public void cancel() {
    }

    public void freezeAll() {
    }

    public static void main(String[] argv) {
        Graph g;
        String file = null;
        if (argv != null && argv.length == 2) {
            file = argv[1];
        }
        System.out.println("NO OF ARGS : " + argv.length);
        try {
            g = file != null ? new DBGraphReader().loadGraph(file) : new DBGraphReader().loadGraph();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        System.out.println("Visualizing Graph in Main: " + g.getNodeCount() + " nodes, " + g.getEdgeCount() + " edges");
        ForceSimulator fsim = new ForceSimulator();
        fsim.addForce((Force)new NBodyForce(-0.4f, -1.0f, 0.9f));
        fsim.addForce((Force)new SpringForce(4.0E-8f, 75.0f));
        fsim.addForce((Force)new DragForce(-0.005f));
        DBDemo fdemo = new DBDemo(g, fsim);
        fdemo.runDemoApp();
    }

    public class MouseOverControl
    extends ControlAdapter {
        public void itemEntered(VisualItem item, MouseEvent e) {
            ((Display)e.getSource()).setCursor(Cursor.getPredefinedCursor(12));
            item.setFixed(true);
        }

        public void itemExited(VisualItem item, MouseEvent e) {
            ((Display)e.getSource()).setCursor(Cursor.getDefaultCursor());
            item.setFixed(false);
        }

        public void itemReleased(VisualItem item, MouseEvent e) {
            item.setFixed(false);
        }
    }

    public class DemoColorFunction
    extends ColorFunction {
        private Color pastelRed = new Color(255, 125, 125);
        private Color pastelOrange = new Color(255, 200, 125);
        private Color lightGray = new Color(220, 220, 255);

        public Paint getColor(VisualItem item) {
            if (item instanceof EdgeItem) {
                if (item.isHighlighted()) {
                    return this.pastelOrange;
                }
                return Color.LIGHT_GRAY;
            }
            return Color.BLACK;
        }

        public Paint getFillColor(VisualItem item) {
            if (item.isHighlighted()) {
                return this.pastelOrange;
            }
            if (item instanceof NodeItem) {
                if (item.isFixed()) {
                    return this.pastelRed;
                }
                return this.lightGray;
            }
            return Color.BLACK;
        }
    }
}

