/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.graphics;

import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.render.DefaultRendererFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.mitre.mrald.graphics.MraldPanel;
import org.mitre.mrald.graphics.MraldVisual;
import org.mitre.mrald.graphics.TableNodeRenderer;
import org.mitre.mrald.util.MraldException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MraldDBPanel
extends MraldPanel
implements MraldVisual {
    public MraldDBPanel(HashMap<String, Object> initialVals) throws MraldException {
        super(initialVals);
    }

    private Box setLegend() throws MraldException {
        try {
            String[] legend = new String[]{"Primary Key ", "Foreign Key"};
            String[] pictures = new String[]{"pkey.png", "fkey.png"};
            Box imageBox = new Box(1);
            this.setLayout(new BoxLayout(this, 0));
            Color boxColor = Color.WHITE;
            if (this.hasAttribute("BoxColor")) {
                boxColor = (Color)this.getAttribute("BoxColor");
            }
            imageBox.setBackground(boxColor);
            URL imageURL = null;
            System.out.println("Set Legend : Base URL: " + this.getAttribute("baseURL"));
            for (int i = 0; i < legend.length; ++i) {
                if (this.hasAttribute("baseURL")) {
                    imageURL = new URL(this.getAttribute("baseURL") + "/graphics/" + pictures[i]);
                }
                ImageIcon keyImage = new ImageIcon(imageURL);
                JLabel label = new JLabel(legend[i], keyImage, 2);
                label.setPreferredSize(new Dimension(200, 20));
                label.setMaximumSize(new Dimension(200, 20));
                imageBox.add(label);
            }
            imageBox.add(Box.createHorizontalStrut(10));
            imageBox.add(Box.createHorizontalGlue());
            imageBox.setBorder(BorderFactory.createTitledBorder("Legend"));
            return imageBox;
        }
        catch (Exception e) {
            throw new MraldException(e.getMessage());
        }
    }

    @Override
    protected void initUI() throws MraldException {
        this.setAttribute("showDetails", new ShowDetails());
        super.initUI();
        Box imageBox = this.setLegend();
        this.addToTabPanel(1, imageBox);
    }

    private JButton getDetailButton() throws MraldException {
        JButton but = new JButton("Show Table");
        but.putClientProperty("registry", this.getAttribute("registry"));
        but.addActionListener((ShowDetails)this.getAttribute("showDetails"));
        return but;
    }

    @Override
    protected Box getToolsBox() throws MraldException {
        Box a = super.getToolsBox();
        JButton detailButton = this.getDetailButton();
        a.add(detailButton);
        return a;
    }

    private class ShowDetails
    extends AbstractAction {
        private ShowDetails() {
        }

        public void actionPerformed(ActionEvent arg0) {
            JButton but = (JButton)arg0.getSource();
            ItemRegistry registry = (ItemRegistry)but.getClientProperty("registry");
            if (registry != null) {
                TableNodeRenderer rend;
                rend.setTableOnly(!(rend = (TableNodeRenderer)((DefaultRendererFactory)registry.getRendererFactory()).getNodeRenderer()).getTableOnly());
                if (!rend.getTableOnly()) {
                    but.setText("Show Table");
                } else {
                    but.setText("Show Details");
                }
            } else {
                System.out.println("Could not find property registry");
            }
        }
    }
}

