/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.graphics;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import org.mitre.mrald.graphics.ColorPatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MraldPalette
extends JPanel
implements PropertyChangeListener {
    private Color backgroundCol = null;
    private HashMap<String, Color> backupSetColors = new HashMap();

    public MraldPalette(Color background, int columns, int rows, HashMap<String, Color> setColors) {
        this(columns, rows, setColors);
        this.setBackground(background);
        this.backgroundCol = background;
    }

    public void setBackgroundCol(HashMap setColors) {
        Iterator cols = setColors.keySet().iterator();
        while (cols.hasNext()) {
            String label = cols.next().toString();
            if (label.equals("Background_color")) {
                this.backgroundCol = (Color)setColors.get(label);
            }
            if (this.backgroundCol == null) continue;
            this.setBackground(this.backgroundCol);
        }
    }

    public MraldPalette(int columns, int rows, HashMap<String, Color> setColors) {
        this.backupSetColors = new HashMap<String, Color>(setColors);
        Iterator<String> cols = setColors.keySet().iterator();
        this.setBorder(BorderFactory.createTitledBorder("Color Palette"));
        Box v = new Box(0);
        v.add(Box.createHorizontalGlue());
        while (cols.hasNext()) {
            String label = cols.next().toString();
            ColorPatch colPatch = new ColorPatch(this, setColors.get(label), label);
            if (this.backgroundCol != null) {
                colPatch.setBackground(this.backgroundCol);
            }
            v.add(colPatch);
        }
        this.add(v);
    }

    public void setColor(String type, Color color) {
        Color oldColor = this.backupSetColors.get(type);
        this.backupSetColors.put(type, color);
        this.firePropertyChange(type, oldColor, color);
    }

    public Color getColor(String type) {
        return this.backupSetColors.get(type);
    }

    public void stateChanged(ChangeEvent e) {
        System.out.println("State Changed");
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        System.out.println("test");
    }
}

