/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.graphics;

import edu.berkeley.guir.prefuse.EdgeItem;
import edu.berkeley.guir.prefuse.FocusManager;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.event.FocusEvent;
import edu.berkeley.guir.prefuse.event.FocusEventMulticaster;
import edu.berkeley.guir.prefuse.event.FocusListener;
import edu.berkeley.guir.prefuse.focus.DefaultFocusSet;
import edu.berkeley.guir.prefuse.focus.FocusSet;
import edu.berkeley.guir.prefuse.graph.Entity;
import edu.berkeley.guir.prefuse.graph.Node;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.mitre.mrald.graphics.MraldVisual;
import org.mitre.mrald.util.MraldException;

class SearchPanel
extends JPanel
implements FocusListener,
MraldVisual {
    private Color backgroundCol = null;
    private ArrayList<VisualItem> findSet = new ArrayList();
    private ItemRegistry registry = null;
    private FocusListener listener = null;
    private HashMap<String, Object> attributeValues = new HashMap();
    private JTextField queryText;

    public SearchPanel(Color background, ItemRegistry registry) throws MraldException {
        this(registry);
        this.setBackground(background);
        this.backgroundCol = background;
    }

    public SearchPanel(ItemRegistry thisRegistry) throws MraldException {
        this.registry = thisRegistry;
        this.init();
        this.initUI();
    }

    private void init() {
        this.registry.getDefaultFocusSet().addFocusListener((FocusListener)this);
    }

    private void initUI() throws MraldException {
        Box b = new Box(0);
        b.setBackground(this.backgroundCol);
        this.setLayout(new BoxLayout(this, 0));
        b.add(Box.createHorizontalStrut(5));
        this.queryText = new JTextField(15);
        this.queryText.setPreferredSize(new Dimension(200, 20));
        this.queryText.setMaximumSize(new Dimension(200, 20));
        this.queryText.addActionListener(new SearchKeyword());
        b.putClientProperty("searchText", this.queryText);
        b.add(this.queryText);
        b.setBorder(BorderFactory.createTitledBorder("Search"));
        this.add(b);
    }

    public void search(String query) {
        FocusManager focusManager = this.registry.getFocusManager();
        Iterator iter = this.registry.getItems();
        while (iter.hasNext()) {
            VisualItem itemCheck = (VisualItem)iter.next();
            if (itemCheck.getAttribute("label") == null || !itemCheck.getAttribute("label").equals(query)) continue;
            this.findSet.add(itemCheck);
        }
        int cnt = this.findSet.size();
        Entity[] add = new Entity[cnt];
        for (int i = 0; i < this.findSet.size(); ++i) {
            add[i] = (Entity)this.findSet.get(i);
        }
        Entity[] rem = this.findSet.toArray(FocusEvent.EMPTY);
        FocusEvent fe = new FocusEvent(focusManager.getDefaultFocusSet(), 2, add, rem);
        this.changeFocus(fe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeFocus(FocusEvent e) {
        if (e.getEventType() == 2) {
            FocusEvent fe = e;
            Entity[] focusItems = fe.getAddedFoci();
            FocusManager focusManager = this.registry.getFocusManager();
            DefaultFocusSet searchItems = new DefaultFocusSet();
            searchItems.add(this.findSet);
            focusManager.putFocusSet((Object)"default", (FocusSet)searchItems);
            ItemRegistry itemRegistry = this.registry;
            synchronized (itemRegistry) {
                FocusManager fm = this.registry.getFocusManager();
                FocusSet fs = fm.getFocusSet((Object)"default");
                for (int i = 0; i < this.findSet.size(); ++i) {
                    VisualItem checkItem = this.findSet.get(i);
                    fs.set(checkItem.getEntity());
                    this.registry.touch(checkItem.getItemClass());
                    NodeItem n = (NodeItem)focusItems[i];
                    n.setHighlighted(true);
                    Iterator iter = n.getEdges();
                    while (iter.hasNext()) {
                        EdgeItem eitem = (EdgeItem)iter.next();
                        NodeItem nitem = (NodeItem)eitem.getAdjacentNode((Node)n);
                        if (!eitem.isVisible()) continue;
                        eitem.setHighlighted(true);
                        this.registry.touch(eitem.getItemClass());
                        nitem.setHighlighted(true);
                        this.registry.touch(nitem.getItemClass());
                    }
                }
            }
        }
    }

    public void addFocusListener(FocusListener fl) {
        this.listener = FocusEventMulticaster.add((FocusListener)this.listener, (FocusListener)fl);
    }

    public void setAttribute(String keyName, Object value) throws MraldException {
        this.attributeValues.put(keyName, value);
    }

    public Object getAttribute(String keyName) throws MraldException {
        return this.attributeValues.get(keyName);
    }

    public boolean hasAttribute(String keyName) throws MraldException {
        return this.attributeValues.containsKey(keyName);
    }

    public void focusChanged(FocusEvent arg0) {
    }

    private class SearchKeyword
    extends AbstractAction {
        private SearchKeyword() {
        }

        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getSource() instanceof JButton) {
                String searchTxt = SearchPanel.this.queryText.getText();
                SearchPanel.this.search(searchTxt);
            } else if (arg0.getSource() instanceof JTextField) {
                JTextField searchText = (JTextField)arg0.getSource();
                String searchTxt = searchText.getText();
                SearchPanel.this.search(searchTxt);
            }
        }
    }
}

