/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.graphics;

import edu.berkeley.guir.prefuse.AggregateItem;
import edu.berkeley.guir.prefuse.Display;
import edu.berkeley.guir.prefuse.EdgeItem;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.action.Action;
import edu.berkeley.guir.prefuse.action.RepaintAction;
import edu.berkeley.guir.prefuse.action.assignment.ColorFunction;
import edu.berkeley.guir.prefuse.action.filter.TreeFilter;
import edu.berkeley.guir.prefuse.activity.ActionList;
import edu.berkeley.guir.prefuse.activity.Activity;
import edu.berkeley.guir.prefuse.event.ControlListener;
import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.render.DefaultEdgeRenderer;
import edu.berkeley.guir.prefuse.render.DefaultRendererFactory;
import edu.berkeley.guir.prefuse.render.MultiLineTextItemRenderer;
import edu.berkeley.guir.prefuse.render.Renderer;
import edu.berkeley.guir.prefuse.render.RendererFactory;
import edu.berkeley.guir.prefuse.util.ColorLib;
import edu.berkeley.guir.prefusex.controls.DragControl;
import edu.berkeley.guir.prefusex.controls.FocusControl;
import edu.berkeley.guir.prefusex.controls.NeighborHighlightControl;
import edu.berkeley.guir.prefusex.controls.PanControl;
import edu.berkeley.guir.prefusex.controls.ZoomControl;
import edu.berkeley.guir.prefusex.layout.VerticalTreeLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Paint;
import javax.swing.JFrame;
import org.mitre.mrald.graphics.DBGraphReader;
import org.mitre.mrald.util.MraldOutFile;

public class ShowDBDemo
extends JFrame {
    private ItemRegistry registry;
    private ActionList actions;
    private Graph graph;
    public static final String GRAPH_LATTICE = "etc/lattice.xml";
    private ActionList layout;
    private ActionList update;

    public ShowDBDemo() {
        super("ShowGraph");
        try {
            String inputFile = GRAPH_LATTICE;
            this.graph = new DBGraphReader().loadGraph(inputFile);
            this.registry = new ItemRegistry(this.graph);
            this.initRenderers();
            Display display = new Display(this.registry);
            display.setSize(800, 800);
            display.addControlListener((ControlListener)new DragControl());
            display.addControlListener((ControlListener)new FocusControl());
            this.update = new ActionList(this.registry);
            this.update.add((Action)new DemoColorFunction(3));
            this.update.add((Action)new RepaintAction());
            display.addControlListener((ControlListener)new NeighborHighlightControl((Activity)this.update));
            display.addControlListener((ControlListener)new PanControl(false));
            display.addControlListener((ControlListener)new ZoomControl(false));
            display.setBackground(Color.LIGHT_GRAY);
            this.layout = new ActionList(this.registry);
            this.layout.add((Action)new VerticalTreeLayout());
            this.layout.add((Action)new DemoColorFunction(3));
            this.layout.add((Action)new RepaintAction());
            this.actions = new ActionList(this.registry);
            this.actions.add((Action)new TreeFilter());
            this.actions.add((Action)new DemoColorFunction(3));
            this.actions.add((Action)new RepaintAction());
            this.setDefaultCloseOperation(3);
            this.getContentPane().add((Component)display);
            this.pack();
            this.setVisible(true);
            this.actions.runNow();
            this.layout.runNow();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initRenderers() {
        try {
            MultiLineTextItemRenderer nodeRenderer = new MultiLineTextItemRenderer();
            nodeRenderer.setRenderType(2);
            nodeRenderer.setRoundedCorner(8, 8);
            nodeRenderer.addTextAttribute("label", 3);
            nodeRenderer.addTextAttribute("column1", 3);
            nodeRenderer.addTextAttribute("column2", 3);
            nodeRenderer.addTextAttribute("column3", 3);
            nodeRenderer.addTextAttribute("column4", 3);
            nodeRenderer.addTextAttribute("column5", 3);
            nodeRenderer.addTextAttribute("column6", 3);
            nodeRenderer.addTextAttribute("column7", 3);
            nodeRenderer.addTextAttribute("column8", 3);
            nodeRenderer.addTextAttribute("column9", 3);
            nodeRenderer.addTextAttribute("column10", 3);
            nodeRenderer.addTextAttribute("column11", 3);
            nodeRenderer.addTextAttribute("column12", 3);
            nodeRenderer.addTextAttribute("column13", 3);
            nodeRenderer.addTextAttribute("column14", 3);
            nodeRenderer.addTextAttribute("column15", 3);
            DefaultEdgeRenderer edgeRenderer = new DefaultEdgeRenderer(){

                protected int getLineWidth(VisualItem item) {
                    String w = item.getAttribute("weight");
                    if (w != null) {
                        try {
                            return Integer.parseInt(w);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return this.m_width;
                }
            };
            this.registry.setRendererFactory((RendererFactory)new DefaultRendererFactory((Renderer)nodeRenderer, (Renderer)edgeRenderer, null));
        }
        catch (Exception e) {
            MraldOutFile.logToFile(e);
        }
    }

    public static void main(String[] args) {
        new ShowDBDemo();
    }

    public class DemoColorFunction
    extends ColorFunction {
        private Color graphEdgeColor = Color.DARK_GRAY;
        private Color[] nodeColors;
        private Color[] edgeColors;

        public DemoColorFunction(int thresh) {
            this.nodeColors = new Color[thresh];
            this.edgeColors = new Color[thresh];
            for (int i = 0; i < thresh; ++i) {
                double frac = (double)i / (double)thresh;
                this.nodeColors[i] = ColorLib.getIntermediateColor((Color)Color.RED, (Color)Color.BLACK, (double)frac);
                this.edgeColors[i] = ColorLib.getIntermediateColor((Color)Color.RED, (Color)Color.BLACK, (double)frac);
            }
        }

        public Paint getFillColor(VisualItem item) {
            if (item instanceof NodeItem) {
                Color nodeEndCol = Color.cyan;
                Color nodeStartCol = new Color(255, 153, 0);
                int b = 600;
                GradientPaint nodeCol = new GradientPaint(2.0f, 2.0f, nodeStartCol, b - 2, b - 2, nodeEndCol);
                return nodeCol;
            }
            if (item instanceof AggregateItem) {
                return Color.LIGHT_GRAY;
            }
            if (item instanceof EdgeItem) {
                return this.getColor(item);
            }
            return Color.BLACK;
        }

        public Paint getColor(VisualItem item) {
            if (item.isHighlighted()) {
                Color nodeStartCol = new Color(204, 204, 255);
                return nodeStartCol;
            }
            if (item instanceof NodeItem) {
                int d = ((NodeItem)item).getDepth();
                return this.nodeColors[Math.min(d, this.nodeColors.length - 1)];
            }
            if (item instanceof EdgeItem) {
                EdgeItem e = (EdgeItem)item;
                if (e.isTreeEdge()) {
                    int d1 = ((NodeItem)e.getFirstNode()).getDepth();
                    int d2 = ((NodeItem)e.getSecondNode()).getDepth();
                    int d = Math.max(d1, d2);
                    return this.edgeColors[Math.min(d, this.edgeColors.length - 1)];
                }
                return this.graphEdgeColor;
            }
            return Color.BLACK;
        }
    }
}

