/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.graphics;

import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.render.ImageFactory;
import edu.berkeley.guir.prefuse.render.TextItemRenderer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class TableNodeRenderer
extends TextItemRenderer {
    public static final int DEFAULT_MAXLINES = 3;
    protected AffineTransform m_transform = new AffineTransform();
    protected ImageFactory m_images = new ImageFactory();
    protected String m_imageName = "image";
    private URL codeBaseUrl = null;
    protected RectangularShape m_imageBox = new Rectangle2D.Float();
    protected int noOfLines = 0;
    private boolean tableOnly = false;
    protected ArrayList<TextEntry> m_attrList = new ArrayList();

    public TableNodeRenderer(URL baseUrl) {
        this.setCodeBaseUrl(baseUrl);
        this.init();
    }

    public TableNodeRenderer() {
        this.init();
    }

    private void init() {
        try {
            URL imageURL = new URL("http://127.0.0.1:8080/graphics/pkey.png");
            System.out.println("TableNodeRenderer: baseURl :" + this.codeBaseUrl);
            if (this.codeBaseUrl != null) {
                imageURL = new URL(this.codeBaseUrl + "/pkey.png");
            }
            Image pkImage = Toolkit.getDefaultToolkit().createImage(imageURL);
            imageURL = new URL("http://127.0.0.1:8080/graphics/fkey.png");
            if (this.codeBaseUrl != null) {
                imageURL = new URL(this.codeBaseUrl + "/fkey.png");
            }
            Image fkImage = Toolkit.getDefaultToolkit().createImage(imageURL);
            this.m_images.addImage("pkey", pkImage);
            this.m_images.addImage("fkey", fkImage);
        }
        catch (MalformedURLException me) {
            try {
                URL imageURL = new URL("http://127.0.0.1:8080/graphics/pkey.png");
                Image pkImage = Toolkit.getDefaultToolkit().createImage(imageURL);
                imageURL = new URL("http://127.0.0.1:8080/graphics/fkey.png");
                Image fkImage = Toolkit.getDefaultToolkit().createImage(imageURL);
                this.m_images.addImage("pkey", pkImage);
                this.m_images.addImage("fkey", fkImage);
            }
            catch (MalformedURLException te) {
                System.out.println("TableNodeRenderer : MalformedURL: " + te.getMessage());
            }
        }
    }

    public void logState(String mess) {
    }

    public void setTableOnly(boolean tableOnly) {
        this.tableOnly = tableOnly;
    }

    public boolean getTableOnly() {
        return this.tableOnly;
    }

    public void setCodeBaseUrl(URL codeBaseUrl) {
        this.codeBaseUrl = codeBaseUrl;
    }

    public void addTextAttribute(String attrName) {
        this.addTextAttribute(attrName, 3, null);
    }

    public void addTextAttribute(String attrName, int maxlines) {
        this.m_attrList.add(new TextEntry(attrName, maxlines, null));
    }

    public void addTextAttribute(String attrName, int maxlines, Font font) {
        this.m_attrList.add(new TextEntry(attrName, maxlines, font));
    }

    protected String getText(VisualItem item) {
        throw new UnsupportedOperationException();
    }

    protected String getText(VisualItem item, int entry) {
        String name = this.m_attrList.get((int)entry).name;
        return item.getAttribute(name);
    }

    public int getNumEntries() {
        return this.m_attrList.size();
    }

    public int getNumLines() {
        return this.noOfLines;
    }

    private void setNumLines(int noOfLines) {
        this.noOfLines = noOfLines;
    }

    protected int getMaxLines(int entry) {
        return this.m_attrList.get((int)entry).maxlines;
    }

    protected Shape getRawShape(VisualItem item) {
        int widthFactor = 1;
        int w = this.m_horizBorder * widthFactor;
        int h = 2 * this.m_vertBorder;
        for (int i = 0; i < this.getNumLines(); ++i) {
            Font font = this.getFont(item, i);
            FontMetrics fm = DEFAULT_GRAPHICS.getFontMetrics(font);
            String text = this.getText(item, i);
            if (text != null) {
                h += fm.getHeight();
                w = Math.max(w, (fm.stringWidth(text) + 2 * this.m_horizBorder) * widthFactor);
            }
            widthFactor = 2;
        }
        TableNodeRenderer.getAlignedPoint((Point2D)this.m_tmpPoint, (VisualItem)item, (double)w, (double)h, (int)this.m_xAlign, (int)this.m_yAlign);
        this.m_textBox.setFrame(this.m_tmpPoint.getX(), this.m_tmpPoint.getY(), w, h);
        return this.m_textBox;
    }

    protected Font getFont(VisualItem item, int entry) {
        Font f = this.m_attrList.get((int)entry).font;
        if (f == null) {
            f = item.getFont();
        }
        if (f == null) {
            f = this.m_font;
        }
        return f;
    }

    public Rectangle getEntryBounds(VisualItem item, int entry) {
        int widthFactor = 2;
        int dy = this.m_vertBorder;
        int ew = 0;
        int eh = 0;
        int w = widthFactor * this.m_horizBorder;
        int h = 2 * this.m_vertBorder;
        for (int i = 0; i <= entry; ++i) {
            Font font = this.getFont(item, i);
            FontMetrics fm = DEFAULT_GRAPHICS.getFontMetrics(font);
            String text = this.getText(item, i);
            if (text == null) continue;
            h += fm.getHeight();
            w = Math.max(w, fm.stringWidth(text) + widthFactor * this.m_horizBorder);
            if (i < entry) {
                dy += fm.getHeight();
                continue;
            }
            if (i != entry) continue;
            ew = fm.stringWidth(text) + widthFactor * this.m_horizBorder;
            eh = fm.getHeight();
        }
        TableNodeRenderer.getAlignedPoint((Point2D)this.m_tmpPoint, (VisualItem)item, (double)w, (double)h, (int)this.m_xAlign, (int)this.m_yAlign);
        this.m_textBox.setFrame(this.m_tmpPoint.getX(), this.m_tmpPoint.getY() + (double)dy, ew, eh);
        return this.m_textBox.getBounds();
    }

    public void render(Graphics2D g, VisualItem item) {
        try {
            int lineNo = 0;
            if (this.tableOnly) {
                lineNo = 1;
            } else {
                for (int i = 0; i < this.getNumEntries(); ++i) {
                    String name = this.m_attrList.get((int)i).name;
                    if (name.startsWith("pkey") || name.startsWith("fkey") || name.startsWith("type")) continue;
                    ++lineNo;
                }
            }
            this.setNumLines(lineNo);
            Paint fillColor = item.getFillColor();
            Paint itemColor = item.getColor();
            Shape shape = this.getShape(item);
            if (shape != null) {
                switch (this.getRenderType(item)) {
                    case 1: {
                        g.setPaint(itemColor);
                        g.draw(shape);
                        break;
                    }
                    case 2: {
                        g.setPaint(fillColor);
                        g.fill(shape);
                        break;
                    }
                    case 3: {
                        g.setPaint(fillColor);
                        g.fill(shape);
                        g.setPaint(itemColor);
                        g.draw(shape);
                    }
                }
            }
            Rectangle r = shape.getBounds();
            int h = r.y + this.m_vertBorder;
            ArrayList<String> pkeyCols = new ArrayList<String>();
            int pKeyCount = 1;
            String pkeyLabel = "pkey1";
            while (item.getAttribute(pkeyLabel) != null) {
                pkeyLabel = "pkey" + pKeyCount;
                pkeyCols.add(item.getAttribute(pkeyLabel));
                ++pKeyCount;
            }
            ArrayList<String> fkeyCols = new ArrayList<String>();
            int fKeyCount = 1;
            String fkeyLabel = "fkey1";
            while (item.getAttribute(fkeyLabel) != null) {
                fkeyLabel = "fkey" + fKeyCount;
                fkeyCols.add(item.getAttribute(fkeyLabel));
                ++fKeyCount;
            }
            lineNo = 0;
            for (int i = 0; i < this.getNumEntries(); ++i) {
                int xPos = r.x + this.m_horizBorder;
                Font font = this.getFont(item, i);
                FontMetrics fm = DEFAULT_GRAPHICS.getFontMetrics(font);
                String name = this.m_attrList.get((int)i).name;
                if (this.tableOnly) {
                    if (!name.equals(this.m_labelName)) continue;
                    String text = this.getText(item, i);
                    if (text == null) {
                        i = this.getNumEntries();
                        continue;
                    }
                    if (text == null) continue;
                    Color overlay = (Color)item.getVizAttribute("overlay_" + lineNo);
                    if (overlay != null) {
                        g.setColor(overlay);
                        Rectangle or = new Rectangle(r.x + this.m_horizBorder, h, fm.stringWidth(text), fm.getHeight());
                        g.fill(or);
                    }
                    g.setPaint(itemColor);
                    g.setFont(font);
                    g.drawString(text, xPos, h + fm.getAscent());
                    continue;
                }
                if (name.startsWith("pkey") || name.startsWith("fkey") || name.startsWith("type")) continue;
                int typeNo = i;
                String colType = item.getAttribute("type" + typeNo);
                ++lineNo;
                String text = this.getText(item, i);
                if (text == null) {
                    i = this.getNumEntries();
                    continue;
                }
                int push = 0;
                if (!name.equals(this.m_labelName)) {
                    int offset = 0;
                    if (pkeyCols.contains(text)) {
                        push = this.drawImage(g, r, item, h, "pkey", offset);
                        xPos += push;
                        offset = push;
                        r = new Rectangle(r.x, r.y, new Double(r.getWidth()).intValue() + push, new Double(r.getHeight()).intValue());
                    }
                    if (fkeyCols.contains(text)) {
                        push = this.drawImage(g, r, item, h, "fkey", offset);
                        xPos += push;
                        r = new Rectangle(r.x, r.y, new Double(r.getWidth()).intValue() + push, new Double(r.getHeight()).intValue());
                    }
                    text = text + " : " + colType;
                }
                if (text == null) continue;
                Color overlay = (Color)item.getVizAttribute("overlay_" + lineNo);
                if (overlay != null) {
                    g.setColor(overlay);
                    Rectangle or = new Rectangle(r.x + this.m_horizBorder, h, fm.stringWidth(text) + push, fm.getHeight());
                    g.fill(or);
                }
                g.setPaint(itemColor);
                g.setFont(font);
                g.drawString(text, xPos, h + fm.getAscent());
                h += fm.getHeight();
            }
        }
        catch (Exception e) {
            this.logState("Exception :" + e.getMessage());
        }
    }

    private int drawImage(Graphics2D g, Rectangle r, VisualItem item, int h, String type, int offset) {
        Image img = this.getImage(item, type);
        Paint fillColor = item.getFillColor();
        if (img != null) {
            int alpha;
            Composite comp = g.getComposite();
            if (fillColor instanceof Color && (alpha = ((Color)fillColor).getAlpha()) < 255) {
                AlphaComposite alphaComp = AlphaComposite.getInstance(10, (float)alpha / 255.0f);
                g.setComposite(alphaComp);
            }
            Font font = this.getFont(item, 0);
            FontMetrics fm = DEFAULT_GRAPHICS.getFontMetrics(font);
            g.drawImage(img, r.x + offset + this.m_horizBorder, h - fm.getAscent() / 2, null);
            double size = r.x;
            double is = 1.0;
            double h2 = is * (double)img.getHeight(null);
            double y = r.getMinY() + (r.getHeight() - h2) / 2.0;
            double x2 = r.getMinX() + size * (double)this.m_horizBorder;
            this.m_transform.setTransform(is, 0.0, 0.0, is, x2, y);
            g.setComposite(comp);
            return img.getWidth(null);
        }
        return 0;
    }

    protected String getImageLocation(VisualItem item) {
        return "pkey";
    }

    protected Image getImage(VisualItem item, String type) {
        Image rtnImage = null;
        rtnImage = this.m_images.getImage(type);
        return rtnImage;
    }

    protected class TextEntry {
        String name;
        int maxlines;
        Font font;

        public TextEntry(String n, int m, Font f) {
            this.name = n;
            this.maxlines = m;
            this.font = f;
        }
    }
}

