/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.join;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.mitre.mrald.join.Source;

public abstract class Join {
    public final Source outerSource;
    public final Source innerSource;
    public final int[] outerCols;
    public final int[] innerCols;
    protected ResultSet outerRS;
    protected ResultSet innerRS;
    private ResultSet lastRS;

    public Join(Source outerSource, Source innerSource, int[] outerCols, int[] innerCols) throws SQLException {
        this.outerSource = outerSource;
        this.innerSource = innerSource;
        this.outerCols = outerCols;
        this.innerCols = innerCols;
        if (outerCols.length != innerCols.length) {
            throw new SQLException("Column mismatch.");
        }
    }

    public abstract ResultSet execute() throws SQLException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class JoinResultSet
    implements ResultSet,
    ResultSetMetaData {
        protected int rowNum = -1;
        protected int first = 0;
        public static final int BEFORE_FIRST = 0;
        public static final int FIRST = 1;
        public static final int AFTER_FIRST = 2;
        private ResultSetMetaData outerMetaData;
        private ResultSetMetaData innerMetaData;

        public JoinResultSet(ResultSetMetaData outer, ResultSetMetaData inner) throws SQLException {
            this.outerMetaData = outer == null ? Join.this.outerRS.getMetaData() : outer;
            this.innerMetaData = inner == null ? Join.this.innerRS.getMetaData() : inner;
        }

        public JoinResultSet() throws SQLException {
            this(null, null);
        }

        protected boolean testCursor() throws SQLException {
            if (Join.this.outerRS.getRow() == -1 || Join.this.innerRS.getRow() == -1) {
                return false;
            }
            for (int i = 0; i < Join.this.outerCols.length; ++i) {
                if (this.testCursorAtColumn(i)) continue;
                return false;
            }
            return true;
        }

        @Override
        public final boolean next() throws SQLException {
            while (this.advanceCursor()) {
                if (!this.testCursor()) continue;
                this.first = this.first == 0 ? 1 : 2;
                ++this.rowNum;
                return true;
            }
            this.rowNum = 0;
            return false;
        }

        protected abstract boolean advanceCursor() throws SQLException;

        private boolean testCursorAtColumn(int index) throws SQLException {
            Object outer = Join.this.outerRS.getObject(Join.this.outerCols[index]);
            Object inner = Join.this.innerRS.getObject(Join.this.innerCols[index]);
            if (Join.this.outerRS.wasNull() || Join.this.innerRS.wasNull()) {
                return false;
            }
            return outer.equals(inner);
        }

        private ResultSet lookupRS(int col, boolean read) throws SQLException {
            ResultSet result;
            ResultSet resultSet = result = col <= this.outerMetaData.getColumnCount() ? Join.this.outerRS : Join.this.innerRS;
            if (read) {
                Join.this.lastRS = result;
            }
            return result;
        }

        private ResultSetMetaData lookupMD(int col) throws SQLException {
            return col <= this.outerMetaData.getColumnCount() ? this.outerMetaData : this.innerMetaData;
        }

        private int lookupCol(int col) throws SQLException {
            int outerCols = this.outerMetaData.getColumnCount();
            return col <= outerCols ? col : col - outerCols;
        }

        @Override
        public void close() throws SQLException {
            try {
                Join.this.outerSource.close();
            }
            catch (SQLException e) {
                Join.this.innerSource.close();
                throw e;
            }
        }

        @Override
        public boolean wasNull() throws SQLException {
            return Join.this.lastRS.wasNull();
        }

        @Override
        public boolean isBeforeFirst() throws SQLException {
            return this.first == 0;
        }

        @Override
        public boolean isAfterLast() throws SQLException {
            return Join.this.outerRS.isAfterLast();
        }

        @Override
        public boolean isFirst() throws SQLException {
            return this.first == 1;
        }

        @Override
        public String getString(int columnIndex) throws SQLException {
            return this.lookupRS(columnIndex, true).getString(this.lookupCol(columnIndex));
        }

        @Override
        public boolean getBoolean(int columnIndex) throws SQLException {
            return this.lookupRS(columnIndex, true).getBoolean(this.lookupCol(columnIndex));
        }

        @Override
        public byte getByte(int columnIndex) throws SQLException {
            return this.lookupRS(columnIndex, true).getByte(this.lookupCol(columnIndex));
        }

        @Override
        public short getShort(int columnIndex) throws SQLException {
            return this.lookupRS(columnIndex, true).getShort(this.lookupCol(columnIndex));
        }

        @Override
        public int getInt(int columnIndex) throws SQLException {
            return this.lookupRS(columnIndex, true).getInt(this.lookupCol(columnIndex));
        }

        @Override
        public long getLong(int columnIndex) throws SQLException {
            return this.lookupRS(columnIndex, true).getLong(this.lookupCol(columnIndex));
        }

        @Override
        public float getFloat(int columnIndex) throws SQLException {
            return this.lookupRS(columnIndex, true).getFloat(this.lookupCol(columnIndex));
        }

        @Override
        public double getDouble(int columnIndex) throws SQLException {
            return this.lookupRS(columnIndex, true).getDouble(this.lookupCol(columnIndex));
        }

        @Override
        @Deprecated
        public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
            return this.lookupRS(columnIndex, true).getBigDecimal(this.lookupCol(columnIndex), scale);
        }

        @Override
        public byte[] getBytes(int columnIndex) throws SQLException {
            return this.lookupRS(columnIndex, true).getBytes(this.lookupCol(columnIndex));
        }

        @Override
        public Date getDate(int columnIndex) throws SQLException {
            return this.lookupRS(columnIndex, true).getDate(this.lookupCol(columnIndex));
        }

        @Override
        public Time getTime(int columnIndex) throws SQLException {
            return this.lookupRS(columnIndex, true).getTime(this.lookupCol(columnIndex));
        }

        @Override
        public Timestamp getTimestamp(int columnIndex) throws SQLException {
            return this.lookupRS(columnIndex, true).getTimestamp(this.lookupCol(columnIndex));
        }

        @Override
        public InputStream getAsciiStream(int columnIndex) throws SQLException {
            return this.lookupRS(columnIndex, true).getAsciiStream(this.lookupCol(columnIndex));
        }

        @Override
        @Deprecated
        public InputStream getUnicodeStream(int columnIndex) throws SQLException {
            return this.lookupRS(columnIndex, true).getUnicodeStream(this.lookupCol(columnIndex));
        }

        @Override
        public InputStream getBinaryStream(int columnIndex) throws SQLException {
            return this.lookupRS(columnIndex, true).getBinaryStream(this.lookupCol(columnIndex));
        }

        @Override
        public String getString(String columnName) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getString(this.lookupCol(columnIndex));
        }

        @Override
        public boolean getBoolean(String columnName) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getBoolean(this.lookupCol(columnIndex));
        }

        @Override
        public byte getByte(String columnName) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getByte(this.lookupCol(columnIndex));
        }

        @Override
        public short getShort(String columnName) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getShort(this.lookupCol(columnIndex));
        }

        @Override
        public int getInt(String columnName) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getInt(this.lookupCol(columnIndex));
        }

        @Override
        public long getLong(String columnName) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getLong(this.lookupCol(columnIndex));
        }

        @Override
        public float getFloat(String columnName) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getFloat(this.lookupCol(columnIndex));
        }

        @Override
        public double getDouble(String columnName) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getDouble(this.lookupCol(columnIndex));
        }

        @Override
        @Deprecated
        public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getBigDecimal(this.lookupCol(columnIndex), scale);
        }

        @Override
        public byte[] getBytes(String columnName) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getBytes(this.lookupCol(columnIndex));
        }

        @Override
        public Date getDate(String columnName) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getDate(this.lookupCol(columnIndex));
        }

        @Override
        public Time getTime(String columnName) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getTime(this.lookupCol(columnIndex));
        }

        @Override
        public Timestamp getTimestamp(String columnName) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getTimestamp(this.lookupCol(columnIndex));
        }

        @Override
        public InputStream getAsciiStream(String columnName) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getAsciiStream(this.lookupCol(columnIndex));
        }

        @Override
        @Deprecated
        public InputStream getUnicodeStream(String columnName) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getUnicodeStream(this.lookupCol(columnIndex));
        }

        @Override
        public InputStream getBinaryStream(String columnName) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getBinaryStream(this.lookupCol(columnIndex));
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            SQLWarning warning = Join.this.outerRS.getWarnings();
            return warning != null ? warning : Join.this.innerRS.getWarnings();
        }

        @Override
        public void clearWarnings() throws SQLException {
            Join.this.outerRS.clearWarnings();
            Join.this.innerRS.clearWarnings();
        }

        @Override
        public String getCursorName() throws SQLException {
            throw new SQLException("This method not implemented.");
        }

        @Override
        public ResultSetMetaData getMetaData() throws SQLException {
            return this;
        }

        @Override
        public Object getObject(int columnIndex) throws SQLException {
            return this.lookupRS(columnIndex, true).getObject(this.lookupCol(columnIndex));
        }

        @Override
        public Object getObject(String columnName) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getObject(this.lookupCol(columnIndex));
        }

        @Override
        public int findColumn(String columnName) throws SQLException {
            int col = -1;
            try {
                col = Join.this.outerRS.findColumn(columnName);
            }
            catch (SQLException sqle) {
                col = Join.this.innerRS.findColumn(columnName);
            }
            if (col == -1) {
                throw new SQLException("Column not found.");
            }
            return col;
        }

        @Override
        public Reader getCharacterStream(int columnIndex) throws SQLException {
            return this.lookupRS(columnIndex, true).getCharacterStream(this.lookupCol(columnIndex));
        }

        @Override
        public Reader getCharacterStream(String columnName) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getCharacterStream(this.lookupCol(columnIndex));
        }

        @Override
        public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
            return this.lookupRS(columnIndex, true).getBigDecimal(this.lookupCol(columnIndex));
        }

        @Override
        public BigDecimal getBigDecimal(String columnName) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getBigDecimal(this.lookupCol(columnIndex));
        }

        @Override
        public void beforeFirst() throws SQLException {
            throw new SQLException("Join ResultSets are forward-only.");
        }

        @Override
        public void afterLast() throws SQLException {
            throw new SQLException("Join ResultSets are forward-only.");
        }

        @Override
        public boolean first() throws SQLException {
            if (this.isBeforeFirst()) {
                return this.next();
            }
            if (this.isFirst()) {
                return true;
            }
            throw new SQLException("Join ResultSets are forward-only.");
        }

        @Override
        public boolean last() throws SQLException {
            throw new SQLException("Join ResultSets are forward-only.");
        }

        @Override
        public boolean isLast() throws SQLException {
            throw new SQLException("Join ResultSets are forward-only.");
        }

        @Override
        public int getRow() throws SQLException {
            return this.rowNum;
        }

        @Override
        public boolean absolute(int row) throws SQLException {
            if (row > 0 && row >= this.rowNum) {
                return this.relative(row - this.rowNum);
            }
            throw new SQLException("Join ResultSets are forward-only.");
        }

        @Override
        public boolean relative(int rows) throws SQLException {
            if (rows >= 0) {
                for (int i = 0; i < rows; ++i) {
                    if (this.next()) continue;
                    return false;
                }
            } else {
                throw new SQLException("Join ResultSets are forward-only.");
            }
            return true;
        }

        @Override
        public boolean previous() throws SQLException {
            throw new SQLException("Join ResultSets are forward-only.");
        }

        @Override
        public void setFetchDirection(int direction) throws SQLException {
            if (direction != 1000) {
                throw new SQLException("Join ResultSets are forward-only.");
            }
        }

        @Override
        public int getFetchDirection() throws SQLException {
            return 1000;
        }

        @Override
        public void setFetchSize(int rows) throws SQLException {
        }

        @Override
        public int getFetchSize() throws SQLException {
            return 1;
        }

        @Override
        public int getType() throws SQLException {
            return 1003;
        }

        @Override
        public int getConcurrency() throws SQLException {
            return 1007;
        }

        @Override
        public boolean rowUpdated() throws SQLException {
            return false;
        }

        @Override
        public boolean rowInserted() throws SQLException {
            return false;
        }

        @Override
        public boolean rowDeleted() throws SQLException {
            return false;
        }

        @Override
        public void updateNull(int columnIndex) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateBoolean(int columnIndex, boolean x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateByte(int columnIndex, byte x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateShort(int columnIndex, short x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateInt(int columnIndex, int x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateLong(int columnIndex, long x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateFloat(int columnIndex, float x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateDouble(int columnIndex, double x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateString(int columnIndex, String x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateBytes(int columnIndex, byte[] x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateDate(int columnIndex, Date x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateTime(int columnIndex, Time x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateObject(int columnIndex, Object x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateNull(String columnName) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateBoolean(String columnName, boolean x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateByte(String columnName, byte x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateShort(String columnName, short x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateInt(String columnName, int x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateLong(String columnName, long x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateFloat(String columnName, float x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateDouble(String columnName, double x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateString(String columnName, String x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateBytes(String columnName, byte[] x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateDate(String columnName, Date x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateTime(String columnName, Time x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateObject(String columnName, Object x, int scale) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateObject(String columnName, Object x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void insertRow() throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateRow() throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void deleteRow() throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void refreshRow() throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void cancelRowUpdates() throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void moveToInsertRow() throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void moveToCurrentRow() throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public Statement getStatement() throws SQLException {
            return null;
        }

        @Override
        public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
            return this.lookupRS(columnIndex, true).getObject(this.lookupCol(columnIndex), map);
        }

        @Override
        public Ref getRef(int columnIndex) throws SQLException {
            return this.lookupRS(columnIndex, true).getRef(this.lookupCol(columnIndex));
        }

        @Override
        public Blob getBlob(int columnIndex) throws SQLException {
            return this.lookupRS(columnIndex, true).getBlob(this.lookupCol(columnIndex));
        }

        @Override
        public Clob getClob(int columnIndex) throws SQLException {
            return this.lookupRS(columnIndex, true).getClob(this.lookupCol(columnIndex));
        }

        @Override
        public Array getArray(int columnIndex) throws SQLException {
            return this.lookupRS(columnIndex, true).getArray(this.lookupCol(columnIndex));
        }

        @Override
        public Object getObject(String columnName, Map<String, Class<?>> map) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getObject(this.lookupCol(columnIndex), map);
        }

        @Override
        public Ref getRef(String columnName) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getRef(this.lookupCol(columnIndex));
        }

        @Override
        public Blob getBlob(String columnName) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getBlob(this.lookupCol(columnIndex));
        }

        @Override
        public Clob getClob(String columnName) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getClob(this.lookupCol(columnIndex));
        }

        @Override
        public Array getArray(String columnName) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getArray(this.lookupCol(columnIndex));
        }

        @Override
        public Date getDate(int columnIndex, Calendar cal) throws SQLException {
            return this.lookupRS(columnIndex, true).getDate(this.lookupCol(columnIndex), cal);
        }

        @Override
        public Date getDate(String columnName, Calendar cal) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getDate(this.lookupCol(columnIndex), cal);
        }

        @Override
        public Time getTime(int columnIndex, Calendar cal) throws SQLException {
            return this.lookupRS(columnIndex, true).getTime(this.lookupCol(columnIndex), cal);
        }

        @Override
        public Time getTime(String columnName, Calendar cal) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getTime(this.lookupCol(columnIndex), cal);
        }

        @Override
        public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
            return this.lookupRS(columnIndex, true).getTimestamp(this.lookupCol(columnIndex), cal);
        }

        @Override
        public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getTimestamp(this.lookupCol(columnIndex), cal);
        }

        @Override
        public URL getURL(int columnIndex) throws SQLException {
            return this.lookupRS(columnIndex, true).getURL(this.lookupCol(columnIndex));
        }

        @Override
        public URL getURL(String columnName) throws SQLException {
            int columnIndex = this.findColumn(columnName);
            return this.lookupRS(columnIndex, true).getURL(this.lookupCol(columnIndex));
        }

        @Override
        public void updateRef(int columnIndex, Ref x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateRef(String columnName, Ref x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateBlob(int columnIndex, Blob x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateBlob(String columnName, Blob x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateClob(int columnIndex, Clob x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateClob(String columnName, Clob x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateArray(int columnIndex, Array x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public void updateArray(String columnName, Array x) throws SQLException {
            throw new SQLException("Join ResultSets are not updateable.");
        }

        @Override
        public int getColumnCount() throws SQLException {
            return this.outerMetaData.getColumnCount() + this.innerMetaData.getColumnCount();
        }

        @Override
        public boolean isAutoIncrement(int column) throws SQLException {
            return this.lookupMD(column).isAutoIncrement(this.lookupCol(column));
        }

        @Override
        public boolean isCaseSensitive(int column) throws SQLException {
            return this.lookupMD(column).isCaseSensitive(this.lookupCol(column));
        }

        @Override
        public boolean isSearchable(int column) throws SQLException {
            return this.lookupMD(column).isSearchable(this.lookupCol(column));
        }

        @Override
        public boolean isCurrency(int column) throws SQLException {
            return this.lookupMD(column).isCurrency(this.lookupCol(column));
        }

        @Override
        public int isNullable(int column) throws SQLException {
            return this.lookupMD(column).isNullable(this.lookupCol(column));
        }

        @Override
        public boolean isSigned(int column) throws SQLException {
            return this.lookupMD(column).isSigned(this.lookupCol(column));
        }

        @Override
        public int getColumnDisplaySize(int column) throws SQLException {
            return this.lookupMD(column).getColumnDisplaySize(this.lookupCol(column));
        }

        @Override
        public String getColumnLabel(int column) throws SQLException {
            return this.lookupMD(column).getColumnLabel(this.lookupCol(column));
        }

        @Override
        public String getColumnName(int column) throws SQLException {
            return this.lookupMD(column).getColumnName(this.lookupCol(column));
        }

        @Override
        public String getSchemaName(int column) throws SQLException {
            return this.lookupMD(column).getSchemaName(this.lookupCol(column));
        }

        @Override
        public int getPrecision(int column) throws SQLException {
            return this.lookupMD(column).getPrecision(this.lookupCol(column));
        }

        @Override
        public int getScale(int column) throws SQLException {
            return this.lookupMD(column).getScale(this.lookupCol(column));
        }

        @Override
        public String getTableName(int column) throws SQLException {
            return this.lookupMD(column).getTableName(this.lookupCol(column));
        }

        @Override
        public String getCatalogName(int column) throws SQLException {
            return this.lookupMD(column).getCatalogName(this.lookupCol(column));
        }

        @Override
        public int getColumnType(int column) throws SQLException {
            return this.lookupMD(column).getColumnType(this.lookupCol(column));
        }

        @Override
        public String getColumnTypeName(int column) throws SQLException {
            return this.lookupMD(column).getColumnTypeName(this.lookupCol(column));
        }

        @Override
        public boolean isReadOnly(int column) throws SQLException {
            return true;
        }

        @Override
        public boolean isWritable(int column) throws SQLException {
            return false;
        }

        @Override
        public boolean isDefinitelyWritable(int column) throws SQLException {
            return false;
        }

        @Override
        public String getColumnClassName(int column) throws SQLException {
            return this.lookupMD(column).getColumnClassName(this.lookupCol(column));
        }
    }
}

