/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.join;

import Zql.ParseException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.mitre.mrald.join.Join;
import org.mitre.mrald.join.PostgresSource;
import org.mitre.mrald.join.SimpleOptimizer;

public class JoinTest {
    public static void main(String[] args) throws SQLException, ClassNotFoundException, ParseException {
        Class.forName("org.postgresql.Driver");
        Connection db1 = DriverManager.getConnection("jdbc:postgresql://brainsrv2.mitre.org:5432/oooiCommon", "postgres", "postgres");
        Statement stmt1 = db1.createStatement(1004, 1007);
        String sql1 = "select oooidataid , carrier, flightno from oooicommon";
        PostgresSource src1 = new PostgresSource(stmt1, sql1);
        int[] col1 = new int[]{1};
        Connection db2 = DriverManager.getConnection("jdbc:postgresql://brainsrv2.mitre.org:5432/oooiDerived", "postgres", "postgres");
        Statement stmt2 = db2.createStatement(1004, 1007);
        String sql2 = "SELECT offtime, intime, oooidataid FROM oooiderived";
        PostgresSource src2 = new PostgresSource(stmt2, sql2);
        int[] col2 = new int[]{3};
        Join join = SimpleOptimizer.chooseJoinAlgorithm(src1, src2, col1, col2, true);
        JoinTest.test(join);
        System.out.println("Done!");
    }

    private static void test(Join algorithm) {
        long start = System.currentTimeMillis();
        try {
            ResultSet rs = algorithm.execute();
            while (rs.next()) {
                if (rs.getRow() % 1000 != 0) continue;
                System.out.print(".");
            }
            long stop = System.currentTimeMillis();
            System.out.println(stop - start + "ms");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

