/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.join;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.mitre.mrald.join.Join;
import org.mitre.mrald.join.PostgresSource;
import org.mitre.mrald.join.Source;

public class NestedLoopJoin
extends Join {
    public NestedLoopJoin(Source outerSource, Source innerSource, int[] outerCols, int[] innerCols) throws SQLException {
        super(outerSource, innerSource, outerCols, innerCols);
    }

    public ResultSet execute() throws SQLException {
        if (this.outerSource.db.getResultSetType() != 1003) {
            this.outerSource.db = this.outerSource.db.getConnection().createStatement(1003, 1007);
        }
        this.outerSource.db.setFetchDirection(100);
        this.innerSource.db.setFetchDirection(100);
        this.outerRS = this.outerSource.getResultSet();
        this.innerRS = this.innerSource.getResultSet();
        return new NestedLoopResultSet();
    }

    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        Class.forName("org.postgresql.Driver");
        Connection db = DriverManager.getConnection("jdbc:postgresql://brainsrv2.mitre.org:5432/digests", "postgres", "postgres");
        Statement stmt1 = db.createStatement(1004, 1007);
        stmt1.execute("SET search_path TO ziph");
        String sql1 = "SELECT * FROM clusterstrategies";
        PostgresSource src1 = new PostgresSource(stmt1, sql1);
        int[] col1 = new int[]{1};
        Statement stmt2 = db.createStatement(1004, 1007);
        stmt2.execute("SET search_path TO ziph");
        String sql2 = "SELECT * FROM clustervalues";
        PostgresSource src2 = new PostgresSource(stmt2, sql2);
        int[] col2 = new int[]{3};
        NestedLoopJoin join = new NestedLoopJoin(src1, src2, col1, col2);
        ResultSet rs = join.execute();
        Source.print(rs);
        System.out.println("Done!");
    }

    private class NestedLoopResultSet
    extends Join.JoinResultSet {
        protected boolean advanceCursor() throws SQLException {
            if (NestedLoopJoin.this.outerRS.isBeforeFirst()) {
                NestedLoopJoin.this.outerRS.next();
            }
            return this.advanceInnerResultSet();
        }

        private boolean advanceOuterResultSet() throws SQLException {
            if (NestedLoopJoin.this.outerRS.next()) {
                return this.resetInnerResultSet();
            }
            return false;
        }

        private boolean advanceInnerResultSet() throws SQLException {
            if (NestedLoopJoin.this.innerRS.next()) {
                return true;
            }
            return this.advanceOuterResultSet();
        }

        private boolean resetInnerResultSet() throws SQLException {
            if (NestedLoopJoin.this.innerRS != null && NestedLoopJoin.this.innerSource.db.getResultSetType() == 1004) {
                return NestedLoopJoin.this.innerRS.first();
            }
            NestedLoopJoin.this.innerRS = NestedLoopJoin.this.innerSource.getResultSet();
            return NestedLoopJoin.this.innerRS.next();
        }
    }
}

