/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.join;

import Zql.ParseException;
import Zql.ZQuery;
import Zql.ZqlJJParser;
import com.sun.rowset.CachedRowSetImpl;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.mitre.mrald.join.Join;
import org.mitre.mrald.join.PostgresSource;
import org.mitre.mrald.join.Source;
import org.mitre.mrald.util.KeySet;

public class SortMergeJoin
extends Join {
    public SortMergeJoin(Source outerSource, Source innerSource, int[] outerCols, int[] innerCols) throws SQLException {
        super(outerSource, innerSource, outerCols, innerCols);
    }

    public ResultSet execute() throws SQLException {
        if (this.outerSource.db.getResultSetType() != 1003) {
            this.outerSource.db = this.outerSource.db.getConnection().createStatement(1003, 1007);
        }
        this.outerSource.db.setFetchSize(100);
        this.outerRS = this.createSortedResultSet(this.outerSource, this.outerCols);
        this.innerRS = this.createSortedResultSet(this.innerSource, this.innerCols);
        if (this.innerSource.db.getResultSetType() != 1004) {
            CachedRowSetImpl cache;
            try {
                cache = new CachedRowSetImpl();
            }
            catch (NullPointerException npe) {
                cache = new CachedRowSetImpl();
            }
            cache.populate(this.innerRS);
            this.innerRS.close();
            this.innerRS = cache;
        }
        return new SortMergeResultSet();
    }

    private ResultSet createSortedResultSet(Source src, int[] cols) throws SQLException {
        try {
            String sql = src.sql;
            if (!sql.contains(";")) {
                sql = sql + ";";
            }
            ZQuery query = new ZqlJJParser((Reader)new StringReader(sql)).QueryStatement();
            Vector selectCols = query.getSelect();
            Vector orderCols = new Vector();
            for (int i = 0; i < cols.length; ++i) {
                int selectIndex = cols[i] - 1;
                orderCols.add(selectCols.get(selectIndex));
            }
            query.addOrderBy(orderCols);
            src.sql = query.toString();
            return src.getResultSet();
        }
        catch (ParseException pe) {
            throw new SQLException(pe.getMessage());
        }
    }

    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        Class.forName("org.postgresql.Driver");
        Connection db = DriverManager.getConnection("jdbc:postgresql://brainsrv2.mitre.org:5432/digests", "postgres", "postgres");
        Statement stmt1 = db.createStatement(1004, 1007);
        stmt1.execute("SET search_path TO ziph");
        String sql1 = "SELECT cstrategy_id, description FROM clusterstrategies";
        PostgresSource src1 = new PostgresSource(stmt1, sql1);
        int[] col1 = new int[]{1};
        Statement stmt2 = db.createStatement(1004, 1007);
        stmt2.execute("SET search_path TO ziph");
        String sql2 = "SELECT cluster_id, num_clusters, cstrategy_id FROM clustervalues WHERE num_clusters >= 8 AND cstrategy_id IN (1,3)";
        PostgresSource src2 = new PostgresSource(stmt2, sql2);
        int[] col2 = new int[]{3};
        SortMergeJoin join = new SortMergeJoin(src2, src1, col2, col1);
        ResultSet rs = join.execute();
        System.out.println(src1.sql);
        System.out.println(src2.sql);
        Source.print(rs);
    }

    private class SortMergeResultSet
    extends Join.JoinResultSet {
        private KeySet outerPtr = null;
        private KeySet innerPtr = null;
        private KeySet markerPtr = null;
        private int markerIndex = -1;

        protected boolean advanceCursor() throws SQLException {
            if (!this.advanceInnerPtr()) {
                return false;
            }
            if (this.markerPtr == null) {
                return this.advanceOuterPtrAndMark();
            }
            if (!this.innerPtr.equals(this.markerPtr)) {
                if (!this.advanceOuterPtr()) {
                    return false;
                }
                if (this.outerPtr.equals(this.markerPtr)) {
                    SortMergeJoin.this.innerRS.absolute(this.markerIndex);
                    this.innerPtr = this.markerPtr;
                } else {
                    return this.advanceOuterPtrAndMark();
                }
            }
            return true;
        }

        private boolean advanceInnerPtr() throws ClassCastException, SQLException {
            boolean result = SortMergeJoin.this.innerRS.next();
            if (result) {
                this.innerPtr = new KeySet(SortMergeJoin.this.innerRS, SortMergeJoin.this.innerCols);
            }
            return result;
        }

        private boolean advanceOuterPtr() throws SQLException {
            boolean result = SortMergeJoin.this.outerRS.next();
            if (result) {
                this.outerPtr = new KeySet(SortMergeJoin.this.outerRS, SortMergeJoin.this.outerCols);
            }
            return result;
        }

        private boolean advanceOuterPtrAndMark() throws SQLException {
            while (this.isOuterLessThanInner()) {
                boolean next = this.advanceOuterPtr();
                if (next) continue;
                return false;
            }
            return true;
        }

        private boolean isOuterLessThanInner() throws SQLException {
            if (this.outerPtr == null) {
                return true;
            }
            int compare = this.outerPtr.compareTo(this.innerPtr);
            KeySet keySet = this.markerPtr = compare == 0 ? this.innerPtr : null;
            if (this.markerPtr != null) {
                this.markerIndex = SortMergeJoin.this.innerRS.getRow();
            }
            return compare < 0;
        }
    }
}

