/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.join;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class Source {
    public Statement db;
    public String sql;
    public int length;
    public int width;

    public ResultSet getResultSet() throws SQLException {
        return this.db.executeQuery(this.sql);
    }

    public abstract void estimateSize() throws SQLException;

    public static final void print(ResultSet rs) throws SQLException {
        System.out.print("Row\t");
        for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
            System.out.print(rs.getMetaData().getColumnName(i));
            System.out.print(i == rs.getMetaData().getColumnCount() ? (char)'\n' : '\t');
        }
        int n = 0;
        while (rs.next()) {
            ++n;
            System.out.print(rs.getRow() + "\t");
            for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                System.out.print(rs.getString(i));
                System.out.print(i == rs.getMetaData().getColumnCount() ? (char)'\n' : '\t');
            }
        }
        System.out.println("(" + n + " rows)");
    }

    public Source(Statement db, String sql, int length, int width) {
        this.db = db;
        this.sql = sql;
        this.length = length;
        this.width = width;
    }

    public Source(Statement db, String sql) {
        this(db, sql, 0, 0);
    }

    public void close() throws SQLException {
        this.db.close();
    }
}

