/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.multiquery;

import java.util.ArrayList;
import java.util.HashMap;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WfController;
import org.mitre.mrald.control.WfControllerException;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.output.FilterOutput;
import org.mitre.mrald.output.OutputManager;
import org.mitre.mrald.parser.ParserElement;
import org.mitre.mrald.query.SqlElements;
import org.mitre.mrald.query.UpdateBuilder;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;

public class MultiUpdateBuilder
extends AbstractStep {
    private MsgObject msg = new MsgObject();

    public MultiUpdateBuilder() {
    }

    public MultiUpdateBuilder(MsgObject thisMessage) {
        this.msg = thisMessage;
    }

    public OutputManager getOutput(MsgObject msg) throws MraldException {
        ArrayList<ParserElement> sqlElements = msg.getWorkingObjects();
        OutputManager output = null;
        String outputManager = null;
        for (int i = 0; i < sqlElements.size(); ++i) {
            SqlElements woElement = (SqlElements)sqlElements.get(i);
            String thisOutputManager = woElement.getOutputType();
            MraldOutFile.appendToFile(Config.getProperty("LOGFILE") + "MQB: Output Type: " + thisOutputManager);
            if (thisOutputManager == null) continue;
            outputManager = thisOutputManager;
        }
        if (outputManager == null) {
            return new FilterOutput();
        }
        if (outputManager.equals("")) {
            return new FilterOutput();
        }
        try {
            msg.setValue("Format", "org.mitre.mrald.output." + outputManager);
            output = (OutputManager)WfController.createObject("org.mitre.mrald.output." + outputManager);
            return output;
        }
        catch (WfControllerException wexp) {
            MraldException qe = new MraldException(wexp.getMessage());
            throw qe;
        }
    }

    public void execute(MsgObject msgObject) throws WorkflowStepException {
        try {
            this.msg = msgObject;
            HashMap orderedElements = this.orderSqlElements(this.msg.getWorkingObjects());
            Integer sqlThreadCount = null;
            int i = 0;
            MsgObject subMsg = new MsgObject();
            int elementCount = 0;
            while (i < orderedElements.size()) {
                if (++elementCount > 50) {
                    throw new WorkflowStepException("MQB: The count has exceeded maximum:");
                }
                ++i;
                sqlThreadCount = new Integer(elementCount);
                boolean keyValExists = orderedElements.containsKey(sqlThreadCount.toString());
                if (!keyValExists) {
                    --i;
                    continue;
                }
                subMsg = new MsgObject();
                UpdateBuilder ub = new UpdateBuilder();
                ArrayList sqlElements = (ArrayList)orderedElements.get(sqlThreadCount.toString());
                subMsg.setWorkingObjects(sqlElements);
                ub.execute(subMsg);
                this.msg.setQuery(MiscUtils.clearSemiColon(subMsg.getQuery()[0]));
                subMsg.clearNvPairs();
                subMsg.closeOut();
            }
        }
        catch (MraldException e) {
            throw new WorkflowStepException(e.getMessage());
        }
    }

    public HashMap orderSqlElements(ArrayList qe) throws MraldException {
        HashMap<String, ArrayList<Object>> orderedElements = new HashMap<String, ArrayList<Object>>();
        SqlElements thisElement = null;
        ArrayList elements = new ArrayList();
        Integer maxNo = new Integer(0);
        Integer thisNo = new Integer(0);
        Integer newNo = new Integer(0);
        for (int i = 0; i < qe.size(); ++i) {
            thisElement = (SqlElements)qe.get(i);
            String sqlNo = thisElement.getSqlNo();
            if (sqlNo.equals("all")) {
                thisNo = new Integer("-1");
                sqlNo = "-1";
                thisElement.setSqlNo(sqlNo);
            } else {
                thisNo = new Integer(sqlNo);
            }
            if (maxNo.compareTo(thisNo) < 0) {
                maxNo = thisNo;
            }
            elements = orderedElements.containsKey(sqlNo) ? (ArrayList)orderedElements.get(thisElement.getSqlNo()) : new ArrayList();
            elements.add(thisElement);
            orderedElements.put(thisElement.getSqlNo(), elements);
        }
        maxNo = new Integer(maxNo + 1);
        ArrayList elementsWithAll = (ArrayList)orderedElements.get("-1");
        if (elementsWithAll != null) {
            for (int k = 0; k < elementsWithAll.size(); ++k) {
                thisElement = (SqlElements)elementsWithAll.get(k);
                for (int j = 0; j < maxNo; ++j) {
                    newNo = new Integer(j);
                    thisElement.setSqlNo(newNo.toString());
                    elements = (ArrayList)orderedElements.get(thisElement.getSqlNo());
                    if (elements == null || elements.size() <= 0) continue;
                    elements.add(thisElement);
                    orderedElements.put(thisElement.getSqlNo(), new ArrayList(elements));
                }
            }
            orderedElements.remove("-1");
        }
        if (orderedElements.get("0") == null) {
            return orderedElements;
        }
        elements = (ArrayList)orderedElements.get("0");
        orderedElements.put(maxNo.toString(), (ArrayList<Object>)orderedElements.get("0"));
        orderedElements.remove("0");
        return orderedElements;
    }
}

