/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.output;

import java.sql.SQLException;
import org.mitre.mrald.output.OutputManagerException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.DomParser;
import org.mitre.mrald.util.MraldParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DbErrorHandler
extends DomParser {
    public static Exception handleException(SQLException se) {
        DbErrorHandler eh = new DbErrorHandler();
        NodeList errors = null;
        try {
            errors = eh.parseErrorFile(Config.getProperty("dbErrFile"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String returnMessage = eh.buildMessage(errors, se.getMessage());
        if (returnMessage != null) {
            RuntimeException mt = new RuntimeException(returnMessage, se);
            return mt;
        }
        return se;
    }

    protected String buildMessage(NodeList errors, String thrownMessage) {
        for (int i = 0; i < errors.getLength(); ++i) {
            Element thisElement = (Element)errors.item(i);
            String number = this.getChildString(thisElement, "number");
            if (thrownMessage.indexOf(number) == -1) continue;
            String title = this.getChildString(thisElement, "title");
            String message = this.getChildString(thisElement, "user_message");
            return this.formatMessage(title, message);
        }
        return null;
    }

    protected String formatMessage(String title, String message) {
        String ret = "For this error (\"" + title + "\")<br /><br /> Please read the following " + "possible solution: " + message;
        return ret;
    }

    protected NodeList parseErrorFile(String filename) throws OutputManagerException {
        try {
            Document document = this.parseFile(filename);
            Element rootElement = document.getDocumentElement();
            if (!rootElement.hasChildNodes()) {
                throw new OutputManagerException("\n The DbErrorHandler XML configuration file specified is invalid. The root element does not contain any child nodes. ");
            }
            return rootElement.getElementsByTagName("error");
        }
        catch (MraldParseException e) {
            throw new OutputManagerException(e.getMessage());
        }
    }
}

