/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.output;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.mitre.mrald.output.XMLOutput;
import org.mitre.mrald.util.GenerateXML;
import org.mitre.mrald.util.GenerateXMLException;
import org.mitre.mrald.util.MraldException;

public class GenerateXMLGraphOutput
extends GenerateXML {
    private int localLineLimit = 1000;
    private float localMbLimit = -1.0f;
    private XMLOutput xmlOutput;
    protected static final String XML_COLUMN_TAG = "<";
    protected static final String XML_COLUMN_END_TAG = "</";
    protected static final String XML_ROWS_TAG = "<rows>";
    protected static final String XML_ROWS_END_TAG = "</rows>";
    protected static final String XML_ROW_TAG = "<row UniqueId = ";
    protected static final String XML_ROW_END_TAG = "</row>";
    private static final int rowIndent = 1;
    private static final int columnIndent = 2;

    public GenerateXMLGraphOutput(PrintWriter oOutputStream) throws GenerateXMLException {
        super(oOutputStream);
    }

    public GenerateXMLGraphOutput(PrintWriter oOutputStream, int lineLimit, float mbLimit, XMLOutput passedXmlOutput) throws GenerateXMLException {
        super(oOutputStream);
        this.localLineLimit = lineLimit;
        this.localMbLimit = mbLimit;
        this.xmlOutput = passedXmlOutput;
    }

    public String GetDBName() throws IOException {
        return null;
    }

    public void RetrieveData() throws MraldException {
        try {
            ResultSet rs = this.xmlOutput.getQryResultsinRS();
            int iColCount = this.xmlOutput.dbNames.length;
            int iRow = 0;
            int fileSize = 0;
            while (rs.next() && (this.localLineLimit == -1 || iRow <= this.localLineLimit) && (this.localMbLimit == -1.0f || (float)fileSize < this.localMbLimit)) {
                this.Indent(1);
                this.Write("<row UniqueId = '" + ++iRow + "'>");
                this.NewLine();
                for (int i = 0; i < iColCount; ++i) {
                    String formattedString = this.xmlOutput.classNames[i].equals("Timestamp") ? this.xmlOutput.getAndFormat(rs.getTimestamp(i + 1), this.xmlOutput.formats[i]) : (this.xmlOutput.classNames[i].equals("BigDecimal") ? this.xmlOutput.getAndFormat(rs.getBigDecimal(i + 1), this.xmlOutput.formats[i]) : rs.getString(i + 1));
                    this.ExportBody(2, this.xmlOutput.dbNames[i], formattedString);
                    try {
                        fileSize += formattedString.length() + this.xmlOutput.dbNames[i].length() + 85;
                        continue;
                    }
                    catch (NullPointerException npe) {
                        fileSize += 85;
                    }
                }
                this.Indent(1);
                this.Write(XML_ROW_END_TAG);
                this.NewLine();
            }
        }
        catch (IOException e) {
            throw new MraldException(e);
        }
        catch (SQLException e) {
            throw new MraldException(e);
        }
    }

    public void ExportHeader(boolean bStylesheet) throws MraldException {
        try {
            this.Write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.NewLine();
            if (bStylesheet) {
                this.Write("");
                this.NewLine();
            }
            if (this.GetStyleSheet() != null) {
                this.Write("<?xml-stylesheet type=\"text/xsl\" href=\"" + this.GetStyleSheet() + "\"?>");
                this.NewLine();
            }
            if (this.IsDefinitionLanguageDTD()) {
                this.Write("<!DOCTYPE " + this.GetRootElementName() + " SYSTEM \"" + this.GetUri() + "\">");
                this.NewLine();
            }
            if (this.IsDefinitionLanguageBiz()) {
                this.Write("<Body>");
                this.NewLine();
            }
            this.WriteRootElementName();
            this.Flush();
        }
        catch (IOException e) {
            throw new MraldException(e);
        }
    }

    public void ExportBody(int iIndentLevel, String sTag, String sValue) throws MraldException {
        try {
            if (sValue == null) {
                sValue = "null";
            }
            this.Indent(iIndentLevel);
            this.Write(XML_COLUMN_TAG + sTag + ">");
            this.NewLine();
            this.Indent(iIndentLevel + 1);
            this.Write(sValue);
            this.NewLine();
            this.Indent(iIndentLevel);
            this.Write(XML_COLUMN_END_TAG + sTag + ">");
            this.NewLine();
        }
        catch (IOException e) {
            throw new MraldException(e);
        }
    }

    protected void WriteRootElementName() throws IOException {
        this.Write(XML_ROWS_TAG);
        this.NewLine();
    }

    protected void WriteEndRootElementName() throws IOException {
        this.Write(XML_ROWS_END_TAG);
        this.NewLine();
    }
}

