/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.output.HTMLOutput;
import org.mitre.mrald.output.OutputManagerException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldParseException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class ParameterOutput
extends HTMLOutput {
    protected Set<String>[] categories;
    protected String algorithmName;
    protected String dataFile;
    protected int maxCategories = Integer.parseInt(Config.getProperty("MAXCATEGORIES"));
    protected char dataFileDelimiter;

    public void formatOutput() throws MraldException {
        try {
            this.algorithmName = this.msg.getValue("Format")[0];
            this.dataFile = this.makeDataFile(this.msg);
        }
        catch (ServletException e) {
            throw new MraldException(e, this.msg);
        }
        catch (IOException e) {
            throw new MraldException(e, this.msg);
        }
        catch (SQLException e) {
            throw new MraldException(e, this.msg);
        }
        super.formatOutput();
    }

    protected void prepareHeaders() {
        this.msg.setContentType("text/html");
        this.msg.setHeader("Content-Disposition", "inline;");
    }

    protected String makeDataFile(MsgObject msg) throws ServletException, IOException, SQLException, OutputManagerException {
        float fileSize;
        String fileLocation = msg.getUserId() + System.currentTimeMillis() + ".data";
        File dir = new File(System.getProperty("java.io.tmpdir"));
        if (!dir.exists()) {
            dir.mkdir();
        }
        FileOutputStream fout = new FileOutputStream(new File(System.getProperty("java.io.tmpdir") + "/" + fileLocation));
        int row_count = 0;
        this.initializeSets(this.niceNames.length);
        for (fileSize = 0.0f; this.rs.next() && (this.lineLimitSize == -1 || row_count < this.lineLimitSize) && (this.mbLimitSize == -1.0f || fileSize < this.mbLimitSize); ++row_count, fileSize += 10.0f) {
            StringBuffer formattedString = new StringBuffer("");
            for (int i = 0; i < this.niceNames.length; ++i) {
                if (!formattedString.toString().equals("")) {
                    formattedString.append(this.dataFileDelimiter);
                }
                String currentValue = this.classNames[i].equals("Timestamp") ? this.getAndFormat(this.rs.getTimestamp(i + 1), this.formats[i]) : (this.classNames[i].equals("BigDecimal") ? this.getAndFormat(this.rs.getBigDecimal(i + 1), this.formats[i]) : (this.classNames[i].equals("String") ? "\"" + this.rs.getString(i + 1) + "\"" : this.rs.getString(i + 1)));
                this.categories[i].add(this.rs.getString(i + 1));
                formattedString.append(currentValue);
                try {
                    fileSize += (float)(formattedString.length() + 9);
                    continue;
                }
                catch (NullPointerException npe) {
                    fileSize += 13.0f;
                }
            }
            fout.write(formattedString.toString().getBytes());
            fout.write(Config.NEWLINE.getBytes());
        }
        this.recordsReturned = row_count;
        this.bytesReturned = fileSize;
        fout.close();
        return System.getProperty("java.io.tmpdir") + "/" + fileLocation;
    }

    public void printBody() throws IOException {
        try {
            this.out.println("<form action=\"FormSubmit\" method=\"POST\">");
            this.out.println("<input type=\"hidden\" name=\"workflow\" value=\"Analysis\">");
            this.out.println("<input type=\"hidden\" name=\"Format\" value=\"" + this.algorithmName + "\">");
            this.out.println("<input type=\"hidden\" name=\"dataFile\" value=\"" + this.dataFile + "\">");
            this.printHeader();
            this.out.println("<br><br>");
            this.printFieldsHTML();
            this.out.println("<br><br>");
            this.printParametersHTML();
            this.out.println("<br><br>");
            this.out.println("<input type=\"submit\" name=\"submit\" value=\"Start Analysis\">");
            this.out.println("<br><br>");
            this.out.println("<input type=\"reset\" name=\"reset\" value=\"Reset Form\">");
            this.out.println("<br><br>");
            this.out.println("</form>");
        }
        catch (DOMException dome) {
            throw new MraldError(dome);
        }
        catch (ParserConfigurationException pce) {
            throw new MraldError(pce);
        }
        catch (MraldParseException mpe) {
            throw new MraldError(mpe);
        }
    }

    protected void printFieldsHTML() {
        boolean canBeInt = false;
        this.printFieldsTableHeader();
        StringBuffer headerRow = new StringBuffer();
        for (int p = 0; p < this.niceNames.length; ++p) {
            String tempNiceNames = this.niceNames[p].replace(' ', '_');
            headerRow.append("<tr>\n<td>\n");
            headerRow.append(tempNiceNames + "\n");
            headerRow.append("<input type=\"hidden\" name=\"Analysis" + p + "\" value=\"Order:" + p + "~Field:" + tempNiceNames + "\">\n");
            headerRow.append("</td>\n<td>\n" + this.classNames[p] + "\n</td>\n");
            headerRow.append("<td>\n");
            canBeInt = !this.categories[p].contains("null") && !this.categories[p].contains("null");
            if (this.categories[p].size() <= this.maxCategories) {
                if (!canBeInt) {
                    headerRow.append(this.categories[p].size() + " (but contains NULL)\n");
                } else {
                    headerRow.append(this.categories[p].size() + "\n");
                }
                headerRow.append(this.printSetContents(p));
            } else {
                headerRow.append("Count Too High For Analysis (" + this.categories[p].size() + ")\n");
            }
            headerRow.append("</td>\n");
            headerRow.append("<td>\n");
            headerRow.append("<select name=\"Analysis" + p + "\">\n");
            headerRow.append(this.getDropDown(this.classNames[p], p, this.categories[p].size(), canBeInt));
            headerRow.append("</select>\n");
            headerRow.append("</td>\n");
            headerRow.append("</tr>");
        }
        this.out.println(headerRow.toString());
        this.printFieldsTableFooter();
    }

    protected abstract String getDropDown(String var1, int var2, int var3, boolean var4);

    protected void initializeSets(int setCount) {
        this.categories = new HashSet[setCount];
        for (int i = 0; i < setCount; ++i) {
            this.categories[i] = new HashSet<String>();
        }
    }

    protected String printSetContents(int setNumber) {
        Iterator<String> iter = this.categories[setNumber].iterator();
        StringBuffer ret = new StringBuffer();
        while (iter.hasNext()) {
            String currentValue = iter.next();
            ret.append("<input type=\"hidden\" name=\"Analysis" + setNumber + "\" value=\"" + currentValue + "\">\n");
        }
        return ret.toString();
    }

    protected void printParametersHTML() throws IOException, DOMException, ParserConfigurationException, MraldParseException {
        this.printParameterTableHeader();
        this.processXML();
        this.out.println("</table>");
    }

    protected String getFieldDropDown() {
        StringBuffer ret = new StringBuffer();
        for (int p = 0; p < this.niceNames.length; ++p) {
            ret.append("<option value=\"" + p + "\">" + this.niceNames[p] + "</option>\n");
        }
        return ret.toString();
    }

    protected void printFieldsTableHeader() {
        this.out.println("<table border='0' width='70%'>");
        this.out.println("<tr><th colspan=\"4\">Template Configuration</th></tr>");
        this.out.println("<tr>");
        this.out.println("<th>Field Name</th>");
        this.out.println("<th>Field Type</th>");
        this.out.println("<th>Category Count</th>");
        this.out.println("<th>Analysis Type</th>");
        this.out.println("</tr>");
    }

    protected void printFieldsTableFooter() {
        this.out.println("</table>");
    }

    protected void printParameterTableHeader() {
        this.out.println("<table border='0' width='70%'>");
        this.out.println("<tr><th colspan=\"3\">Algorithm Parameters</th></tr>");
        this.out.println("<tr>");
        this.out.println("<th width=\"25%\">Name</th>");
        this.out.println("<th width=\"15%\">Default</th>");
        this.out.println("<th>Value</th>");
        this.out.println("</tr>");
    }

    protected void printHeader() {
        this.out.println("<table cellspacing='0' cellpadding='10' border='0' width='70%'>");
        this.out.println("<tr><th>Description</th></tr>");
        this.out.println("<tr><td><br>");
        this.out.println("The information provided below will help guide you through the next step");
        this.out.println("in the data analysis portion of MRALD. Because of the nature of data analysis,");
        this.out.println("the configuration and preparation of the accompanying data and template files");
        this.out.println("are integral to the validation and accuracy of the anaylsis results.  Please");
        this.out.println("modify and review the information below as it will be used to create the template");
        this.out.println("file for the anaylsis as well as define the parameters for the selected algorithm.");
        this.out.println("<br><br></td></tr>");
        this.out.println("</table>");
    }

    protected void processXML() throws IOException, DOMException, ParserConfigurationException, MraldParseException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(Config.getProperty("ANALYSISXML"));
            Element rootElement = document.getDocumentElement();
            if (!rootElement.hasChildNodes()) {
                MraldParseException parsingException = new MraldParseException("The document is invalid. It does not contain any child nodes.");
                throw parsingException;
            }
            NodeList algorithmList = rootElement.getElementsByTagName(this.algorithmName);
            if (algorithmList == null || algorithmList.getLength() != 1) {
                MraldParseException parsingException = new MraldParseException("The document is invalid. There must be at least and at most one node with the name, " + this.algorithmName + ".");
                throw parsingException;
            }
            if (algorithmList.getLength() > 0 && !algorithmList.item(0).hasChildNodes()) {
                this.out.println("<tr>\n<td align=\"center\" colspan=\"3\"><br>No Parameters Associated with this Algorithm<br><br></td>\n</tr>\n");
            } else {
                NodeList parameterList = algorithmList.item(0).getChildNodes();
                for (int i = 0; i < parameterList.getLength(); ++i) {
                    if (parameterList.item(i).getNodeType() == 3) continue;
                    Element currentParameter = (Element)parameterList.item(i);
                    this.out.println("<tr>\n");
                    this.out.println("<td>" + currentParameter.getElementsByTagName("name").item(0).getFirstChild().getNodeValue() + "</td>\n");
                    if (currentParameter.getElementsByTagName("default").getLength() > 0) {
                        this.out.println("<td align=\"center\">" + currentParameter.getElementsByTagName("default").item(0).getFirstChild().getNodeValue() + "</td>\n");
                    } else {
                        this.out.println("<td></td>\n");
                    }
                    if (currentParameter.getElementsByTagName("type").getLength() > 0) {
                        if (currentParameter.getElementsByTagName("type").item(0).getFirstChild().getNodeValue().equals("FieldDropDown")) {
                            this.out.print("<td>");
                            this.out.println("<select name=\"" + currentParameter.getElementsByTagName("fieldname").item(0).getFirstChild().getNodeValue() + "\">");
                            this.out.print(this.getFieldDropDown());
                            this.out.println("</select>");
                            this.out.println("</td>");
                        } else if (currentParameter.getElementsByTagName("type").item(0).getFirstChild().getNodeValue().equals("textfield")) {
                            this.out.print("<td>");
                            this.out.print("<input type=\"textfield\" ");
                            this.out.print(" size=\"" + currentParameter.getElementsByTagName("size").item(0).getFirstChild().getNodeValue() + "\"");
                            this.out.print(" name=\"" + currentParameter.getElementsByTagName("fieldname").item(0).getFirstChild().getNodeValue() + "\"");
                            this.out.print(" value=\"" + currentParameter.getElementsByTagName("default").item(0).getFirstChild().getNodeValue() + "\"");
                            this.out.print(">");
                            this.out.println("</td>");
                        } else if (currentParameter.getElementsByTagName("type").item(0).getFirstChild().getNodeValue().equals("checkbox")) {
                            this.out.print("<td>");
                            this.out.print("<input type=\"checkbox\" ");
                            this.out.print(" name=\"" + currentParameter.getElementsByTagName("fieldname").item(0).getFirstChild().getNodeValue() + "\"");
                            this.out.print(" CHECKED ");
                            this.out.print(">");
                            this.out.println("</td>");
                        }
                    }
                    this.out.println("</tr>\n");
                }
            }
        }
        catch (SAXParseException spe) {
            spe.printStackTrace();
            MraldParseException parsingException = new MraldParseException("\n** Parsing error, line " + spe.getLineNumber() + ", uri " + spe.getSystemId() + spe.getMessage());
            if (spe.getException() != null) {
                // empty if block
            }
            throw parsingException;
        }
        catch (SAXException spe) {
            MraldParseException parsingException = new MraldParseException(spe.getMessage());
            throw parsingException;
        }
        catch (DOMException de) {
            throw de;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (ParserConfigurationException pce) {
            throw pce;
        }
    }
}

