/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.output;

import java.io.IOException;
import java.sql.SQLException;
import org.mitre.mrald.output.OutputManager;
import org.mitre.mrald.query.BroadcastQueryTarget;
import org.mitre.mrald.util.Config;

public class TextOutput
extends OutputManager {
    String formatType = "";

    public void printNewResultHeader(BroadcastQueryTarget t) {
        this.out.println(Config.NEWLINE + "===>> Data from datasource " + t.getName() + " at: " + t.getUrl());
    }

    public void printBody() throws IOException, SQLException {
        if (this.formatType.equals("fileCsv")) {
            this.printTextResults(this.msg.getValue("fileFormatDelimiter")[0]);
        } else if (this.formatType.equals("fileText")) {
            this.printTextResults("\t");
        } else if (this.formatType.equals("browserCsv")) {
            this.printTextResults(this.msg.getValue("browserFormatDelimiter")[0]);
        } else {
            this.printTextResults("\t");
        }
        this.out.println();
    }

    protected void prepareHeaders() {
        String filename_base = this.msg.getValue("form")[0];
        if (filename_base.equals("")) {
            filename_base = "output";
        }
        this.formatType = this.msg.getValue("Format")[0];
        if (this.formatType.equals("fileCsv")) {
            this.msg.setContentType("application/text");
            this.msg.setHeader("Content-Disposition", "attachment; filename=" + filename_base + ".csv;");
        } else if (this.formatType.equals("fileText")) {
            this.msg.setContentType("application/text");
            this.msg.setHeader("Content-Disposition", "attachment; filename=" + filename_base + ".txt;");
        } else {
            this.msg.setContentType("text/plain");
            this.msg.setHeader("Content-Disposition", "inline;");
        }
    }

    private void printTextResults(String delim) throws SQLException, IOException {
        int row_count;
        for (int p = 0; p < this.niceNames.length; ++p) {
            this.out.print(this.niceNames[p]);
            if (p >= this.niceNames.length - 1) continue;
            this.out.print(delim);
        }
        this.out.println();
        float fileSize = 0.0f;
        for (row_count = 0; this.rs.next() && (this.lineLimitSize == -1 || row_count < this.lineLimitSize) && (this.mbLimitSize == -1.0f || fileSize < this.mbLimitSize); ++row_count) {
            for (int i = 0; i < this.niceNames.length; ++i) {
                String formattedString = this.classNames[i].equals("Timestamp") ? this.getAndFormat(this.rs.getTimestamp(i + 1), this.formats[i]) : (this.classNames[i].equals("BigDecimal") ? this.getAndFormat(this.rs.getBigDecimal(i + 1), this.formats[i]) : this.rs.getString(i + 1));
                this.out.print(formattedString);
                if (i < this.niceNames.length - 1) {
                    this.out.print(delim);
                }
                try {
                    fileSize += (float)(formattedString.length() + 1);
                    continue;
                }
                catch (NullPointerException npe) {
                    fileSize += 5.0f;
                }
            }
            this.out.println();
        }
        this.recordsReturned = row_count;
        this.bytesReturned = fileSize;
    }
}

