/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.output;

import java.io.IOException;
import java.sql.SQLException;
import org.mitre.mrald.output.TextOutput;

public class TextTabularOutput
extends TextOutput {
    private final String TAB = "\t";

    public void prepareHeaders() {
        String filename_base = this.msg.getValue("form")[0];
        if (filename_base.equals("")) {
            filename_base = "output";
        }
        this.formatType = this.msg.getValue("Format")[0];
        if (this.formatType.equals("fileTabularText")) {
            this.msg.setContentType("application/text");
            this.msg.setHeader("Content-Disposition", "attachment; filename=" + filename_base + ".txt;");
        } else {
            this.msg.setContentType("text/plain");
            this.msg.setHeader("Content-Disposition", "inline;");
        }
    }

    public void printBody() throws SQLException, IOException {
        int row_count;
        float fileSize = 0.0f;
        for (row_count = 0; this.rs.next() && (this.lineLimitSize == -1 || row_count < this.lineLimitSize) && (this.mbLimitSize == -1.0f || fileSize < this.mbLimitSize); ++row_count) {
            String headerStr = "<------------------------------------------->";
            this.out.println(headerStr);
            for (int i = 0; i < this.niceNames.length; ++i) {
                this.out.print(this.niceNames[i] + "\t");
                String formattedString = this.classNames[i].equals("Timestamp") ? this.getAndFormat(this.rs.getTimestamp(i + 1), this.formats[i]) : (this.classNames[i].equals("BigDecimal") ? this.getAndFormat(this.rs.getBigDecimal(i + 1), this.formats[i]) : this.rs.getString(i + 1));
                this.out.println(formattedString);
                try {
                    fileSize += (float)(formattedString.length() + 1);
                    continue;
                }
                catch (NullPointerException npe) {
                    fileSize += 5.0f;
                }
            }
            this.out.println();
        }
        this.recordsReturned = row_count;
        this.bytesReturned = fileSize;
    }
}

