/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.output;

import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.output.HTMLOutput;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.TableMetaData;
import org.mitre.mrald.util.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateListOutput
extends HTMLOutput {
    private String keyTable = null;
    private String[] primaryKeyCols = null;
    private String datasource = null;
    private DBMetaData md = null;
    private HashMap fkInfo;
    private String successRedir;

    @Override
    public void execute(MsgObject msg) throws WorkflowStepException {
        this.successRedir = msg.getValue("SuccessUrl")[0];
        this.keyTable = msg.getValue("table")[0];
        this.datasource = msg.getValue("Datasource")[0];
        this.keyTable = MiscUtils.replace(this.keyTable, "\"", "");
        this.primaryKeyCols = msg.getValue("PrimaryKey");
        String datasource = msg.getValue("Datasource")[0];
        this.md = MetaData.getDbMetaData(datasource);
        TableMetaData tableInfo = null;
        if (this.primaryKeyCols.length == 0) {
            if (this.keyTable != null) {
                tableInfo = this.md.getTableMetaData(this.keyTable);
                this.primaryKeyCols = (String[])tableInfo.getPrimaryKeys().toArray();
            } else {
                throw new WorkflowStepException("You must have a table specified to Update.");
            }
        }
        this.fkInfo = this.getFKInfo(msg);
        User user = (User)msg.getReq().getSession().getAttribute(Config.getProperty("cookietag"));
        if (user == null) {
            throw new WorkflowStepException("You must login to perform this operation");
        }
        super.execute(msg);
    }

    @Override
    public void printBody() throws IOException, SQLException {
        float fileSize;
        this.out.println("<table><tr>");
        this.out.println("<form enctype='x-www-form-urlencoded' action='FormSubmit' method='POST' name=\"o\">");
        if (this.datasource != null && !this.datasource.equals("")) {
            this.out.println("<input type=\"hidden\" name=\"Datasource\" value=\"" + this.datasource + "\" />");
        }
        this.out.println("<input name=\"Schema\" type=\"hidden\" value=\"public\"><input name=\"form\" type=\"hidden\" value=\"Update Table " + this.keyTable + "\"><input value='UpdateRow' name='workflow' type='hidden'>");
        StringBuffer headerRow = new StringBuffer("<tr>");
        for (int p = 0; p < this.niceNames.length; ++p) {
            headerRow.append("<th>" + this.niceNames[p] + "</th>");
        }
        headerRow.append("<th>Update</th></tr>");
        this.out.println(headerRow.toString());
        int row_count = 0;
        ResultSetMetaData rsmd = this.rs.getMetaData();
        String fkValues = "";
        for (fileSize = 0.0f; this.rs.next() && (this.lineLimitSize == -1 || row_count < this.lineLimitSize) && (this.mbLimitSize == -1.0f || fileSize < this.mbLimitSize); fileSize += 10.0f) {
            this.out.print("<tr>");
            boolean isPk = false;
            String pkValues = "";
            for (int i = 0; i < this.niceNames.length; ++i) {
                String formattedString;
                String colName = rsmd.getColumnName(i + 1);
                for (int j = 0; j < this.primaryKeyCols.length; ++j) {
                    if (!this.primaryKeyCols[j].equals(colName)) continue;
                    isPk = true;
                    pkValues = pkValues + "&" + colName + "=";
                }
                if (this.fkInfo.containsKey(colName)) {
                    fkValues = fkValues + (String)this.fkInfo.get(colName);
                }
                if (this.classNames[i].equals("Timestamp")) {
                    formattedString = this.getAndFormat(this.rs.getTimestamp(i + 1), this.formats[i]);
                    if (isPk) {
                        pkValues = pkValues + this.rs.getTimestamp(i + 1);
                    }
                } else if (this.classNames[i].equals("BigDecimal")) {
                    formattedString = this.getAndFormat(this.rs.getBigDecimal(i + 1), this.formats[i]);
                    if (isPk) {
                        pkValues = pkValues + this.rs.getBigDecimal(i + 1);
                    }
                } else {
                    if (isPk) {
                        pkValues = pkValues + this.rs.getString(i + 1);
                    }
                    formattedString = this.rs.getString(i + 1);
                }
                this.out.print("<td>" + formattedString + "</td>");
                try {
                    fileSize += (float)(formattedString.length() + 9);
                }
                catch (NullPointerException npe) {
                    fileSize += 13.0f;
                }
                isPk = false;
            }
            String updateInfo = "<td><input type='hidden' name='updateRow" + row_count + "' value=\"Table:" + this.keyTable + "~Column:" + this.primaryKeyCols[0] + "~Value:" + this.rs.getString(1) + "\">";
            this.out.println(updateInfo);
            updateInfo = "<input type='button' name='updateRow" + row_count + "' value='Update'  onclick=\"dest='Update.jsp?datasource=" + this.datasource + "&tableName=" + this.keyTable + MiscUtils.checkApostrophe(pkValues) + fkValues + "&SuccessUrl=" + this.successRedir + "'; location=dest\">";
            this.out.println(updateInfo);
            String deleteInfo = "<input type='button' name='deleteRow" + row_count + "' value='Delete'  onclick=\"location='Delete.jsp?datasource=" + this.datasource + "&tableName=" + this.keyTable + MiscUtils.checkApostrophe(pkValues) + "';\"></td>";
            this.out.println(deleteInfo);
            this.out.println("</tr>");
            if ((double)(++row_count) / 1000.0 != (double)((int)((double)row_count / 1000.0))) continue;
            this.out.println("</table><table border='1' cellpadding='3'>" + headerRow.toString());
        }
        this.recordsReturned = row_count;
        this.bytesReturned = fileSize;
    }

    private HashMap<String, String> getFKInfo(MsgObject msg) {
        int i = 1;
        String[] fks = msg.getValue("fKey" + i);
        HashMap<String, String> linkInfo = new HashMap<String, String>();
        while (i < 100) {
            if (fks == null || fks.length == 0 || fks[0].equals("")) {
                fks = msg.getValue("fKey" + ++i);
                continue;
            }
            String fKeyInfo = "&fKey" + i + "=" + fks[0];
            fKeyInfo = fKeyInfo + "&" + "fKeyTable" + i + "=" + msg.getValue("fKeyTable" + i)[0];
            fKeyInfo = fKeyInfo + "&" + "fKeyId" + i + "=" + msg.getValue("fKeyId" + i)[0];
            fKeyInfo = fKeyInfo + "&" + "fKeyList" + i + "=" + msg.getValue("fKeyList" + i)[0];
            linkInfo.put(fks[0], fKeyInfo);
            fks = msg.getValue("fKey" + ++i);
        }
        return linkInfo;
    }
}

