/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.output;

import java.io.IOException;
import java.sql.SQLException;
import javax.sql.rowset.WebRowSet;
import org.mitre.mrald.output.GenerateXMLOutput;
import org.mitre.mrald.output.OutputManager;
import org.mitre.mrald.query.BroadcastQueryTarget;
import org.mitre.mrald.util.GenerateXMLException;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.RowSetFactory;

public class XMLOutput
extends OutputManager {
    protected String[] dbNames;

    public void printBody() throws IOException, SQLException {
        boolean bStyled = false;
        float mbLimit = this.getMbLimitSize();
        try {
            if (this.msg.getValue("Format")[0].equals("XmlStyled")) {
                bStyled = true;
            }
            String[] queries = this.msg.getQuery();
            for (int i = 0; i < queries.length; ++i) {
                WebRowSet wrs;
                try {
                    wrs = RowSetFactory.createWebRowSet();
                    wrs.writeXml(this.rs, this.out);
                    continue;
                }
                catch (MraldException e) {
                    this.out.write("<!--Error!  The WebRowSet specified in standard.properties was not found - falling back to non-standard version-->");
                    wrs = null;
                    GenerateXMLOutput xmlGenerate = new GenerateXMLOutput(this.out, this.getLineLimitSize(), mbLimit, this, this.printQuery);
                    xmlGenerate.GenerateDocument(queries[i], bStyled);
                }
            }
        }
        catch (GenerateXMLException e) {
            throw new MraldError(e, this.msg);
        }
        catch (MraldException e) {
            throw new MraldError(e, this.msg);
        }
    }

    protected void prepareHeaders() {
        this.msg.setContentType("text/xml");
    }

    protected void setDBFormats() {
        this.dbNames = new String[this.niceNames.length];
        System.arraycopy(this.niceNames, 0, this.dbNames, 0, this.niceNames.length);
    }

    public void printNewResultHeader(BroadcastQueryTarget t) {
    }
}

